/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.event;

import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LevelEventHandler {
    private static final String ERROR_LISTENER_CONTAINS = "Listener already contains in LevelEventHandler";
    private static Logger logger = Logger.getLogger(LevelEventHandler.class);
    private HashMap<Integer, ArrayList<AppEventListener>> handlers = new HashMap();

    LevelEventHandler() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void add(Integer theEventID, AppEventListener theListener) {
        if (this.handlers.containsKey(theEventID)) {
            if (this.contains(theEventID, theListener)) throw new IllegalArgumentException(ERROR_LISTENER_CONTAINS);
            this.getListeners(theEventID).add(theListener);
            return;
        } else {
            ArrayList<AppEventListener> array = new ArrayList<AppEventListener>();
            array.add(theListener);
            this.handlers.put(theEventID, array);
        }
    }

    boolean contains(Integer theEventID, AppEventListener theListener) {
        return this.getListeners(theEventID).contains(theListener);
    }

    void remove(Integer theEventID, AppEventListener theListener) {
        ArrayList<AppEventListener> arrayList = this.getListeners(theEventID);
        if (arrayList != null) {
            arrayList.remove(theListener);
            if (arrayList.isEmpty()) {
                this.handlers.remove(theEventID);
            }
        }
    }

    void process(AppEvent event) {
        Integer eventID = event.getEventID();
        ArrayList<AppEventListener> listenerList = this.getListeners(eventID);
        if (listenerList != null) {
            AppEventListener[] listeners = listenerList.toArray(new AppEventListener[listenerList.size()]);
            if (SwingUtilities.isEventDispatchThread()) {
                LevelEventHandler.handleEvent(event, listeners);
            } else {
                SwingUtilities.invokeLater(new Runner(event, listeners));
            }
        }
    }

    private static void handleEvent(AppEvent event, AppEventListener[] listeners) {
        for (AppEventListener listener : listeners) {
            if (listener == null) {
                logger.warn((Object)("listener is null for " + event));
                continue;
            }
            if (!listener.isListenerEnabled()) continue;
            listener.handle(event);
        }
    }

    ArrayList<AppEventListener> getListeners(Integer theEventID) {
        return this.handlers.get(theEventID);
    }

    boolean isEmpty() {
        return this.handlers.isEmpty();
    }

    int size() {
        return this.handlers.size();
    }

    int getListenersCount() {
        int result = 0;
        try {
            for (ArrayList<AppEventListener> listeners : this.handlers.values()) {
                if (listeners == null) continue;
                result += listeners.size();
            }
        }
        catch (Exception e) {
            logger.warn((Object)e.toString());
        }
        return result;
    }

    private static class Runner
    implements Runnable {
        private AppEvent event;
        private AppEventListener[] listeners;

        public Runner(AppEvent theAppEvent, AppEventListener[] listeners) {
            this.event = theAppEvent;
            this.listeners = listeners;
        }

        public void run() {
            LevelEventHandler.handleEvent(this.event, this.listeners);
        }
    }
}

