/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.utils;

import com.appframework.utils.Pair;
import com.appframework.utils.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InstanceCounter {
    private static Logger logger = Logger.getLogger(InstanceCounter.class);
    private static Map<Class, Pair<Integer, Integer>> instances = new HashMap<Class, Pair<Integer, Integer>>();
    private int instanceId = -1;
    private Class clazz = null;

    public InstanceCounter(Object parent) {
        this.clazz = Validator.notNull(parent).getClass();
        this.instanceId = InstanceCounter.addInstance(this.clazz);
        this.printLog("created");
    }

    protected void finalize() throws Throwable {
        InstanceCounter.removeInstance(this.clazz);
        this.printLog("finalized");
        super.finalize();
    }

    private void printLog(String prefix) {
        logger.debug((Object)(prefix + " instance #" + this.instanceId + " of " + this.clazz.getName() + " (" + InstanceCounter.getLiveInstanceCount(this.clazz) + " remain)"));
    }

    public String toString() {
        return "InstanceCounter [clazz=" + this.clazz.getName() + ", instanceId=" + this.instanceId + " (" + InstanceCounter.getLiveInstanceCount(this.clazz) + " remain)" + ']';
    }

    private static synchronized int addInstance(Class clazz) {
        int instanceId;
        Pair<Integer, Integer> pair = instances.get(clazz);
        if (pair == null) {
            pair = new Pair<Integer, Integer>(1, 1);
            instanceId = 1;
            instances.put(clazz, pair);
        } else {
            instanceId = pair.getSecond() + 1;
            pair.setFirst(pair.getFirst() + 1);
            pair.setSecond(instanceId);
        }
        return instanceId;
    }

    private static synchronized void removeInstance(Class clazz) {
        Pair<Integer, Integer> pair = instances.get(clazz);
        Validator.notNull(pair);
        pair.setFirst(pair.getFirst() - 1);
    }

    public static synchronized int getLiveInstanceCount(Class clazz) {
        Pair<Integer, Integer> pair = instances.get(clazz);
        return pair == null ? 0 : pair.getFirst();
    }

    public static synchronized int getCreatedInstanceCount(Class clazz) {
        Pair<Integer, Integer> pair = instances.get(clazz);
        return pair == null ? 0 : pair.getSecond();
    }

    static synchronized Class[] getClasses() {
        Set<Class> keySet = instances.keySet();
        if (keySet.size() == 0) {
            return new Class[0];
        }
        Class[] keys = new ArrayList<Class>(keySet).toArray(new Class[keySet.size()]);
        Class[] result = new Class[keys.length];
        System.arraycopy(keys, 0, result, 0, keys.length);
        return result;
    }

    public static synchronized String getInfo() {
        StringBuffer buffer = new StringBuffer("InstanceCounter report:/n");
        Set<Class> keySet = instances.keySet();
        for (Class clazz : keySet) {
            Pair<Integer, Integer> pair = instances.get(clazz);
            buffer.append(clazz.getName());
            buffer.append(" (");
            buffer.append(pair.getFirst());
            buffer.append(", ");
            buffer.append(pair.getSecond());
            buffer.append(')');
            buffer.append(pair.getFirst().equals(pair.getSecond()) ? " <-- potential memory leak" : "");
            buffer.append("/n");
        }
        return buffer.toString();
    }
}

