/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.utils;

import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MultilineOptionPane {
    private static Logger logger = Logger.getLogger(MultilineOptionPane.class);
    private static final int CLOSE_OPTION = -1;
    public static final int ABORT_OPTION = 0;
    public static final int RETRY_OPTION = 1;
    public static final int IGNORE_OPTION = 2;
    private static String[] OPTIONS = new String[]{StringResources.ABORT, StringResources.RETRY, StringResources.IGNORE};

    public static int showConfirmDialog(final Component theParentComponent, final Object[] theMessageLines, final String theTitle) {
        final int[] result = new int[1];
        if (SwingUtilities.isEventDispatchThread()) {
            result[0] = MultilineOptionPane.doShowConfirmDialog(theParentComponent, theMessageLines, theTitle);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        result[0] = MultilineOptionPane.doShowConfirmDialog(theParentComponent, theMessageLines, theTitle);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return result[0];
    }

    private static int doShowConfirmDialog(Component theParentComponent, Object[] theMessageLines, String theTitle) {
        int result;
        StringBuffer stringBuffer = new StringBuffer();
        if (theMessageLines != null) {
            for (int i = 0; i < theMessageLines.length; ++i) {
                Object messageLine = theMessageLines[i];
                if (messageLine == null) continue;
                if (i > 0) {
                    stringBuffer.append("<br><br>");
                }
                stringBuffer.append(messageLine);
            }
        }
        String message = "";
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, "<html>").append("</html>");
            message = stringBuffer.toString().replaceAll(System.getProperty("line.separator"), "<br>");
        }
        if ((result = JOptionPane.showOptionDialog(theParentComponent, message, theTitle, -1, -1, null, OPTIONS, OPTIONS[0])) == -1) {
            return 0;
        }
        return result;
    }
}

