/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.utils;

import com.apple_wrappers.ApplicationAdapterWrapper;
import com.apple_wrappers.ApplicationEventWrapper;
import com.apple_wrappers.ApplicationWrapper;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.dialogs.AboutDialog;
import com.novell.gw.jclient.application.startup.ComposeMailDispatcher;
import com.novell.gw.jclient.application.startup.OpenMailEvent;
import java.io.File;
import org.apache.log4j.Logger;

public class OSXAdapter
extends ApplicationAdapterWrapper {
    private static Logger logger = Logger.getLogger(OSXAdapter.class);
    private static OSXAdapter adapter;
    private GWClient mainApp;
    private static ApplicationEventWrapper applicationEvent;
    private static boolean waiting;

    private OSXAdapter(GWClient theMainApp) {
        this.mainApp = theMainApp;
    }

    public void handleAbout(ApplicationEventWrapper ae) {
        logger.debug((Object)"handle About by OSX");
        if (this.mainApp == null) {
            throw new IllegalStateException("handleAbout: GWClient instance detached from listener");
        }
        ae.setHandled(true);
        AboutDialog aboutDialog = new AboutDialog();
        aboutDialog.pack();
        aboutDialog.setLocationRelativeTo(null);
        aboutDialog.setVisible(true);
    }

    public void handlePreferences(ApplicationEventWrapper ae) {
        logger.debug((Object)"handle Preferences by OSX");
        if (this.mainApp == null) {
            throw new IllegalStateException("handlePreferences: GWClient instance detached from listener");
        }
        OSXAdapter oSXAdapter = this;
        oSXAdapter.mainApp.actionPreferences();
        ae.setHandled(true);
    }

    public void handleQuit(ApplicationEventWrapper ae) {
        logger.debug((Object)"handle Quit by OSX");
        applicationEvent = ae;
        if (this.mainApp != null) {
            applicationEvent.setHandled(false);
            if (GWClient.isNotifierRunning() && !GWClient.isGwClientRunning()) {
                GWClient.exitNotify();
            } else if (GWClient.isGwClientRunning()) {
                GWClient.exitClient();
            }
        } else {
            throw new IllegalStateException("handleQuit: GWClient instance detached from listener");
        }
    }

    public void handleOpenFile(ApplicationEventWrapper ae) {
        logger.debug((Object)"handle Open File by OSX");
        File fileToOpen = new File(ae.getFilename());
        if (fileToOpen.exists()) {
            ComposeMailDispatcher.dispatchEvent(new OpenMailEvent(fileToOpen));
            ae.setHandled(true);
        }
    }

    public static void registerMacOSXApplication(GWClient inApp) {
        logger.debug((Object)"registerMacOSXApplication");
        if (adapter == null) {
            adapter = new OSXAdapter(inApp);
            try {
                ApplicationWrapper.getApplication().addApplicationListener(adapter);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)e);
                logger.warn((Object)"Failed to register OSXAdaptor");
            }
        }
    }

    public static void enablePrefs(boolean enabled) {
        try {
            ApplicationWrapper.getApplication().setEnabledPreferencesMenu(enabled);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
            logger.warn((Object)"Can't enable/disable preferences menu");
        }
    }

    public static void setHandled(boolean handled) {
        waiting = false;
        if (applicationEvent != null) {
            System.out.println("setHandled:" + handled);
            applicationEvent.setHandled(handled);
        }
    }

    static {
        applicationEvent = null;
        waiting = false;
    }
}

