/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.utils;

import com.appframework.utils.OS;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.Field;
import org.apache.log4j.Logger;

public class ToolkitUtils {
    private static Logger logger = Logger.getLogger(ToolkitUtils.class);

    public static boolean isModalExclusionTypeSupported(ModalExclusionType modalExclusionType) {
        if (OS.getJavaVersionMajor() > 1 || OS.getJavaVersionMinor() > 5) {
            boolean result = false;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            try {
                Class<?> exclusionTypeClass = Class.forName("java.awt.Dialog$ModalExclusionType");
                Field exclusionTypeClassField = exclusionTypeClass.getDeclaredField(modalExclusionType.getName());
                Object parameter = exclusionTypeClassField.get(null);
                result = (Boolean)Toolkit.class.getMethod("isModalExclusionTypeSupported", exclusionTypeClass).invoke((Object)toolkit, parameter);
            }
            catch (Exception e) {
                logger.error((Object)e);
                logger.debug((Object)e, (Throwable)e);
            }
            return result;
        }
        return false;
    }

    public static void setWindowModalExclusionType(Window window, ModalExclusionType modalExclusionType) {
        if (window == null) {
            throw new IllegalArgumentException("window is null");
        }
        if (modalExclusionType == null) {
            throw new IllegalArgumentException("modalExclusionType is null");
        }
        try {
            Class<?> exclusionTypeClass = Class.forName("java.awt.Dialog$ModalExclusionType");
            Field exclusionTypeClassField = exclusionTypeClass.getDeclaredField(modalExclusionType.getName());
            Object parameter = exclusionTypeClassField.get(null);
            window.getClass().getMethod("setModalExclusionType", exclusionTypeClass).invoke((Object)window, parameter);
        }
        catch (Exception e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ModalExclusionType {
        APPLICATION_EXCLUDE{

            public String getName() {
                return "APPLICATION_EXCLUDE";
            }
        };


        public abstract String getName();
    }
}

