/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.utils;

import com.appframework.utils.OS;
import com.novell.gw.jclient.application.controls.popedit.StringParser;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.SpecifyArchiveDirectoryDialog;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.PathManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Array;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static Logger logger = Logger.getLogger(Utils.class);
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String USER_DIR = System.getProperty("user.dir");
    public static final String USER_HOME = System.getProperty("user.home");
    private static final String FILE_RUN_BAT = "run.bat";
    public static final String JAR_NAME = "gwclient.jar";
    private static Date gwFileDate = null;
    private static GraphicsConfiguration DEFAULT_SCREEN_CONFIGURATION = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();

    public static String getTheLongestTextOnScreen(Dimension dimension, Font font, List<String> strings) {
        BufferedImage bufferedImage = DEFAULT_SCREEN_CONFIGURATION.createCompatibleImage(dimension.width, dimension.height);
        Graphics2D canvas = (Graphics2D)bufferedImage.getGraphics();
        FontRenderContext fontRendererContext = canvas.getFontRenderContext();
        int maxWidth = 0;
        String longestText = null;
        for (String text : strings) {
            GlyphVector glyphs = font.createGlyphVector(fontRendererContext, text);
            if (glyphs.getOutline().getBounds().width <= maxWidth) continue;
            maxWidth = glyphs.getOutline().getBounds().width;
            longestText = text;
        }
        return longestText;
    }

    public static void runShellAsync(String[] theCommands) {
        new ShellStarter(theCommands).start();
    }

    public static String getExtention(String sFileName) {
        if (sFileName == null) {
            return null;
        }
        File file = new File(sFileName);
        String fileName = file.getName();
        int nExtensionIndex = fileName.lastIndexOf(".");
        if (nExtensionIndex < 0) {
            return sFileName;
        }
        String sExtension = fileName.substring(nExtensionIndex + 1);
        return sExtension;
    }

    public static String getClassDirectory(Class theClass) {
        String name = theClass.getName();
        int dotIndex = name.lastIndexOf(".");
        URL url = dotIndex != -1 ? theClass.getResource(name.substring(dotIndex + 1) + ".class") : theClass.getResource(name + ".class");
        StringBuffer sb = new StringBuffer(new File(url.getFile()).getParent());
        sb.append(System.getProperty("file.separator"));
        return sb.toString();
    }

    public static Date getClassDate(Class theClass) {
        if (gwFileDate == null && theClass != null) {
            File checkFile;
            String name = theClass.getName();
            int dotIndex = name.lastIndexOf(".");
            URL url = dotIndex != -1 ? theClass.getResource(name.substring(dotIndex + 1) + ".class") : theClass.getResource(name + ".class");
            String classFile = URLDecoder.decode(url.getFile());
            int lastIndex = classFile.lastIndexOf(JAR_NAME);
            if (lastIndex != -1) {
                String jarPath;
                int firstIndex = classFile.indexOf("file:");
                if (firstIndex != -1) {
                    firstIndex += 5;
                }
                if ((checkFile = new File(jarPath = classFile.substring(firstIndex, lastIndex + JAR_NAME.length()))).exists()) {
                    gwFileDate = new Date(checkFile.lastModified());
                }
            }
            if (gwFileDate == null && (checkFile = new File(classFile)).exists()) {
                gwFileDate = new Date(checkFile.lastModified());
            }
        }
        return gwFileDate;
    }

    public static String normalizePreviewFileName(String theFileNameStr) {
        String tmp = theFileNameStr.toUpperCase();
        if (!tmp.endsWith(".HTML") && !tmp.endsWith(".HTM")) {
            theFileNameStr = theFileNameStr + ".html";
        }
        return theFileNameStr;
    }

    public static File getExistingParentFile(File theFile) {
        if (theFile == null) {
            return null;
        }
        File file = theFile;
        while (!file.exists()) {
            if ((file = file.getParentFile()) != null) continue;
            return null;
        }
        return file;
    }

    public static Color invertColor(Color color) {
        return new Color(~color.getRGB());
    }

    public static void callExternal(String thePath) {
        String[] command;
        logger.debug((Object)"callExternal entered");
        int brokenHyphen = 8209;
        while (thePath.indexOf(8209) != -1) {
            thePath = thePath.replace('\u2011', '-');
        }
        if (OS.isMacOS()) {
            command = new String[]{"open", thePath};
        } else if (OS.isWinOS()) {
            command = new String[]{Utils.getRunPath(thePath)};
        } else if (OS.isLinuxOS()) {
            command = OS.isKDESession() ? new String[]{"kfmclient", "exec", thePath} : new String[]{"gnome-open", thePath};
        } else {
            throw new IllegalStateException("Unrecognized OS");
        }
        Utils.runShellAsync(command);
        logger.debug((Object)"callExternal exited");
    }

    private static String getRunPath(String thePath) {
        String runPath = PathManager.getTempFolderPath() + FILE_RUN_BAT;
        try {
            String runCommand = "start \"\" " + thePath;
            FileOutputStream fos = new FileOutputStream(new File(runPath));
            fos.write(runCommand.getBytes());
            fos.close();
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        return runPath;
    }

    public static void clearDir(File file) {
        for (File f : file.listFiles()) {
            if (f.isDirectory()) {
                Utils.clearDir(f);
            }
            f.delete();
        }
    }

    public static boolean fileExists(String path) {
        if (path != null && path != "") {
            return new File(path).exists();
        }
        return false;
    }

    public static boolean isGNOMESession() {
        String[] commandCORE = new String[]{"/bin/sh", "-c", "echo $DESKTOP_SESSION"};
        return Utils.commandOutputContains(commandCORE, "gnome");
    }

    public static List<File> getFileList(String stringUrl) {
        if (stringUrl.length() > 0 && stringUrl.charAt(stringUrl.length() - 1) == '\u0000') {
            stringUrl = stringUrl.substring(0, stringUrl.length() - 1);
        }
        List tokens = StringParser.getTokens(stringUrl, "\r\n");
        ArrayList<File> result = new ArrayList<File>(tokens.size());
        int nSize = tokens.size();
        for (int i = 0; i < nSize; ++i) {
            File file;
            String filePath = (String)tokens.get(i);
            if (filePath.startsWith("file:")) {
                try {
                    URI uri = new URI(filePath);
                    filePath = uri.getPath();
                }
                catch (URISyntaxException e) {
                    logger.debug((Object)("failed to create URI for: " + filePath));
                    filePath = filePath.substring("file:".length() + 2);
                }
            }
            if ((file = new File(filePath)).exists()) {
                result.add(file);
                continue;
            }
            logger.debug((Object)("following file was not found: " + file));
        }
        logger.debug((Object)("found files: " + result.size()));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFromReader(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("reader is null");
        }
        char[] buf = new char[1024];
        StringBuilder sb = new StringBuilder();
        try {
            int count;
            while ((count = reader.read(buf)) > 0) {
                sb.append(buf, 0, count);
            }
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        return sb.toString();
    }

    public static HttpURLConnection followRedirects(HttpURLConnection theConnection) throws IOException {
        boolean flag;
        int i = 0;
        do {
            theConnection.setInstanceFollowRedirects(false);
            flag = false;
            int j = theConnection.getResponseCode();
            if (j < 300 || j > 305 || j == 304) continue;
            URL url = theConnection.getURL();
            String s = theConnection.getHeaderField("Location");
            URL url1 = null;
            if (s != null) {
                url1 = new URL(url, s);
            }
            if (url1 == null || i >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            flag = true;
            theConnection = (HttpURLConnection)url1.openConnection();
            ++i;
        } while (flag);
        if (!(theConnection instanceof HttpURLConnection)) {
            throw new IOException(theConnection.getURL() + " redirected to non-http URL");
        }
        return theConnection;
    }

    public static String validateExtention(String theNewFileName, String theOriginalFileName) {
        String orgExt;
        String newExt = Utils.getExtention(theNewFileName);
        if (newExt.equals(theNewFileName) && !(orgExt = Utils.getExtention(theOriginalFileName)).equals(theOriginalFileName)) {
            return theNewFileName + "." + orgExt;
        }
        return theNewFileName;
    }

    public static Font deriveFontForSize(Font theFont, float size) {
        if (theFont == null) {
            return null;
        }
        return Utils.deriveFont(theFont, theFont.getStyle(), size);
    }

    public static Font deriveFont(Font theFont, int style) {
        if (theFont == null) {
            return null;
        }
        return Utils.deriveFont(theFont, style, theFont.getSize());
    }

    public static Font deriveFont(Font theFont, int style, float size) {
        if (theFont == null) {
            return null;
        }
        HashMap<TextAttribute, Object> map = new HashMap<TextAttribute, Object>();
        map.put(TextAttribute.FAMILY, theFont.getFontName());
        map.put(TextAttribute.SIZE, Float.valueOf(size));
        map.put(TextAttribute.WEIGHT, (style & 1) != 0 ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
        map.put(TextAttribute.POSTURE, (style & 2) != 0 ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
        return new Font(map);
    }

    public static boolean isValidExtension(String theExt) {
        StringTokenizer st = new StringTokenizer(theExt, ",");
        while (st.hasMoreTokens()) {
            String ext = st.nextToken().trim();
            if (ext.equals("") || ext.indexOf(47) == -1 && ext.indexOf(46) == -1 && ext.indexOf(32) == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean checkArchivePath(String userGuid) {
        GWCommandManager commandManager = GWCommandManager.getInstance(userGuid);
        String path = commandManager.getArchiveLocation();
        if (!Utils.fileExists(path)) {
            String archivePath;
            SpecifyArchiveDirectoryDialog dialog = new SpecifyArchiveDirectoryDialog(path);
            dialog.setVisible(true);
            if (dialog.isOkActionProcessed() && !Utils.isNullOrEmpty(archivePath = dialog.getPath())) {
                boolean b;
                File dir = new File(archivePath);
                boolean bl = b = dir.mkdirs() || Utils.fileExists(archivePath);
                if (b) {
                    commandManager.setArchiveLocation(archivePath);
                    return true;
                }
                return Utils.checkArchivePath(userGuid);
            }
            return false;
        }
        return true;
    }

    public static boolean isKDESession() {
        String[] commandCORE = new String[]{"/bin/sh", "-c", "echo $KDE_FULL_SESSION"};
        String[] commandRH9 = new String[]{"/bin/sh", "-c", "echo $GDMSESSION"};
        return Utils.commandOutputContains(commandCORE, "true") || Utils.commandOutputContains(commandRH9, "kde");
    }

    private static boolean commandOutputContains(String[] cmd, String lcStr) {
        boolean result = false;
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            String cmdName = cmd[0];
            StreamGobbler errorGobbler = new StreamGobbler(process.getErrorStream(), "PROCCESS: " + cmdName + " ERROR");
            errorGobbler.start();
            InputStreamReader isr = new InputStreamReader(process.getInputStream());
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                result = result || line.toLowerCase().indexOf(lcStr) != -1;
            }
            br.close();
            isr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean areObjectsNullsOrEqual(Object first, Object second) {
        if (first == null && second == null) {
            return true;
        }
        if (first != null && first.equals(second)) {
            return true;
        }
        return second != null && second.equals(first);
    }

    public static <T, U> T[] castArray(U[] source, Class<? extends T[]> newType) {
        if (source == null) {
            throw new IllegalArgumentException("source is null");
        }
        if (newType == null) {
            throw new IllegalArgumentException("newType is null");
        }
        if (!source.getClass().getComponentType().isAssignableFrom(newType.getComponentType())) {
            throw new IllegalArgumentException(source.getClass().getComponentType().getName() + " is not assignable from " + newType.getComponentType().getName());
        }
        Object[] result = (Object[])Array.newInstance(newType.getComponentType(), source.length);
        for (int i = 0; i < source.length; ++i) {
            result[i] = source[i];
        }
        return result;
    }

    private static class StreamGobbler
    extends Thread {
        InputStream is;
        String type;

        StreamGobbler(InputStream is, String type) {
            this.is = is;
            this.type = type;
        }

        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    System.out.println(this.type + ">" + line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private static class ShellStarter
    extends Thread {
        private String[] commands;

        public ShellStarter(String[] theCommands) {
            this.commands = theCommands;
        }

        public void run() {
            try {
                logger.debug((Object)"EXECUTING SHELL COMMAND: ");
                int nSize = this.commands.length;
                for (int i = 0; i < nSize; ++i) {
                    logger.debug((Object)this.commands[i]);
                }
                Process process = Runtime.getRuntime().exec(this.commands);
                String name = this.commands[0];
                StreamGobbler errorGobbler = new StreamGobbler(process.getErrorStream(), "PROCCESS: " + name + " ERROR");
                StreamGobbler outputGobbler = new StreamGobbler(process.getInputStream(), "PROCCESS: " + name + " OUTPUT");
                errorGobbler.start();
                outputGobbler.start();
            }
            catch (IOException e) {
                logger.debug((Object)e, (Throwable)e);
                String errorMessage = e.getMessage();
                JOptionPane.showMessageDialog(null, errorMessage, StringResources.CANNOT_EXECUTE_SHELL_COMMAND_C, 0);
            }
        }
    }
}

