/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.api.enums;

import com.appframework.Tested;
import org.apache.log4j.Logger;

public final class RecipientCopyType {
    private static Logger logger = Logger.getLogger(RecipientCopyType.class);
    private final int value;

    private RecipientCopyType(int value) {
        this.value = value;
    }

    @Tested
    public static RecipientCopyType get(boolean to, boolean cc, boolean bc, boolean replyTo) {
        if (!(to || cc || bc || replyTo)) {
            return RecipientCopyType.getNone();
        }
        int type = 0;
        if (to) {
            type |= 1;
        }
        if (cc) {
            type |= 2;
        }
        if (bc) {
            type |= 4;
        }
        if (replyTo) {
            type |= 0x8000;
        }
        return new RecipientCopyType(type);
    }

    @Tested
    public static RecipientCopyType getTo() {
        return new RecipientCopyType(1);
    }

    @Tested
    public static RecipientCopyType getCc() {
        return new RecipientCopyType(2);
    }

    @Tested
    public static RecipientCopyType getBc() {
        return new RecipientCopyType(4);
    }

    @Tested
    public static RecipientCopyType getReplyTo() {
        return new RecipientCopyType(32768);
    }

    @Tested
    public static RecipientCopyType getNone() {
        return new RecipientCopyType(0);
    }

    @Tested
    public static RecipientCopyType getDefault() {
        return new RecipientCopyType(1);
    }

    public static RecipientCopyType getEnum(int value) {
        return new RecipientCopyType(value);
    }

    public int getValue() {
        return this.value;
    }

    public boolean hasTo() {
        return (this.value & 1) == 1;
    }

    public boolean hasCc() {
        return (this.value & 2) == 2;
    }

    public boolean hasBc() {
        return (this.value & 4) == 4;
    }

    public boolean hasReplyTo() {
        return (this.value & 0x8000) == 32768;
    }

    public boolean hasNone() {
        return this.value == 0;
    }

    @Tested
    public boolean hasIllegal() {
        if (this.hasNone()) {
            return false;
        }
        int value = this.value;
        if (this.hasTo()) {
            value -= RecipientCopyType.getTo().getValue();
        }
        if (this.hasCc()) {
            value -= RecipientCopyType.getCc().getValue();
        }
        if (this.hasBc()) {
            value -= RecipientCopyType.getBc().getValue();
        }
        if (this.hasReplyTo()) {
            value -= RecipientCopyType.getReplyTo().getValue();
        }
        return value != 0;
    }

    public boolean hasDefault() {
        return (this.value & 1) == 1;
    }

    public boolean hasRecipientCopyType(RecipientCopyType copyType) {
        return (this.value & copyType.value) == copyType.value;
    }

    @Tested
    public boolean equals(Object obj) {
        if (!(obj instanceof RecipientCopyType)) {
            return false;
        }
        return ((RecipientCopyType)obj).value == this.value;
    }

    @Tested
    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return this.getClass().getName() + '[' + this.value + ']';
    }
}

