/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.api.impl;

import com.appframework.cache.ICached;
import com.appframework.utils.Pair;
import com.appframework.utils.Trio;
import com.novell.gw.engine.ItemList;
import com.novell.gw.engine.ItemListEvent;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.engine.TransferItems;
import com.novell.gw.jclient.api.APIInternal;
import com.novell.gw.jclient.api.enums.ItemType;
import com.novell.gw.jclient.api.interfaces.ICategoryList;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IItemListListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemListImpl_Cached
implements IItemList,
ICached {
    private static final Logger logger = Logger.getLogger(ItemListImpl_Cached.class);
    private static final Set<CacheKey> cacheKeySet;
    private Map<IItem, Integer> itemToIndexMapCache = new HashMap<IItem, Integer>();
    private Map<Integer, ItemData> itemDataCache = new HashMap<Integer, ItemData>();
    private IItem[] selectionCache = null;
    private Map<CacheKey, Object> generalCache = new HashMap<CacheKey, Object>();
    private Map<Date, IItem[]> cacheGetCalendarItems = new HashMap<Date, IItem[]>();
    private Map<Date, IItem[]> cacheGetNotes = new HashMap<Date, IItem[]>();
    private Map<Date, IItem[]> cacheGetAppointments = new HashMap<Date, IItem[]>();
    private Map<Date, IItem[]> cacheGetTasks = new HashMap<Date, IItem[]>();
    private Map<Trio<ItemListFilter, Integer, Integer>, Integer> cacheGetMonthBusyDays = new HashMap<Trio<ItemListFilter, Integer, Integer>, Integer>();
    private int previousSize = -1;
    private final List<IItemListListener> listeners = new ArrayList<IItemListListener>();
    private final IItemList itemList;

    @APIInternal
    protected ItemListImpl_Cached(IItemList itemList) {
        if (itemList == null) {
            throw new IllegalArgumentException("item list is null");
        }
        this.itemList = itemList;
        this.itemList.addItemListListener(new PrimaryItemListListener());
    }

    @Override
    public void clearCachedValues() {
        logger.debug((Object)"clearCachedValues");
        this.clearPrimaryCacheStorages(null);
        this.clearSecondaryCacheStorages();
    }

    @Override
    public void clearCachedValue(Object valueKey) {
    }

    private void clearPrimaryCacheStorages(Pair<Integer, Integer> range) {
        boolean clearAll;
        boolean bl = clearAll = range == null;
        if (!clearAll) {
            boolean sizeChanged;
            int oldSize = this.previousSize;
            boolean bl2 = sizeChanged = oldSize != this.getSize();
            if (sizeChanged) {
                clearAll = true;
            } else if (range.getFirst() == 0 && oldSize == range.getSecond()) {
                clearAll = true;
            }
        }
        if (clearAll) {
            logger.debug((Object)"clearing all primary caches");
            this.itemToIndexMapCache.clear();
            this.itemDataCache.clear();
        } else {
            logger.debug((Object)("clearing range [" + range.getFirst() + "; " + range.getSecond() + ") of primary caches data"));
            for (int i = range.getFirst().intValue(); i < range.getSecond(); ++i) {
                ItemData itemData = this.itemDataCache.remove(i);
                if (itemData == null) continue;
                this.itemToIndexMapCache.remove(itemData.getItem());
            }
        }
    }

    private void clearSecondaryCacheStorages() {
        logger.debug((Object)"clearSecondaryCacheStorages");
        this.generalCache.clear();
        this.cacheGetCalendarItems.clear();
        this.cacheGetAppointments.clear();
        this.cacheGetTasks.clear();
        this.cacheGetNotes.clear();
        this.cacheGetMonthBusyDays.clear();
        this.selectionCache = null;
    }

    private void processRefreshEvent(ItemListEvent e) {
        logger.debug((Object)("[" + this.hashCode() + "] " + e));
        if (e.getType() == 7) {
            this.clearPrimaryCacheStorages(new Pair<Integer, Integer>(e.getIndexStart(), e.getIndexEnd()));
        } else {
            this.clearPrimaryCacheStorages(null);
        }
        this.clearSecondaryCacheStorages();
    }

    private ItemData getItemData(int index) {
        ItemData data = this.itemDataCache.get(index);
        if (data == null) {
            data = new ItemData(index);
            this.itemDataCache.put(index, data);
        }
        return data;
    }

    @Override
    public boolean isCollapsed(IItem item) {
        if (cacheKeySet.contains((Object)CacheKey.IS_COLLAPSED)) {
            return this.getItemData(this.indexOf(item)).isCollapsed();
        }
        return this.itemList.isCollapsed(item);
    }

    @Override
    public boolean isCollapsedAt(int index) {
        if (cacheKeySet.contains((Object)CacheKey.IS_COLLAPSED)) {
            return this.getItemData(index).isCollapsed();
        }
        return this.itemList.isCollapsedAt(index);
    }

    @Override
    public int getSortField() {
        Integer sortField = (Integer)this.generalCache.get((Object)CacheKey.GET_SORT_FIELD);
        if (sortField == null) {
            sortField = this.itemList.getSortField();
            if (cacheKeySet.contains((Object)CacheKey.GET_SORT_FIELD)) {
                this.generalCache.put(CacheKey.GET_SORT_FIELD, sortField);
            }
        }
        return sortField;
    }

    @Override
    public boolean isSortAscending() {
        Boolean sortAscending = (Boolean)this.generalCache.get((Object)CacheKey.GET_SORT_ASCENDING);
        if (sortAscending == null) {
            sortAscending = this.itemList.isSortAscending();
            if (cacheKeySet.contains((Object)CacheKey.GET_SORT_ASCENDING)) {
                this.generalCache.put(CacheKey.GET_SORT_ASCENDING, sortAscending);
            }
        }
        return sortAscending;
    }

    @Override
    public IItem getItemAt(int index) {
        IItem item = cacheKeySet.contains((Object)CacheKey.GET_ITEM_AT) ? this.getItemData(index).getItem() : this.itemList.getItemAt(index);
        if (cacheKeySet.contains((Object)CacheKey.INDEX_OF_ITEM)) {
            this.itemToIndexMapCache.put(item, index);
        }
        return item;
    }

    @Override
    public int getFirstUnreadItemIndex(boolean isQuickViewerOn) {
        CacheKey cacheKey = CacheKey.GET_FIRST_UNREAD_ITEM_INDEX;
        Integer value = (Integer)this.generalCache.get((Object)cacheKey);
        if (value == null) {
            value = this.itemList.getFirstUnreadItemIndex(isQuickViewerOn);
            if (cacheKeySet.contains((Object)cacheKey)) {
                this.generalCache.put(cacheKey, value);
            }
        }
        return value;
    }

    @Override
    public int getThreadDepth(IItem item) {
        if (cacheKeySet.contains((Object)CacheKey.GET_THREAD_DEPTH)) {
            return this.getItemData(this.indexOf(item)).getThreadDepth();
        }
        return this.itemList.getThreadDepth(item);
    }

    @Override
    public int getThreadDepthAt(int index) {
        if (cacheKeySet.contains((Object)CacheKey.GET_THREAD_DEPTH)) {
            return this.getItemData(index).getThreadDepth();
        }
        return this.itemList.getThreadDepthAt(index);
    }

    @Override
    public boolean hasChildren(IItem item) {
        if (cacheKeySet.contains((Object)CacheKey.HAS_CHILDREN)) {
            return this.getItemData(this.indexOf(item)).hasChildren();
        }
        return this.itemList.hasChildren(item);
    }

    @Override
    public boolean hasChildrenAt(int index) {
        if (cacheKeySet.contains((Object)CacheKey.HAS_CHILDREN)) {
            return this.getItemData(index).hasChildren();
        }
        return this.itemList.hasChildrenAt(index);
    }

    @Override
    public boolean isRecurringEntry(IItem item) {
        if (cacheKeySet.contains((Object)CacheKey.IS_RECURRING_ENTRY)) {
            return this.getItemData(this.indexOf(item)).isRecurringEntry();
        }
        return this.itemList.isRecurringEntry(item);
    }

    @Override
    public boolean isRecurringEntryAt(int index) {
        if (cacheKeySet.contains((Object)CacheKey.IS_RECURRING_ENTRY)) {
            return this.getItemData(index).isRecurringEntry();
        }
        return this.itemList.isRecurringEntryAt(index);
    }

    @Override
    public boolean setSelection(IItem[] items) {
        if (cacheKeySet.contains((Object)CacheKey.SELECTION)) {
            this.selectionCache = items;
        }
        boolean result = this.itemList.setSelection(items);
        CacheKey cacheKey = CacheKey.IS_THREAD_IGNORED;
        if (cacheKeySet.contains((Object)cacheKey)) {
            this.generalCache.put(cacheKey, null);
        }
        return result;
    }

    @Override
    public boolean isThreadIgnored() {
        CacheKey cacheKey = CacheKey.IS_THREAD_IGNORED;
        Boolean value = (Boolean)this.generalCache.get((Object)cacheKey);
        if (value == null) {
            value = this.itemList.isThreadIgnored();
            if (cacheKeySet.contains((Object)cacheKey)) {
                this.generalCache.put(cacheKey, value);
            }
        }
        return value;
    }

    @Override
    public void markThreadIgnore() {
        this.itemList.markThreadIgnore();
        CacheKey cacheKey = CacheKey.IS_THREAD_IGNORED;
        if (cacheKeySet.contains((Object)cacheKey)) {
            this.generalCache.put(cacheKey, null);
            for (IItem item : this.selectionCache) {
                ItemData data = this.itemDataCache.get(this.indexOf(item));
                if (data == null) continue;
                data.clearThreadIgnored();
            }
        }
    }

    @Override
    public boolean isThreadIgnored(int index) {
        if (cacheKeySet.contains((Object)CacheKey.IS_THREAD_IGNORED)) {
            return this.getItemData(index).isThreadIgnored();
        }
        return this.itemList.isThreadIgnored(index);
    }

    @Override
    public boolean isThreadIgnored(IItem item) {
        if (cacheKeySet.contains((Object)CacheKey.IS_THREAD_IGNORED)) {
            return this.getItemData(this.indexOf(item)).isThreadIgnored();
        }
        return this.itemList.isThreadIgnored(item);
    }

    @Override
    public IItem[] getCalendarItems(Date date) {
        CacheKey cacheKey = CacheKey.GET_CALENDAR_ITEMS;
        IItem[] value = this.cacheGetCalendarItems.get(date);
        if (value == null) {
            value = this.itemList.getCalendarItems(date);
            if (cacheKeySet.contains((Object)cacheKey)) {
                this.cacheGetCalendarItems.put(date, value);
            }
        }
        return value;
    }

    @Override
    public IItem[] getAppointments(Date date) {
        CacheKey cacheKey = CacheKey.GET_APPOINTMENTS;
        IItem[] value = this.cacheGetAppointments.get(date);
        if (value == null) {
            value = this.itemList.getAppointments(date);
            if (cacheKeySet.contains((Object)cacheKey)) {
                this.cacheGetAppointments.put(date, value);
            }
        }
        return value;
    }

    @Override
    public IItem[] getNotes(Date date) {
        CacheKey cacheKey = CacheKey.GET_NOTES;
        IItem[] value = this.cacheGetNotes.get(date);
        if (value == null) {
            value = this.itemList.getNotes(date);
            if (cacheKeySet.contains((Object)cacheKey)) {
                this.cacheGetNotes.put(date, value);
            }
        }
        return value;
    }

    @Override
    public IItem[] getTasks(Date date) {
        CacheKey cacheKey = CacheKey.GET_TASKS;
        IItem[] value = this.cacheGetTasks.get(date);
        if (value == null) {
            value = this.itemList.getTasks(date);
            if (cacheKeySet.contains((Object)cacheKey)) {
                this.cacheGetTasks.put(date, value);
            }
        }
        return value;
    }

    @Override
    public int getMonthBusyDays(ItemListFilter filter, int year, int month) {
        CacheKey cacheKey = CacheKey.GET_MONTH_BUSY_DAYS;
        Trio<ItemListFilter, Integer, Integer> key = new Trio<ItemListFilter, Integer, Integer>(filter, year, month);
        Integer value = this.cacheGetMonthBusyDays.get(key);
        if (value == null) {
            value = this.itemList.getMonthBusyDays(filter, year, month);
            if (cacheKeySet.contains((Object)cacheKey)) {
                this.cacheGetMonthBusyDays.put(key, value);
            }
        }
        return value;
    }

    @Override
    public int indexOf(IItem item) {
        if (cacheKeySet.contains((Object)CacheKey.INDEX_OF_ITEM)) {
            Integer index = this.itemToIndexMapCache.get(item);
            if (index == null) {
                index = this.itemList.indexOf(item);
                this.itemToIndexMapCache.put(item, index);
            }
            return index;
        }
        return this.itemList.indexOf(item);
    }

    @Override
    public int getSize() {
        this.previousSize = this.itemList.getSize();
        return this.previousSize;
    }

    @Override
    @APIInternal
    public ItemList getNativeItemList() {
        return this.itemList.getNativeItemList();
    }

    @Override
    public boolean isRootMost(IItem item) {
        return this.itemList.isRootMost(item);
    }

    @Override
    public void addItemListListener(IItemListListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeItemListListener(IItemListListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void sort(int sortField, boolean ascending) {
        logger.debug((Object)("SORTING   sortField: " + sortField + ";  ascending: " + ascending));
        this.itemList.sort(sortField, ascending);
        logger.debug((Object)("SORTED   sortField: " + this.itemList.getSortField() + ";  ascending: " + this.itemList.isSortAscending()));
    }

    @Override
    public void sort(int sortField, boolean ascending, boolean sortTasklist) {
        logger.debug((Object)("SORTING   sortField: " + sortField + ";  ascending: " + ascending + "; sortTasklist: " + sortTasklist));
        this.itemList.sort(sortField, ascending, sortTasklist);
        logger.debug((Object)("SORTED   sortField: " + this.itemList.getSortField() + ";  ascending: " + this.itemList.isSortAscending()));
    }

    @Override
    public int getDisplayItemCount() {
        return this.itemList.getDisplayItemCount();
    }

    @Override
    public TransferItems getTransferItems(int[] indices) {
        return this.itemList.getTransferItems(indices);
    }

    @Override
    public boolean hasUnreadItemInThread(IItem item) {
        return this.itemList.hasUnreadItemInThread(item);
    }

    @Override
    public boolean hasUnreadItemInThreadAt(int index) {
        return this.itemList.hasUnreadItemInThreadAt(index);
    }

    @Override
    public boolean hasTaskListItemsOnly() {
        return this.itemList.hasTaskListItemsOnly();
    }

    @Override
    public boolean isCollapsedAutoDateItem(IItem item) {
        return this.itemList.isCollapsedAutoDateItem(item);
    }

    @Override
    public boolean isCollapsedAutoDateItemAt(int index) {
        return this.itemList.isCollapsedAutoDateItemAt(index);
    }

    @Override
    public boolean isRecurringEntryRoot(IItem item) {
        return this.itemList.isRecurringEntryRoot(item);
    }

    @Override
    public boolean isRecurringEntryRootAt(int index) {
        return this.itemList.isRecurringEntryRootAt(index);
    }

    @Override
    public boolean isRootMostAt(int index) {
        return this.itemList.isRootMostAt(index);
    }

    @Override
    public void expand(IItem item) {
        this.itemList.expand(item);
    }

    @Override
    public void expandAt(int index) {
        this.itemList.expandAt(index);
    }

    @Override
    public void collapse(IItem item) {
        this.itemList.collapse(item);
    }

    @Override
    public void collapseAt(int index) {
        this.itemList.collapseAt(index);
    }

    @Override
    public void expandAll() {
        this.itemList.expandAll();
    }

    @Override
    public void collapseAll() {
        this.itemList.collapseAll();
    }

    @Override
    public boolean isThreadWatched() {
        return this.itemList.isThreadWatched();
    }

    @Override
    public boolean isThreadWatched(int index) {
        return this.itemList.isThreadWatched(index);
    }

    @Override
    public boolean isThreadWatched(IItem item) {
        return this.itemList.isThreadWatched(item);
    }

    @Override
    public boolean canMarkThreadIgnore() {
        return this.itemList.canMarkThreadIgnore();
    }

    @Override
    public boolean canMarkThreadRead() {
        return this.itemList.canMarkThreadRead();
    }

    @Override
    public boolean canMarkThreadWatch() {
        return this.itemList.canMarkThreadWatch();
    }

    @Override
    public void markThreadRead() {
        this.itemList.markThreadRead();
    }

    @Override
    public void markThreadWatch() {
        this.itemList.markThreadWatch();
    }

    @Override
    public boolean canDeleteSelectedItems() {
        return this.itemList.canDeleteSelectedItems();
    }

    @Override
    public boolean canDeleteItem(IItem item) {
        return this.itemList.canDeleteItem(item);
    }

    @Override
    public boolean canDeleteItemAt(int index) {
        return this.itemList.canDeleteItemAt(index);
    }

    @Override
    public boolean deleteItem(IItem item) {
        return this.itemList.deleteItem(item);
    }

    @Override
    public boolean deleteSelectedItems() {
        return this.itemList.deleteSelectedItems();
    }

    @Override
    public boolean deleteItemAt(int index) {
        return this.itemList.deleteItemAt(index);
    }

    @Override
    public boolean canDeleteAndEmptyItem(IItem item) {
        return this.itemList.canDeleteAndEmptyItem(item);
    }

    @Override
    public boolean canDeleteAndEmptySelectedItems() {
        return this.itemList.canDeleteAndEmptySelectedItems();
    }

    @Override
    public boolean canDeleteAndEmptyItemAt(int index) {
        return this.itemList.canDeleteAndEmptyItemAt(index);
    }

    @Override
    public boolean deleteAndEmptyItem(IItem item) {
        return this.itemList.deleteAndEmptyItem(item);
    }

    @Override
    public boolean deleteAndEmptySelectedItems() {
        return this.itemList.deleteAndEmptySelectedItems();
    }

    @Override
    public boolean deleteAndEmptyItemAt(int index) {
        return this.itemList.deleteAndEmptyItemAt(index);
    }

    @Override
    public boolean canUndeleteItem(IItem item) {
        return this.itemList.canUndeleteItem(item);
    }

    @Override
    public boolean canUndeleteSelectedItems() {
        return this.itemList.canUndeleteSelectedItems();
    }

    @Override
    public boolean canUndeleteItemAt(int index) {
        return this.itemList.canUndeleteItemAt(index);
    }

    @Override
    public boolean undeleteItem(IItem item) {
        return this.itemList.undeleteItem(item);
    }

    @Override
    public boolean undeleteSelectedItems() {
        return this.itemList.undeleteSelectedItems();
    }

    @Override
    public boolean undeleteItemAt(int index) {
        return this.itemList.undeleteItemAt(index);
    }

    @Override
    public boolean canMarkItemPrivate(IItem item) {
        return this.itemList.canMarkItemPrivate(item);
    }

    @Override
    public boolean canMarkSelectedItemsPrivate() {
        return this.itemList.canMarkSelectedItemsPrivate();
    }

    @Override
    public boolean canMarkItemPrivateAt(int index) {
        return this.itemList.canMarkItemPrivateAt(index);
    }

    @Override
    public void markAllItemsRead() {
        this.itemList.markAllItemsRead();
    }

    @Override
    public boolean markItemPrivate(IItem item) {
        return this.itemList.markItemPrivate(item);
    }

    @Override
    public boolean markSelectedItemsPrivate() {
        return this.itemList.markSelectedItemsPrivate();
    }

    @Override
    public boolean markItemPrivateAt(int index) {
        return this.itemList.markItemPrivateAt(index);
    }

    @Override
    public boolean canMarkItemRead(IItem item) {
        return this.itemList.canMarkItemRead(item);
    }

    @Override
    public boolean canMarkSelectedItemsRead() {
        return this.itemList.canMarkSelectedItemsRead();
    }

    @Override
    public boolean canMarkItemReadAt(int index) {
        return this.itemList.canMarkItemReadAt(index);
    }

    @Override
    public boolean markItemRead(IItem item) {
        return this.itemList.markItemRead(item);
    }

    @Override
    public boolean markSelectedItemsRead() {
        return this.itemList.markSelectedItemsRead();
    }

    @Override
    public boolean markItemReadAt(int index) {
        return this.itemList.markItemReadAt(index);
    }

    @Override
    public boolean canPurgeItem(IItem item) {
        return this.itemList.canPurgeItem(item);
    }

    @Override
    public boolean canPurgeSelectedItems() {
        return this.itemList.canPurgeSelectedItems();
    }

    @Override
    public boolean canPurgeItemAt(int index) {
        return this.itemList.canPurgeItemAt(index);
    }

    @Override
    public boolean purgeItem(IItem item) {
        return this.itemList.purgeItem(item);
    }

    @Override
    public boolean purgeSelectedItems() {
        return this.itemList.purgeSelectedItems();
    }

    @Override
    public boolean purgeItemAt(int index) {
        return this.itemList.purgeItemAt(index);
    }

    @Override
    public boolean canRestoreItem(IItem item) {
        return this.itemList.canRestoreItem(item);
    }

    @Override
    public boolean canRestoreSelectedItems() {
        return this.itemList.canRestoreSelectedItems();
    }

    @Override
    public boolean canRestoreItemAt(int index) {
        return this.itemList.canRestoreItemAt(index);
    }

    @Override
    public boolean restoreItem(IItem item) {
        return this.itemList.restoreItem(item);
    }

    @Override
    public boolean restoreSelectedItems() {
        return this.itemList.restoreSelectedItems();
    }

    @Override
    public boolean restoreItemAt(int index) {
        return this.itemList.restoreItemAt(index);
    }

    @Override
    public boolean canMarkItemReadLater(IItem item) {
        return this.itemList.canMarkItemReadLater(item);
    }

    @Override
    public boolean canMarkSelectedItemsReadLater() {
        return this.itemList.canMarkSelectedItemsReadLater();
    }

    @Override
    public boolean canMarkItemReadLaterAt(int index) {
        return this.itemList.canMarkItemReadLaterAt(index);
    }

    @Override
    public boolean markItemReadLater(IItem item) {
        return this.itemList.markItemReadLater(item);
    }

    @Override
    public boolean markSelectedItemsReadLater() {
        return this.itemList.markSelectedItemsReadLater();
    }

    @Override
    public boolean markItemReadLaterAt(int index) {
        return this.itemList.markItemReadLaterAt(index);
    }

    @Override
    public boolean canShowSelectionInChecklist() {
        return this.itemList.canShowSelectionInChecklist();
    }

    @Override
    public boolean isSelectionInChecklist() {
        return this.itemList.isSelectionInChecklist();
    }

    @Override
    public boolean showSelectionInChecklist(boolean bShow) {
        return this.itemList.showSelectionInChecklist(bShow);
    }

    @Override
    public boolean moveSelectionToChecklist() {
        return this.itemList.moveSelectionToChecklist();
    }

    @Override
    public boolean canMoveSelectionToChecklist() {
        return this.itemList.canMoveSelectionToChecklist();
    }

    @Override
    public int findLastUncompletedChecklistItemIndex() {
        return this.itemList.findLastUncompletedChecklistItemIndex();
    }

    @Override
    public Enumeration getEnumeration() {
        return this.itemList.getEnumeration();
    }

    @Override
    public void queryStop() {
        this.itemList.queryStop();
    }

    @Override
    public int indexOf(String searchKey) {
        return this.itemList.indexOf(searchKey);
    }

    @Override
    public int indexOf(String searchKey, int fromIndex) {
        return this.itemList.indexOf(searchKey, fromIndex);
    }

    @Override
    public boolean canChecklistMoveDown(int iIndex) {
        return this.itemList.canChecklistMoveDown(iIndex);
    }

    @Override
    public boolean checklistMoveDown(int iIndex) {
        return this.itemList.checklistMoveDown(iIndex);
    }

    @Override
    public boolean canChecklistMoveUp(int iIndex) {
        return this.itemList.canChecklistMoveUp(iIndex);
    }

    @Override
    public boolean checklistMoveUp(int iIndex) {
        return this.itemList.checklistMoveUp(iIndex);
    }

    @Override
    public boolean canChecklistMoveToBottom(int iIndex) {
        return this.itemList.canChecklistMoveToBottom(iIndex);
    }

    @Override
    public boolean checklistMoveToBottom(int iIndex) {
        return this.itemList.checklistMoveToBottom(iIndex);
    }

    @Override
    public boolean canChecklistMoveToTop(int iIndex) {
        return this.itemList.canChecklistMoveToTop(iIndex);
    }

    @Override
    public boolean checklistMoveToTop(int iIndex) {
        return this.itemList.checklistMoveToTop(iIndex);
    }

    @Override
    public boolean checklistMoveTo(int iIndex, int iToIndex) {
        return this.itemList.checklistMoveTo(iIndex, iToIndex);
    }

    @Override
    public boolean checklistMoveTo(int iIndex, int iToIndex, boolean bMoveRecurringSubItems) {
        return this.itemList.checklistMoveTo(iIndex, iToIndex, bMoveRecurringSubItems);
    }

    @Override
    public boolean transferToTasklist(TransferItems transferItems, int itemIndex, boolean shouldMoveBelow, boolean moveInto) {
        return this.itemList.transferToTasklist(transferItems, itemIndex, shouldMoveBelow, moveInto);
    }

    @Override
    public int handleJunkMailSelectedItems(int listType) {
        return this.itemList.handleJunkMailSelectedItems(listType);
    }

    @Override
    public boolean canHandleJunkMailSelectedItems(int listType) {
        return this.itemList.canHandleJunkMailSelectedItems(listType);
    }

    @Override
    public int canHandleJunkMailSelectedItems() {
        return this.itemList.canHandleJunkMailSelectedItems();
    }

    @Override
    public IItem[] getCalendarItems(Date startDate, Date endDate) {
        return this.itemList.getCalendarItems(startDate, endDate);
    }

    @Override
    public IItem[] getCalendarItems(Date date, ItemType itemType) {
        return this.itemList.getCalendarItems(date, itemType);
    }

    @Override
    public IItem[] getCalendarItems(Date startDate, Date endDate, ItemType itemType) {
        return this.itemList.getCalendarItems(startDate, endDate, itemType);
    }

    @Override
    public IItem[] getAllDayEvents(Date date) {
        return this.itemList.getAllDayEvents(date);
    }

    @Override
    public IItem[] getAllDayEvents(Date startDate, Date endDate) {
        return this.itemList.getAllDayEvents(startDate, endDate);
    }

    @Override
    public IItem[] getAppointments(Date startDate, Date endDate) {
        return this.itemList.getAppointments(startDate, endDate);
    }

    @Override
    public IItem[] getNotes(Date startDate, Date endDate) {
        return this.itemList.getNotes(startDate, endDate);
    }

    @Override
    public IItem[] getTasks(Date startDate, Date endDate) {
        return this.itemList.getTasks(startDate, endDate);
    }

    @Override
    public boolean canSetCategoriesOnSelection() {
        return this.itemList.canSetCategoriesOnSelection();
    }

    @Override
    public void setCategories(ICategoryList categoryList, IItem[] items) {
        this.itemList.setCategories(categoryList, items);
    }

    @Override
    public boolean setFilter(ItemListFilter filter) {
        return this.itemList.setFilter(filter);
    }

    @Override
    public boolean canCreateChecklistItem() {
        return this.itemList.canCreateChecklistItem();
    }

    @Override
    public boolean canCreateChecklistSubItemAt(int index) {
        return this.itemList.canCreateChecklistSubItemAt(index);
    }

    @Override
    public boolean canCreateChecklistSubItemAtSelection() {
        return this.itemList.canCreateChecklistSubItemAtSelection();
    }

    @Override
    public boolean createChecklistItem(String newMessageText, int newItemIndex, int newItemParentIndex, ItemListFilter filter) {
        return this.itemList.createChecklistItem(newMessageText, newItemIndex, newItemParentIndex, filter);
    }

    @Override
    public boolean createChecklistItem(String newMessageText, int newItemIndex) {
        return this.itemList.createChecklistItem(newMessageText, newItemIndex);
    }

    @Override
    public boolean createChecklistSubItem(String newMessageText, int newItemIndex, int newItemParentIndex) {
        return this.itemList.createChecklistSubItem(newMessageText, newItemIndex, newItemParentIndex);
    }

    @Override
    public boolean canChecklistMoveRight(int iIndex) {
        return this.itemList.canChecklistMoveRight(iIndex);
    }

    @Override
    public boolean checklistMoveRight(int iIndex) {
        return this.itemList.checklistMoveRight(iIndex);
    }

    @Override
    public boolean canChecklistMoveLeft(int iIndex) {
        return this.itemList.canChecklistMoveLeft(iIndex);
    }

    @Override
    public boolean checklistMoveLeft(int iIndex) {
        return this.itemList.checklistMoveLeft(iIndex);
    }

    @Override
    public void dispose() {
        this.itemList.dispose();
    }

    static {
        HashSet<CacheKey> keySet = new HashSet<CacheKey>();
        keySet.add(CacheKey.GET_ITEM_AT);
        keySet.add(CacheKey.GET_SORT_FIELD);
        keySet.add(CacheKey.GET_SORT_ASCENDING);
        keySet.add(CacheKey.IS_COLLAPSED);
        keySet.add(CacheKey.HAS_CHILDREN);
        keySet.add(CacheKey.GET_THREAD_DEPTH);
        keySet.add(CacheKey.GET_FIRST_UNREAD_ITEM_INDEX);
        keySet.add(CacheKey.GET_CALENDAR_ITEMS);
        keySet.add(CacheKey.GET_NOTES);
        keySet.add(CacheKey.GET_TASKS);
        keySet.add(CacheKey.GET_APPOINTMENTS);
        keySet.add(CacheKey.IS_THREAD_IGNORED);
        keySet.add(CacheKey.IS_RECURRING_ENTRY);
        keySet.add(CacheKey.GET_MONTH_BUSY_DAYS);
        keySet.add(CacheKey.INDEX_OF_ITEM);
        keySet.add(CacheKey.SELECTION);
        cacheKeySet = Collections.unmodifiableSet(keySet);
    }

    private class ItemData {
        private int index;
        private IItem item = null;
        private Boolean collapsed = null;
        private Integer threadDepth = null;
        private Boolean hasChildren = null;
        private Boolean recurringEntry = null;
        private Boolean threadIgnored = null;

        private ItemData(int index) {
            this.index = index;
        }

        private IItem getItem() {
            if (this.item == null) {
                this.item = ItemListImpl_Cached.this.itemList.getItemAt(this.index);
            }
            return this.item;
        }

        private boolean isCollapsed() {
            if (this.collapsed == null) {
                this.collapsed = ItemListImpl_Cached.this.itemList.isCollapsedAt(this.index);
            }
            return this.collapsed;
        }

        private int getThreadDepth() {
            if (this.threadDepth == null) {
                this.threadDepth = ItemListImpl_Cached.this.itemList.getThreadDepthAt(this.index);
            }
            return this.threadDepth;
        }

        private boolean hasChildren() {
            if (this.hasChildren == null) {
                this.hasChildren = ItemListImpl_Cached.this.itemList.hasChildrenAt(this.index);
            }
            return this.hasChildren;
        }

        private boolean isRecurringEntry() {
            if (this.recurringEntry == null) {
                this.recurringEntry = ItemListImpl_Cached.this.itemList.isRecurringEntryAt(this.index);
            }
            return this.recurringEntry;
        }

        private boolean isThreadIgnored() {
            if (this.threadIgnored == null) {
                this.threadIgnored = ItemListImpl_Cached.this.itemList.isThreadIgnored(this.index);
            }
            return this.threadIgnored;
        }

        private void clearThreadIgnored() {
            this.threadIgnored = null;
        }
    }

    private class PrimaryItemListListener
    implements IItemListListener {
        private PrimaryItemListListener() {
        }

        public void contentsChanged(ItemListEvent e) {
            ItemListImpl_Cached.this.processRefreshEvent(e);
            for (IItemListListener listener : this.getListeners()) {
                listener.contentsChanged(e);
            }
        }

        public void moreResultsAvailable(ItemListEvent e) {
            ItemListImpl_Cached.this.processRefreshEvent(e);
            for (IItemListListener listener : this.getListeners()) {
                listener.moreResultsAvailable(e);
            }
        }

        public void queryResultsDone(ItemListEvent e) {
            ItemListImpl_Cached.this.processRefreshEvent(e);
            for (IItemListListener listener : this.getListeners()) {
                listener.queryResultsDone(e);
            }
        }

        public void notifyEmptyList(ItemListEvent e) {
            ItemListImpl_Cached.this.processRefreshEvent(e);
            for (IItemListListener listener : this.getListeners()) {
                listener.notifyEmptyList(e);
            }
        }

        private IItemListListener[] getListeners() {
            return ItemListImpl_Cached.this.listeners.toArray(new IItemListListener[ItemListImpl_Cached.this.listeners.size()]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CacheKey {
        GET_ITEM_AT,
        GET_SORT_FIELD,
        GET_SORT_ASCENDING,
        IS_COLLAPSED,
        HAS_CHILDREN,
        GET_THREAD_DEPTH,
        GET_FIRST_UNREAD_ITEM_INDEX,
        GET_CALENDAR_ITEMS,
        GET_NOTES,
        GET_TASKS,
        GET_APPOINTMENTS,
        IS_THREAD_IGNORED,
        IS_RECURRING_ENTRY,
        GET_MONTH_BUSY_DAYS,
        INDEX_OF_ITEM,
        SELECTION;

    }
}

