/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.api.impl.ab;

import com.novell.gw.ab.Address;
import com.novell.gw.ab.AddressBookItemList;
import com.novell.gw.ab.Addressable;
import com.novell.gw.ab.Contact;
import com.novell.gw.ab.GroupContact;
import com.novell.gw.ab.OrganizationContact;
import com.novell.gw.ab.Recipient;
import com.novell.gw.ab.ResourceContact;
import com.novell.gw.ab.UserContact;
import com.novell.gw.jclient.api.enums.RecipientCopyType;
import com.novell.gw.jclient.api.impl.APIWrappingConfigurator;
import com.novell.gw.jclient.api.impl.ab.AddressBookItemListImpl;
import com.novell.gw.jclient.api.impl.ab.AddressBookItemListImpl_Cached;
import com.novell.gw.jclient.api.impl.ab.AddressImpl;
import com.novell.gw.jclient.api.impl.ab.GroupContactImpl;
import com.novell.gw.jclient.api.impl.ab.GroupContactImpl_Cached;
import com.novell.gw.jclient.api.impl.ab.OrganizationContactImpl;
import com.novell.gw.jclient.api.impl.ab.OrganizationContactImpl_Cached;
import com.novell.gw.jclient.api.impl.ab.RecipientImpl;
import com.novell.gw.jclient.api.impl.ab.ResourceContactImpl;
import com.novell.gw.jclient.api.impl.ab.ResourceContactImpl_Cached;
import com.novell.gw.jclient.api.impl.ab.UserContactImpl;
import com.novell.gw.jclient.api.impl.ab.UserContactImpl_Cached;
import com.novell.gw.jclient.api.interfaces.ab.IAddress;
import com.novell.gw.jclient.api.interfaces.ab.IAddressBookItemList;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.ab.IGroupContact;
import com.novell.gw.jclient.api.interfaces.ab.IOrganizationContact;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.api.interfaces.ab.IResourceContact;
import com.novell.gw.jclient.api.interfaces.ab.IUserContact;
import org.apache.log4j.Logger;

public class APIAbWrapperManager {
    private static Logger logger = Logger.getLogger(APIAbWrapperManager.class);

    public static IAddress createAddress(String emailAddress, String displayName) {
        return APIAbWrapperManager.getAddress(new Address(emailAddress, displayName));
    }

    public static IRecipient createRecipient(IAddressable addressable) {
        if (addressable == null) {
            throw new IllegalArgumentException("addressable is null");
        }
        return APIAbWrapperManager.getRecipient(new Recipient(addressable.getNativeAddressable()));
    }

    public static IRecipient createRecipient(IAddressable addressable, RecipientCopyType copyType) {
        if (addressable == null) {
            throw new IllegalArgumentException("addressable is null");
        }
        return APIAbWrapperManager.getRecipient(new Recipient(addressable.getNativeAddressable(), copyType.getValue()));
    }

    public static boolean isSameAddress(IAddressable addr1, IAddressable addr2) {
        return Recipient.isSameAddress((Addressable)addr1.getNativeAddressable(), (Addressable)addr2.getNativeAddressable());
    }

    public static IRecipient getRecipient(Recipient resipient) {
        if (resipient == null) {
            logger.warn((Object)"recipient is null");
            return null;
        }
        return new RecipientImpl(resipient);
    }

    public static IAddressable getAddressable(Addressable addressable) {
        if (addressable == null) {
            logger.warn((Object)"addressable is null");
            return null;
        }
        if (addressable instanceof Address) {
            return APIAbWrapperManager.getAddress((Address)addressable);
        }
        if (addressable instanceof Contact) {
            return APIAbWrapperManager.getContact((Contact)addressable);
        }
        throw new IllegalStateException("unexpected addressable class: " + addressable.getClass().getName());
    }

    public static IContact getContact(Contact nativeContact) {
        if (nativeContact == null) {
            logger.warn((Object)"nativeContact is null");
            return null;
        }
        if (nativeContact instanceof GroupContact) {
            return APIAbWrapperManager.getGroupContact((GroupContact)nativeContact);
        }
        if (nativeContact instanceof OrganizationContact) {
            return APIAbWrapperManager.getOrganizationContact((OrganizationContact)nativeContact);
        }
        if (nativeContact instanceof ResourceContact) {
            return APIAbWrapperManager.getResourceContact((ResourceContact)nativeContact);
        }
        if (nativeContact instanceof UserContact) {
            return APIAbWrapperManager.getUserContact((UserContact)nativeContact);
        }
        throw new IllegalStateException("unexpected contact class: " + nativeContact.getClass().getName());
    }

    static IAddress getAddress(Address nativeAddress) {
        if (nativeAddress == null) {
            return null;
        }
        return new AddressImpl(nativeAddress);
    }

    static IOrganizationContact getOrganizationContact(OrganizationContact nativeContact) {
        if (nativeContact == null) {
            return null;
        }
        IOrganizationContact impl = new OrganizationContactImpl(nativeContact);
        if (APIWrappingConfigurator.getImplementationMap().get(IOrganizationContact.class) == OrganizationContactImpl_Cached.class) {
            impl = new OrganizationContactImpl_Cached(impl);
        }
        return impl;
    }

    static IUserContact getUserContact(UserContact nativeContact) {
        if (nativeContact == null) {
            return null;
        }
        IUserContact impl = new UserContactImpl(nativeContact);
        if (APIWrappingConfigurator.getImplementationMap().get(IUserContact.class) == UserContactImpl_Cached.class) {
            impl = new UserContactImpl_Cached(impl);
        }
        return impl;
    }

    static IGroupContact getGroupContact(GroupContact nativeContact) {
        if (nativeContact == null) {
            return null;
        }
        IGroupContact impl = new GroupContactImpl(nativeContact);
        if (APIWrappingConfigurator.getImplementationMap().get(IGroupContact.class) == GroupContactImpl_Cached.class) {
            impl = new GroupContactImpl_Cached(impl);
        }
        return impl;
    }

    static IResourceContact getResourceContact(ResourceContact nativeContact) {
        if (nativeContact == null) {
            return null;
        }
        IResourceContact impl = new ResourceContactImpl(nativeContact);
        if (APIWrappingConfigurator.getImplementationMap().get(IResourceContact.class) == ResourceContactImpl_Cached.class) {
            impl = new ResourceContactImpl_Cached(impl);
        }
        return impl;
    }

    public static IAddressBookItemList getAddressBookItemList(AddressBookItemList addressBookItemList) {
        if (addressBookItemList == null) {
            return null;
        }
        IAddressBookItemList impl = new AddressBookItemListImpl(addressBookItemList);
        if (APIWrappingConfigurator.getImplementationMap().get(IAddressBookItemList.class) == AddressBookItemListImpl_Cached.class) {
            impl = new AddressBookItemListImpl_Cached(impl);
        }
        return impl;
    }
}

