/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.api.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyUsageMeasurer
implements InvocationHandler {
    private static Logger logger = Logger.getLogger(ProxyUsageMeasurer.class);
    private Object delegate;
    private Map<Method, CallInfo> callMap = new HashMap<Method, CallInfo>();
    private static int nextInstanceId = 0;
    private int instanceId = nextInstanceId++;

    private ProxyUsageMeasurer(Object delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate is null");
        }
        this.delegate = delegate;
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                ProxyUsageMeasurer.flush(ProxyUsageMeasurer.this);
            }
        }));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        long time = System.currentTimeMillis();
        Object result = method.invoke(this.delegate, args);
        time = System.currentTimeMillis() - time;
        this.registerInvokation(method, time);
        return result;
    }

    private void registerInvokation(Method method, long duration) {
        CallInfo callInfo = this.callMap.get(method);
        if (callInfo == null) {
            callInfo = new CallInfo();
            callInfo.first = duration;
            this.callMap.put(method, callInfo);
        }
        callInfo.number++;
        callInfo.total += duration;
        if (callInfo.max < duration) {
            callInfo.max = duration;
        }
        if (callInfo.min > duration) {
            callInfo.min = duration;
        }
    }

    private static synchronized void flush(ProxyUsageMeasurer instance) {
        logger.debug((Object)("------------> FLUSH STARTED " + instance.instanceId + " (" + instance.delegate + ')'));
        for (Method method : instance.callMap.keySet()) {
            logger.debug((Object)(instance.callMap.get(method) + " (" + method.getName() + ')'));
        }
        logger.debug((Object)"------------> FLUSH FINISHED");
    }

    public static <T> T getProxy(Class interfaceClass, T delegateInstance) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ProxyUsageMeasurer handler = new ProxyUsageMeasurer(delegateInstance);
        Object proxy = Proxy.newProxyInstance(classLoader, new Class[]{interfaceClass}, (InvocationHandler)handler);
        return (T)proxy;
    }

    private class CallInfo {
        private long first = 0L;
        private long max = 0L;
        private long min = 0L;
        private long total = 0L;
        private int number = 0;

        private CallInfo() {
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            builder.append("{call times: 1: ");
            builder.append(this.first);
            builder.append(", max: ");
            builder.append(this.max);
            builder.append(", min: ");
            builder.append(this.min);
            builder.append(", mid: ");
            builder.append(this.total / (long)this.number);
            builder.append(", number of calls: ");
            builder.append(this.number);
            builder.append('}');
            return builder.toString();
        }
    }
}

