/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application;

import com.novell.gw.engine.ItemList;
import com.novell.gw.engine.ItemListEvent;
import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.interfaces.IItemListListener;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendar;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.bl.om.folders.ItemListsCache;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.util.Date;
import org.apache.log4j.Logger;

public class CalendarFolderChangeListener
implements IItemListListener {
    private static Logger logger = Logger.getLogger(CalendarFolderChangeListener.class);
    private GWCalendar calendar;
    private static int nextInstanceId = 0;
    private int instanceId = nextInstanceId++;

    public CalendarFolderChangeListener(GWCalendar theCalendar) {
        logger.debug((Object)("created: " + this));
        this.calendar = theCalendar;
    }

    private String getUserGuid() {
        ControlsUtils.getUserGuid(this.calendar.getController());
        return null;
    }

    private void doRefresh(ItemListEvent e) {
        if (e.getSource() instanceof ItemList) {
            ItemListsCache.clearDirty(APIWrapperManager.getItemList((ItemList)e.getSource()), this.getUserGuid());
        }
        long lStart = e.getTimeStart();
        long lEnd = e.getTimeEnd();
        TimeInterval calendarChangeInterval = lStart > 0L && lEnd - lStart >= 0L ? GWCalendarUtils.getDayTimeInterval(new Date(lStart), new Date(lEnd)) : null;
        this.calendar.notifyRefresh(calendarChangeInterval);
    }

    public void contentsChanged(ItemListEvent e) {
        logger.debug((Object)("Calendar content changed. Event type: [" + e.getType() + "]; " + "start day: [" + new Date(e.getTimeStart()) + "]; " + "end day: [" + new Date(e.getTimeEnd()) + "]"));
        logger.debug((Object)("calendar folder: " + this.calendar.getAbstractFolder()));
        this.doRefresh(e);
    }

    public void moreResultsAvailable(ItemListEvent e) {
    }

    public void queryResultsDone(ItemListEvent e) {
    }

    public void notifyEmptyList(ItemListEvent e) {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append('[');
        builder.append("instanceId=");
        builder.append(this.instanceId);
        builder.append(']');
        return builder.toString();
    }
}

