/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrameActionList;
import com.appframework.filter.FiltersFactory;
import com.appframework.mvc.Command;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IContactsFolder;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.GWMainAppFrameActionList;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.filter.ActionContextItemContactFilter;
import com.novell.gw.jclient.application.controls.menus.AbstractActionsPopupMenu;
import com.novell.gw.jclient.application.controls.menus.CategoriesMenuListenerForContacts;
import com.novell.gw.jclient.application.controls.menus.GWApplicationFrameMenuBar;
import com.novell.gw.jclient.application.controls.menus.GWMenu;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.filter.Filter;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.ContactItemDescription;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class ContactTablePopupMenu
extends AbstractActionsPopupMenu {
    private IItemList itemList;
    private ContactItemDescription contactItemDescription;
    private IViewDisplaySettings displaySettings;
    private AbstractFolder abstractFolder;

    public ContactTablePopupMenu(ActionList theActionList, IItemList theItemList) {
        super(theActionList);
        this.itemList = theItemList;
    }

    private void build() {
        JMenuItem menuItem;
        if (this.itemList != null) {
            menuItem = this.actionList.getAction(ActionKey.VIEW_CONTACT_DETAILS).getMenuItem();
            this.add(menuItem);
        }
        GWMenu menu = new GWMenu(StringResources.NEW);
        boolean needAddContact = !(this.abstractFolder.getNativeFolder() instanceof IContactsFolder) || !((IContactsFolder)this.abstractFolder.getNativeFolder()).getAddressBook(EngineCommandManager.getAddressBookManager()).isReadOnly();
        GWApplicationFrameMenuBar.rebuildFileNewWithFolder(menu, (ApplicationFrameActionList)this.actionList, needAddContact);
        this.add(menu);
        this.checkMenuOpenedInPanel(this.actionList);
        ActionContextItemContactFilter actionContextItemFilter = (ActionContextItemContactFilter)this.actionList.getAction(ActionKey.CONTEXT_ITEM_CONTACT_FILTER);
        String folderName = ((GWMainAppFrame)((GWMainAppFrameActionList)this.actionList).getMVCView()).getFolder().getName();
        actionContextItemFilter.setModel(this.contactItemDescription, this.isInPanel ? this.panelName : folderName, this.isInPanel);
        this.add(actionContextItemFilter.getMenuItem());
        Filter filter = FiltersFactory.getInstance().getFilter(this.actionList);
        if (filter != null && !filter.isEmpty()) {
            this.add(this.actionList.getAction(ActionKey.CLEAR_FILTER).getMenuItem());
        }
        if (this.itemList != null) {
            menuItem = this.actionList.getAction(ActionKey.DELETE_CONTACT).getMenuItem();
            this.add(menuItem);
            JMenu menuCategories = (JMenu)this.actionList.getAction(ActionKey.EDIT_CATEGORIES_FOR_GWMENU_CONTACTS).getMenuItem();
            menuCategories.addMenuListener(new CategoriesMenuListenerForContacts(this.actionList));
            menuCategories.addSeparator();
            menuCategories.add(menuCategories);
            this.add(menuCategories);
        } else {
            ButtonGroup buttonGroup = new ButtonGroup();
            if (((GWMainAppFrame)this.actionList.getMVCView()).getFolder().getDisplaySettings().getViewMode() != 8) {
                AppAction action = this.actionList.getAction(ActionKey.TOGGLE_GROUP_LABELS);
                this.add(action.getPopupMenuItem());
                this.addSeparator();
                action = this.actionList.getAction(ActionKey.SET_VIEW_MODE_DETAILS);
                this.add(action, buttonGroup);
                action = this.actionList.getAction(ActionKey.SET_VIEW_MODE_PANELS);
                this.add(action, buttonGroup);
                buttonGroup = new ButtonGroup();
                this.addSeparator();
                action = this.actionList.getAction(ActionKey.SET_FOLDER_VIEW_COLUMNS);
                this.add(action, buttonGroup);
                action = this.actionList.getAction(ActionKey.SET_FOLDER_VIEW_SUMMARY);
                this.add(action, buttonGroup);
            } else {
                AppAction action = new ActionToggleGroupLabel(this.actionList);
                this.add(action.getPopupMenuItem());
                this.addSeparator();
                buttonGroup = new ButtonGroup();
                action = new ActionSetFolderViewColumns(this.actionList);
                this.add(action, buttonGroup);
                action = new ActionSetFolderViewSummary(this.actionList);
                this.add(action, buttonGroup);
            }
            this.addSeparator();
            this.add(this.actionList.getAction(ActionKey.SAVE_DISPLAY_SETTINGS));
        }
    }

    public void add(AppAction a, ButtonGroup bg) {
        JMenuItem mi;
        if (a != null && (mi = a.getMenuItem()) != null) {
            if (bg != null) {
                bg.add(mi);
            }
            this.add(mi);
        }
    }

    public void rebuild(IItemList list, ContactItemDescription contactItemDescription, IViewDisplaySettings viewDisplaySettings, AbstractFolder abstractFolder) {
        this.abstractFolder = abstractFolder;
        this.displaySettings = viewDisplaySettings;
        this.contactItemDescription = contactItemDescription;
        this.removeAll();
        this.itemList = list;
        this.build();
    }

    private class ActionToggleGroupLabel
    extends AppAction {
        public ActionToggleGroupLabel(ActionList actionList) {
            super(actionList, ActionKey.TOGGLE_GROUP_LABELS, StringResources.SHOW_GROUP_LABELS);
            this.setType(AppAction.ActionType.CHECKABLE);
            this.setSelected(ContactTablePopupMenu.this.displaySettings.showGroupHeaders());
        }

        protected void performAction(ActionEvent e) {
            ContactTablePopupMenu.this.displaySettings.setShowGroupHeaders(!this.isSelected());
            AbstractFolder folder = ContactTablePopupMenu.this.abstractFolder;
            this.getController().processCommand(new Command(1920, folder));
        }
    }

    private class ActionSetFolderViewSummary
    extends AppAction {
        public ActionSetFolderViewSummary(ActionList actionList) {
            super(actionList, ActionKey.SET_FOLDER_VIEW_SUMMARY, StringResources.VIEW_SUMMARY);
            this.setType(AppAction.ActionType.RADIO);
            this.setSelected(ContactTablePopupMenu.this.displaySettings.isSummaryView());
        }

        protected void performAction(ActionEvent e) {
            ContactTablePopupMenu.this.displaySettings.setSummaryView(true);
            AbstractFolder folder = ContactTablePopupMenu.this.abstractFolder;
            this.getController().processCommand(new Command(1920, folder));
        }
    }

    private class ActionSetFolderViewColumns
    extends AppAction {
        public ActionSetFolderViewColumns(ActionList actionList) {
            super(actionList, ActionKey.SET_FOLDER_VIEW_COLUMNS, StringResources.VIEW_COLUMNS);
            this.setType(AppAction.ActionType.RADIO);
            this.setSelected(!ContactTablePopupMenu.this.displaySettings.isSummaryView());
        }

        protected void performAction(ActionEvent e) {
            ContactTablePopupMenu.this.displaySettings.setSummaryView(false);
            AbstractFolder folder = ContactTablePopupMenu.this.abstractFolder;
            this.getController().processCommand(new Command(1920, folder));
        }
    }
}

