/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application;

import com.appframework.ApplicationFrame;
import com.appframework.mvc.MVCView;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.ClickAction;
import com.novell.gw.jclient.application.DevModeUtils;
import com.novell.gw.jclient.application.GWStatusBarController;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.impl.cache.FoldersCache;
import com.novell.gw.jclient.bl.impl.cache.ItemsCache;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWStatusBar
extends JPanel
implements MVCView<GWStatusBarController, Object> {
    private static Logger logger = Logger.getLogger(GWStatusBar.class);
    private JPanel memoryPanel = null;
    private CachePanel cachePanel = null;
    private ThreadsPanel threadsPanel = null;
    private JPanel debugPanel = null;
    private Timer cacheInfoTimer = null;
    private Timer threadsTimer = null;
    private MessagePanel messagePanel = null;
    private ItemsInfoPanel itemsInfoPanel = null;
    Color bkColor = new Color(236, 233, 176);
    Color fgColor = Color.BLACK;
    Color borderColor = new Color(128, 128, 128);
    private boolean showDevModeInfo = true;
    private int CAHE_INFO_REFRESH_DELLAY = 100;
    private int THREADS_REFRESH_DELLAY = 100;
    private GWStatusBarController controller;

    public GWStatusBar(boolean isMainFrame, boolean needPadLock) {
        this.showDevModeInfo = isMainFrame && DevModeUtils.isShowStatus();
        GridBagLayout gridBagLayoutProxy = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridBagLayoutProxy);
        int x = 0;
        c.gridx = x++;
        c.ipadx = 2;
        c.weightx = 100.0;
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(0, 0, 0, 2);
        this.messagePanel = new MessagePanel();
        this.messagePanel.setBorder(BorderFactory.createLineBorder(this.borderColor));
        this.add((Component)this.messagePanel, c);
        c.gridx = x;
        c.ipadx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        c.insets = OS.isMacOS() ? new Insets(0, 0, 0, 16) : new Insets(0, 0, 0, 2);
        this.itemsInfoPanel = new ItemsInfoPanel();
        this.itemsInfoPanel.setVisible(isMainFrame);
        this.add((Component)this.itemsInfoPanel, c);
        ++x;
        if (needPadLock) {
            OrientableLabel l = new OrientableLabel();
            l.setIcon(ImageResources.PADLOCK);
            l.setToolTipText(StringResources.SSL_SECURED);
            c.gridx = x++;
            this.add((Component)l, c);
        }
        if (this.showDevModeInfo) {
            c.gridx = x;
            c.ipadx = 0;
            c.weightx = 0.0;
            c.fill = 0;
            c.anchor = 13;
            c.insets = new Insets(0, 0, 0, 2);
            this.debugPanel = new OrientablePanel(new BorderLayout());
            this.threadsPanel = new ThreadsPanel();
            this.debugPanel.add((Component)this.threadsPanel, "Before");
            this.memoryPanel = new MemoryPanel();
            this.debugPanel.add((Component)this.memoryPanel, "After");
            this.cachePanel = new CachePanel();
            this.debugPanel.add((Component)this.cachePanel, "Center");
            this.setComponentsBackground(this.debugPanel, Color.WHITE);
            this.add((Component)this.debugPanel, c);
            this.initCacheInfoTimer();
            this.initThreadsTimer();
        }
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    private void setComponentsBackground(JComponent theComponent, Color theColor) {
        Component[] components;
        theComponent.setBackground(theColor);
        for (Component component : components = theComponent.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            this.setComponentsBackground((JComponent)component, theColor);
        }
    }

    public boolean isItemsInfoPanelVisible() {
        return this.itemsInfoPanel.isVisible();
    }

    public void setItemsInfoPanelVisible(boolean isVisible) {
        this.itemsInfoPanel.setVisible(isVisible);
    }

    private void doSetTotalItemsCount(int theItemsCount) {
        this.itemsInfoPanel.updateTotalCount(theItemsCount);
    }

    void setTotalItemsCount(final int theItemsCount) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doSetTotalItemsCount(theItemsCount);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GWStatusBar.this.doSetTotalItemsCount(theItemsCount);
                }
            });
        }
    }

    private void doSetMessage(String theMessage) {
        this.messagePanel.setMessage(theMessage);
    }

    public void setMessage(final String theMessage) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doSetMessage(theMessage);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GWStatusBar.this.doSetMessage(theMessage);
                }
            });
        }
    }

    private void doSetAnimation(ImageIcon theIcon, String theHint, ClickAction theClickAction) {
        this.messagePanel.setAnimation(theIcon, theHint, theClickAction);
    }

    public void setAnimation(final ImageIcon theIcon, final String theHint, final ClickAction theClickAction) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doSetAnimation(theIcon, theHint, theClickAction);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GWStatusBar.this.doSetAnimation(theIcon, theHint, theClickAction);
                }
            });
        }
    }

    private void doSetSelectedItemsCount(int theCount) {
        this.itemsInfoPanel.updateSelectedCount(theCount);
    }

    void setSelectedItemsCount(final int theCount) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doSetSelectedItemsCount(theCount);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GWStatusBar.this.doSetSelectedItemsCount(theCount);
                }
            });
        }
    }

    private void initCacheInfoTimer() {
        this.cacheInfoTimer = new Timer(this.CAHE_INFO_REFRESH_DELLAY, new CacheInfoTimerAction());
        this.cacheInfoTimer.start();
    }

    private void initThreadsTimer() {
        this.threadsTimer = new Timer(this.THREADS_REFRESH_DELLAY, new ThreadsTimerAction());
        this.threadsTimer.start();
    }

    @Override
    public void setController(GWStatusBarController controller) {
        this.controller = controller;
    }

    @Override
    public GWStatusBarController getController() {
        return this.controller;
    }

    @Override
    public void setMVCModel(Object model) {
    }

    @Override
    public Object getMVCModel() {
        return null;
    }

    private void doUpdateCacheInfo() {
        block2: {
            try {
                ApplicationFrame applicationFrame = (ApplicationFrame)SwingUtilities.getWindowAncestor(this);
                int itemsCount = ItemsCache.getCount(applicationFrame.getUserGuid());
                int foldersCount = FoldersCache.getCount(applicationFrame.getUserGuid());
                this.cachePanel.updateInfo(itemsCount, foldersCount);
            }
            catch (NullPointerException e) {
                logger.error((Object)e);
                logger.warn((Object)"probably application is exiting > stopping cacheInfoTimer...");
                if (this.cacheInfoTimer == null) break block2;
                this.cacheInfoTimer.stop();
            }
        }
    }

    private void updateCacheInfo() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doUpdateCacheInfo();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GWStatusBar.this.doUpdateCacheInfo();
                }
            });
        }
    }

    private void doUpdateThreadsInfo() {
        this.threadsPanel.updateInfo(Thread.activeCount());
    }

    private void updateThreadsInfo() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doUpdateThreadsInfo();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GWStatusBar.this.doUpdateThreadsInfo();
                }
            });
        }
    }

    public void clearCounts() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doClearCounts();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GWStatusBar.this.doClearCounts();
                }
            });
        }
    }

    private void doClearCounts() {
        this.itemsInfoPanel.clear();
    }

    private final class ThreadsPanel
    extends JPanel {
        private String threadsText;
        private JLabel lblThreads;

        public ThreadsPanel() {
            this.setLayout(new BorderLayout());
            this.threadsText = "Threads : ";
            this.lblThreads = new OrientableLabel(this.threadsText);
            this.add((Component)this.lblThreads, "Center");
            this.setBorder(BorderFactory.createLineBorder(GWStatusBar.this.borderColor));
            this.setToolTipText("Client's Threads Info");
        }

        public void updateInfo(int theCount) {
            this.lblThreads.setText(this.threadsText + theCount);
        }
    }

    private final class ItemsInfoPanel
    extends JPanel {
        private String selectedText;
        private JLabel lblSelected;
        private String totalText;
        private JLabel lblTotal;

        public ItemsInfoPanel() {
            GridBagLayout gridBagLayoutProxy = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.setLayout(gridBagLayoutProxy);
            c.fill = 0;
            c.insets = new Insets(0, 4, 0, 4);
            c.anchor = 13;
            this.selectedText = StringResources.SELECTED_C + " ";
            this.lblSelected = new OrientableLabel(this.selectedText);
            this.add((Component)this.lblSelected, c);
            c.gridx = 1;
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 10;
            StatusBarSeparator separator = new StatusBarSeparator();
            c.weighty = 1.0;
            c.fill = 3;
            this.add((Component)separator, c);
            c.weighty = 0.0;
            c.fill = 0;
            c.gridx = 2;
            c.insets = new Insets(0, 4, 0, 4);
            c.anchor = 13;
            this.totalText = StringResources.TOTAL_C + " ";
            this.lblTotal = new OrientableLabel(this.totalText);
            this.add((Component)this.lblTotal, c);
            this.setBorder(BorderFactory.createLineBorder(GWStatusBar.this.borderColor));
            this.updateTotalCount(0);
            this.updateSelectedCount(0);
        }

        public void updateTotalCount(int theCount) {
            this.lblTotal.setText(this.totalText + theCount);
        }

        public void updateSelectedCount(int theCount) {
            this.lblSelected.setText(this.selectedText + theCount);
        }

        public void clear() {
            this.lblTotal.setText(this.totalText + 0);
            this.lblSelected.setText(this.selectedText + 0);
        }
    }

    private class StatusBarSeparator
    extends JPanel {
        public StatusBarSeparator() {
            this.setPreferredSize(new Dimension(2, 14));
            this.setBorder(BorderFactory.createLineBorder(GWStatusBar.this.borderColor));
        }
    }

    private final class ThreadsTimerAction
    extends AbstractAction {
        private ThreadsTimerAction() {
        }

        public void actionPerformed(ActionEvent e) {
            GWStatusBar.this.updateThreadsInfo();
        }
    }

    private final class CacheInfoTimerAction
    extends AbstractAction {
        private CacheInfoTimerAction() {
        }

        public void actionPerformed(ActionEvent e) {
            GWStatusBar.this.updateCacheInfo();
        }
    }

    private final class CachePanel
    extends JPanel {
        private JLabel lblFolders = null;
        private JLabel lblItems = null;
        private String foldersText;
        private String itemsText;

        public CachePanel() {
            GridBagLayout gridBagLayoutProxy = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 0;
            c.anchor = 21;
            this.setLayout(gridBagLayoutProxy);
            c.insets = new Insets(0, 2, 0, 2);
            this.foldersText = "Folders : ";
            this.lblFolders = new OrientableLabel(this.foldersText);
            this.add((Component)this.lblFolders, c);
            c.gridx = 1;
            c.insets = new Insets(2, 2, 2, 2);
            c.anchor = 10;
            StatusBarSeparator separator = new StatusBarSeparator();
            this.add((Component)separator, c);
            c.gridx = 2;
            c.insets = new Insets(0, 0, 0, 2);
            c.anchor = 13;
            this.itemsText = "Items : ";
            this.lblItems = new OrientableLabel(this.itemsText);
            this.add((Component)this.lblItems, c);
            this.setBorder(BorderFactory.createLineBorder(GWStatusBar.this.borderColor));
            this.setToolTipText("Client's Cache Info");
        }

        public void updateInfo(int theItemsCount, int theFoldersCount) {
            this.lblItems.setText(this.itemsText + theItemsCount);
            this.lblFolders.setText(this.foldersText + theFoldersCount);
        }
    }

    private final class MemoryPanel
    extends JPanel {
        private MemoryStatus memoryStatus = null;

        public MemoryPanel() {
            GridBagLayout gridBagLayoutProxy = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 0;
            c.anchor = 13;
            this.setLayout(gridBagLayoutProxy);
            c.gridx = 0;
            c.gridy = 0;
            c.insets = new Insets(0, 2, 0, 2);
            this.memoryStatus = new MemoryStatus();
            this.add((Component)this.memoryStatus, c);
            c.gridx = 1;
            c.insets = new Insets(0, 0, 0, 2);
            OrientableLabel lblGCLock = new OrientableLabel();
            lblGCLock.setIcon(ImageResources.ICON_GC);
            lblGCLock.setToolTipText("Run Garbage Collector");
            lblGCLock.setPreferredSize(new Dimension(18, 18));
            lblGCLock.setBorder(BorderFactory.createLineBorder(GWStatusBar.this.borderColor));
            lblGCLock.addMouseListener(new GCMouseListener());
            this.add((Component)lblGCLock, c);
        }

        private class GCMouseListener
        extends MouseAdapter {
            private GCMouseListener() {
            }

            public void mouseClicked(MouseEvent e) {
                System.gc();
                MemoryPanel.this.memoryStatus.repaint();
            }
        }
    }

    private final class MessagePanel
    extends JPanel {
        private JLabel messageLabel = null;
        private JLabel lblAnimeStatus = null;
        private ClickAction clickAction;
        private ClickListener clickListener;

        public MessagePanel() {
            this.setLayout(new BorderLayout());
            this.lblAnimeStatus = new OrientableLabel("");
            this.lblAnimeStatus.setPreferredSize(new Dimension(18, 18));
            this.lblAnimeStatus.setBorder(new EmptyBorder(0, 4, 0, 0));
            this.add((Component)this.lblAnimeStatus, "Before");
            this.messageLabel = new OrientableLabel();
            this.messageLabel.setBorder(new EmptyBorder(0, 4, 0, 4));
            this.add((Component)this.messageLabel, "Center");
            this.clickListener = new ClickListener();
        }

        public void setMessage(String theMessage) {
            this.messageLabel.setText(theMessage);
        }

        public void setAnimation(ImageIcon theIcon, String theHint, ClickAction theClickAction) {
            this.lblAnimeStatus.setIcon(theIcon);
            this.lblAnimeStatus.setIconTextGap(0);
            this.lblAnimeStatus.setHorizontalAlignment(0);
            this.lblAnimeStatus.setVerticalAlignment(0);
            this.lblAnimeStatus.setToolTipText(theHint);
            this.setClickAction(theClickAction);
        }

        private void setClickAction(ClickAction theClickAction) {
            MouseListener[] mouseListeners;
            this.clickAction = theClickAction;
            for (MouseListener mouseListener : mouseListeners = this.lblAnimeStatus.getMouseListeners()) {
                this.lblAnimeStatus.removeMouseListener(mouseListener);
            }
            if (this.clickAction != null) {
                this.lblAnimeStatus.addMouseListener(this.clickListener);
            }
        }

        private class ClickListener
        implements MouseListener {
            private ClickListener() {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
                MessagePanel.this.clickAction.click();
            }
        }
    }

    private class MemoryStatus
    extends JComponent
    implements ActionListener {
        static final String memoryTestStr = "O99,9/O99,9Mb";
        private LineMetrics lm;
        private Color progressForeground;
        private Color progressBackground;
        private Timer timer;
        private NumberFormat numberFormat;

        public MemoryStatus() {
            Font font = UIManager.getFont("Label.font");
            this.setFont(font);
            FontRenderContext frc = new FontRenderContext(null, true, false);
            this.lm = font.getLineMetrics(memoryTestStr, frc);
            this.progressForeground = GWStatusBar.this.fgColor;
            this.progressBackground = GWStatusBar.this.bkColor;
            this.setBorder(BorderFactory.createLineBorder(GWStatusBar.this.borderColor));
            this.setDoubleBuffered(true);
            this.setForeground(UIManager.getColor("Label.foreground"));
            this.setBackground(UIManager.getColor("Label.background"));
            this.setFont(UIManager.getFont("Label.font"));
            this.numberFormat = NumberFormat.getNumberInstance();
            this.numberFormat.setMaximumIntegerDigits(3);
            this.numberFormat.setMaximumFractionDigits(1);
            this.numberFormat.setMinimumFractionDigits(1);
            this.setPreferredSize(new Dimension(100, 18));
        }

        public void addNotify() {
            super.addNotify();
            this.timer = new Timer(2000, this);
            this.timer.start();
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public void removeNotify() {
            this.timer.stop();
            ToolTipManager.sharedInstance().unregisterComponent(this);
            super.removeNotify();
        }

        public void actionPerformed(ActionEvent evt) {
            this.repaint();
        }

        public void paintComponent(Graphics g) {
            Insets insets = new Insets(0, 0, 0, 0);
            Insets strInsets = new Insets(2, 0, 0, 0);
            Runtime runtime = Runtime.getRuntime();
            int freeMemory = (int)(runtime.freeMemory() / 1024L);
            int totalMemory = (int)(runtime.totalMemory() / 1024L);
            int usedMemory = totalMemory - freeMemory;
            int width = this.getWidth() - insets.left - insets.right;
            int height = this.getHeight() - insets.top - insets.bottom - 1;
            float fraction = (float)usedMemory / (float)totalMemory;
            g.setColor(this.progressBackground);
            g.fillRect(insets.left, insets.top, (int)((float)width * fraction), height);
            StringBuffer str = new StringBuffer();
            str.append(this.numberFormat.format((double)usedMemory / 1024.0));
            str.append("/");
            str.append(this.numberFormat.format((double)totalMemory / 1024.0));
            str.append("Mb");
            FontRenderContext frc = new FontRenderContext(null, true, false);
            Rectangle2D bounds = g.getFont().getStringBounds(str.toString(), frc);
            Graphics g2 = g.create();
            g2.setClip(strInsets.left, strInsets.top, (int)((float)width * fraction), height);
            g2.setColor(this.progressForeground);
            g2.drawString(str.toString(), strInsets.left + (int)((double)width - bounds.getWidth()) / 2, (int)((float)strInsets.top + this.lm.getAscent()));
            g2.dispose();
            g2 = g.create();
            g2.setClip(insets.left + (int)((float)width * fraction), insets.top, this.getWidth() - insets.left - (int)((float)width * fraction), height);
            g2.setColor(this.getForeground());
            g2.drawString(str.toString(), strInsets.left + (int)((double)width - bounds.getWidth()) / 2, (int)((float)strInsets.top + this.lm.getAscent()));
            g2.dispose();
        }
    }
}

