/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application;

import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.application.GWStatusBar;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListComponent;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListView;
import com.novell.gw.jclient.application.controls.panelviews.PanelType;
import com.novell.gw.jclient.application.controls.panelviews.PanelView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWStatusBarController
extends MVCController<GWStatusBar> {
    private ItemListView itemListView;

    public GWStatusBarController(GWStatusBar view, MVCController parentController) {
        super(view, parentController);
    }

    @Override
    protected void initListeners() {
        super.initListeners();
        Level level = this.getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 2090, new ITEM_SELECTED_Listener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 2070, new ITEM_LIST_VEW_SELECTED_Listener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 1860, new PANEL_SELECTED_Listener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 2100, new ITEM_LIST_CHANGED_Listener()));
    }

    private class ITEM_LIST_CHANGED_Listener
    extends AppEventListener {
        private ITEM_LIST_CHANGED_Listener() {
        }

        public void handle(AppEvent event) {
            ItemListView itemListView = (ItemListView)event.getData();
            if (itemListView != null && itemListView.equals(GWStatusBarController.this.itemListView)) {
                ((GWStatusBar)GWStatusBarController.this.getMVCView()).setTotalItemsCount(itemListView.getItemList().getDisplayItemCount());
            }
        }
    }

    private class PANEL_SELECTED_Listener
    extends AppEventListener {
        private PANEL_SELECTED_Listener() {
        }

        public void handle(AppEvent event) {
            PanelView panelView = (PanelView)event.getData();
            PanelType panelType = panelView.getPanelType();
            if (panelType == PanelType.CONTACTS_TABLE_PANEL || panelType == PanelType.ITEM_LIST_TABLE_PANEL) {
                ((GWStatusBar)GWStatusBarController.this.getMVCView()).setTotalItemsCount(panelView.getRealItemCount());
                ((GWStatusBar)GWStatusBarController.this.getMVCView()).setSelectedItemsCount(panelView.getSelectedItemCount());
            }
        }
    }

    private class ITEM_LIST_VEW_SELECTED_Listener
    extends AppEventListener {
        private ITEM_LIST_VEW_SELECTED_Listener() {
        }

        public void handle(AppEvent event) {
            ItemListView itemListView = (ItemListView)event.getData();
            if (itemListView != null && !itemListView.isDead()) {
                GWStatusBarController.this.itemListView = itemListView;
                ItemListComponent component = itemListView.getItemListComponent();
                if (component != null) {
                    ((GWStatusBar)GWStatusBarController.this.getMVCView()).setTotalItemsCount(itemListView.getItemList().getDisplayItemCount());
                    ((GWStatusBar)GWStatusBarController.this.getMVCView()).setSelectedItemsCount(component.getSelectedItems().length);
                } else {
                    ((GWStatusBar)GWStatusBarController.this.getMVCView()).setSelectedItemsCount(0);
                }
            }
        }
    }

    private class ITEM_SELECTED_Listener
    extends AppEventListener {
        private ITEM_SELECTED_Listener() {
        }

        public void handle(AppEvent event) {
            IItem[] items = (IItem[])event.getData();
            if (items != null) {
                ((GWStatusBar)GWStatusBarController.this.getMVCView()).setSelectedItemsCount(items.length);
            }
        }
    }
}

