/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.ActionMarkAllMessagesRead;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListView;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import javax.swing.Icon;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractItemListAction
extends AppAction<Object> {
    private static final Logger logger = Logger.getLogger(ActionMarkAllMessagesRead.class);
    protected AbstractFolder folder;

    public AbstractItemListAction(ActionList actionList, ActionKey actionKey) {
        super(actionList, actionKey);
    }

    public AbstractItemListAction(ActionList actionList, ActionKey actionKey, String name) {
        super(actionList, actionKey, name);
    }

    public AbstractItemListAction(ActionList actionList, ActionKey actionKey, String name, Icon icon) {
        super(actionList, actionKey, name, icon);
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        Level level = this.getController().getFrameLevel();
        AppEventListener listener = new FOLDER_LIGHT_SELECTED_Listener();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 960, listener));
        listener = new ITEM_LIST_VIEW_SELECTED_Listener();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 2070, listener));
    }

    protected IItemList getItemList() {
        Object model = this.getMVCModel();
        if (this.folder != null) {
            if (model instanceof ItemListView && ((ItemListView)model).getAbstractFolder().equals(this.folder)) {
                return ((ItemListView)model).getItemList();
            }
            return this.folder.getItemList();
        }
        if (model instanceof ItemListView) {
            return ((ItemListView)model).getItemList();
        }
        return null;
    }

    @Override
    public void setMVCModel(Object model) {
        if (model instanceof AbstractFolder) {
            this.folder = (AbstractFolder)model;
        } else {
            super.setMVCModel(model);
        }
        this.setEnabled(this.checkEnableOnSelect());
    }

    protected boolean checkEnableOnSelect() {
        return this.getMVCModel() != null || this.folder != null;
    }

    private class ITEM_LIST_VIEW_SELECTED_Listener
    extends AppEventListener {
        private ITEM_LIST_VIEW_SELECTED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            AbstractItemListAction.this.folder = null;
            AbstractItemListAction.this.setMVCModel(theEvent.getData());
        }
    }

    private class FOLDER_LIGHT_SELECTED_Listener
    extends AppEventListener {
        private FOLDER_LIGHT_SELECTED_Listener() {
        }

        public void handle(AppEvent event) {
            AbstractItemListAction.this.setMVCModel(event.getData());
        }
    }
}

