/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.api.enums.AppointmentAcceptLevel;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.RadioButtonGroup;
import com.novell.gw.jclient.application.controls.TitledPanel;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicCheckBox;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicRadioButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.CalendarFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;

public class AcceptDeclineOptionPane
extends JComponent {
    private static Logger logger = Logger.getLogger(AcceptDeclineOptionPane.class);
    private static final String BUTTON_PRESSED_PROPERTY = "buttonPressed";
    private static final int MODE_ACCEPT = 1;
    private static final int MODE_DECLINE = 2;
    private int mode = 1;
    private AbstractItem item;
    private Options selectedOptions = null;
    private ButtonGroup bgAcceptLevel;
    private JRadioButton rbFree;
    private JRadioButton rbTentative;
    private JRadioButton rbBusy;
    private JRadioButton rbOutOfOffice;
    private JTextArea taComment;
    private JCheckBox cbDeleteItem;
    private JButton btnOK;
    private JButton btnCancel;
    private JList calendarList;

    public static Options showAcceptWithOptionsOptionPane(Component theComponent, AbstractItem theItem) {
        AcceptDeclineOptionPane pane = new AcceptDeclineOptionPane(1, theItem);
        JDialog dialog = pane.createDialog(theComponent, StringResources.ACCEPT_WITH_OPTIONS);
        dialog.show();
        dialog.dispose();
        return pane.selectedOptions;
    }

    public static Options showDeclineWithOptionsOptionPane(Component theComponent, AbstractItem theItem) {
        AcceptDeclineOptionPane pane = new AcceptDeclineOptionPane(2, theItem);
        JDialog dialog = pane.createDialog(theComponent, StringResources.DECLINE_WITH_OPTIONS);
        dialog.show();
        dialog.dispose();
        return pane.selectedOptions;
    }

    private JDialog createDialog(Component parentComponent, String title) {
        final JDialog dialog = parentComponent instanceof JFrame ? new JDialog((JFrame)parentComponent, title, true) : (parentComponent instanceof JDialog ? new JDialog((JDialog)parentComponent, title, true) : new JDialog((Frame)null, title, true));
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this, "Center");
        this.init(dialog);
        dialog.getRootPane().setDefaultButton(this.btnOK);
        dialog.pack();
        dialog.setModal(true);
        dialog.setLocationRelativeTo(parentComponent);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                dialog.setVisible(false);
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (dialog.isVisible() && event.getSource() == AcceptDeclineOptionPane.this && event.getPropertyName().equals(AcceptDeclineOptionPane.BUTTON_PRESSED_PROPERTY) && event.getNewValue() != null) {
                    dialog.setVisible(false);
                }
            }
        });
        this.taComment.requestFocus();
        return dialog;
    }

    private AcceptDeclineOptionPane(int theMode, AbstractItem theItem) throws HeadlessException {
        this.item = theItem;
        this.mode = theMode;
    }

    private void init(Window parent) {
        this.setComponentOrientation(UIUtils.getComponentOrientation());
        this.buildUI(parent);
        this.setMode();
    }

    private void buildUI(Window window) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 23;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(10, 10, 10, 7);
        this.add(this.createShowAsPanel(window), constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(10, 7, 10, 10);
        this.add(this.createCommentPanel(), constraints);
        if (this.mode == 1) {
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.gridwidth = 2;
            this.add((Component)this.initCalendarList(), constraints);
        }
        constraints.anchor = 20;
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 10, 10, 10);
        this.add(this.createButtonsPanel(), constraints);
    }

    private JComponent initCalendarList() {
        this.calendarList = new JList();
        this.calendarList.setModel(new CalendarListModel());
        this.calendarList.setCellRenderer(new CalendarListRenderer());
        this.calendarList.setSelectedIndex(0);
        JScrollPane calendarScroll = new JScrollPane(this.calendarList);
        calendarScroll.setPreferredSize(new Dimension(400, 150));
        JPanel calendarPnl = new JPanel(new BorderLayout());
        calendarPnl.add((Component)new OrientableLabel(StringResources.ACCEPT_TO), "North");
        calendarPnl.add((Component)calendarScroll, "Center");
        return calendarPnl;
    }

    private Component createButtonsPanel() {
        this.cbDeleteItem = new JMnemonicCheckBox(StringResources.CHECK_BOX_DELETE_ITEM);
        this.cbDeleteItem.addActionListener(new DeleteItemCheckBoxActionListener());
        this.btnOK = new JButton(new OKButtonAction());
        this.btnCancel = new JButton(new CancelButtonAction());
        OrientablePanel pnlButtons = new OrientablePanel();
        pnlButtons.setLayout(new GridLayout(0, 2, 7, 0));
        OS.addButtons(pnlButtons, this.btnOK, this.btnCancel);
        OrientablePanel pnlBottom = new OrientablePanel();
        pnlBottom.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.gridx = 0;
        constraints.weightx = 1.0;
        pnlBottom.add((Component)this.cbDeleteItem, constraints);
        constraints.insets = new Insets(0, 10, 0, 0);
        constraints.anchor = 22;
        constraints.gridx = 1;
        constraints.weightx = 0.0;
        pnlBottom.add((Component)pnlButtons, constraints);
        return pnlBottom;
    }

    private Component createCommentPanel() {
        this.taComment = new GWTextArea();
        JMnemonicLabel lbComment = new JMnemonicLabel(StringResources.TEXT_AREA_COMMENT_LABEL, this.taComment);
        OrientablePanel pnlComment = new OrientablePanel();
        pnlComment.setLayout(new BorderLayout(0, 5));
        pnlComment.add((Component)lbComment, "North");
        OrientableScrollPane scroll = new OrientableScrollPane(this.taComment);
        pnlComment.add((Component)scroll, "Center");
        scroll.setPreferredSize(new Dimension(200, scroll.getPreferredSize().height));
        return pnlComment;
    }

    private Component createShowAsPanel(Window window) {
        this.rbFree = new JMnemonicRadioButton(StringResources.RADIO_BUTTON_FREE);
        this.rbTentative = new JMnemonicRadioButton(StringResources.RADIO_BUTTON_TENTATIVE);
        this.rbBusy = new JMnemonicRadioButton(StringResources.RADIO_BUTTON_BUSY);
        this.rbOutOfOffice = new JMnemonicRadioButton(StringResources.RADIO_BUTTON_OUT_OF_OFFICE);
        this.bgAcceptLevel = new RadioButtonGroup(window);
        this.bgAcceptLevel.add(this.rbFree);
        this.bgAcceptLevel.add(this.rbTentative);
        this.bgAcceptLevel.add(this.rbBusy);
        this.bgAcceptLevel.add(this.rbOutOfOffice);
        TitledPanel pnlAcceptLevel = new TitledPanel(BorderFactory.createEtchedBorder(1), StringResources.SHOW_AS);
        pnlAcceptLevel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 23;
        constraints.weightx = 1.0;
        constraints.gridy = 0;
        pnlAcceptLevel.add((Component)this.rbFree, constraints);
        constraints.gridy = 1;
        pnlAcceptLevel.add((Component)this.rbTentative, constraints);
        constraints.gridy = 2;
        pnlAcceptLevel.add((Component)this.rbBusy, constraints);
        constraints.gridy = 3;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        pnlAcceptLevel.add((Component)this.rbOutOfOffice, constraints);
        return pnlAcceptLevel;
    }

    private void setMode() {
        if (this.item instanceof AppointmentItem) {
            this.selectAcceptLevelRutton(((AppointmentItem)this.item).getShowAsLevel());
            if (this.mode == 1) {
                this.cbDeleteItem.setEnabled(false);
                if (this.bgAcceptLevel.getSelection() == null) {
                    this.rbBusy.setSelected(true);
                }
            } else if (this.mode == 2) {
                if (this.bgAcceptLevel.getSelection() == null) {
                    this.rbFree.setSelected(true);
                }
                this.cbDeleteItem.setSelected(true);
                this.setEnabledAcceptLevelPanel(false);
            }
        } else {
            this.setEnabledAcceptLevelPanel(false);
            this.cbDeleteItem.setEnabled(false);
        }
    }

    private void selectAcceptLevelRutton(AppointmentAcceptLevel theAcceptLevel) {
        if (theAcceptLevel == AppointmentAcceptLevel.BUSY) {
            this.rbBusy.setSelected(true);
        } else if (theAcceptLevel == AppointmentAcceptLevel.FREE) {
            this.rbFree.setSelected(true);
        } else if (theAcceptLevel == AppointmentAcceptLevel.OUT_OF_OFFICE) {
            this.rbOutOfOffice.setSelected(true);
        } else if (theAcceptLevel == AppointmentAcceptLevel.TENTATIVE) {
            this.rbTentative.setSelected(true);
        }
    }

    private void setEnabledAcceptLevelPanel(boolean isEnabled) {
        this.rbFree.setEnabled(isEnabled);
        this.rbTentative.setEnabled(isEnabled);
        this.rbBusy.setEnabled(isEnabled);
        this.rbOutOfOffice.setEnabled(isEnabled);
    }

    private Options getSelectedOptions() {
        return this.selectedOptions;
    }

    private void setSelectedOptions(Options selectedOptions) {
        this.selectedOptions = selectedOptions;
    }

    private void fireButtonPressed(Object theButton) {
        this.firePropertyChange(BUTTON_PRESSED_PROPERTY, null, theButton);
    }

    private AppointmentAcceptLevel getSelectedAcceptLevel() {
        AppointmentAcceptLevel result = AppointmentAcceptLevel.NONE;
        if (this.rbFree.isSelected()) {
            result = AppointmentAcceptLevel.FREE;
        } else if (this.rbTentative.isSelected()) {
            result = AppointmentAcceptLevel.TENTATIVE;
        } else if (this.rbBusy.isSelected()) {
            result = AppointmentAcceptLevel.BUSY;
        } else if (this.rbOutOfOffice.isSelected()) {
            result = AppointmentAcceptLevel.OUT_OF_OFFICE;
        }
        return result;
    }

    private Options createSelectedOptins() {
        Options selectedOptions = new Options();
        selectedOptions.setAcceptLevel(this.getSelectedAcceptLevel());
        selectedOptions.setDeleteItem(this.cbDeleteItem.isSelected());
        selectedOptions.setComment(this.taComment.getText());
        if (this.mode == 1) {
            selectedOptions.setCalendar((AbstractFolder)this.calendarList.getModel().getElementAt(this.calendarList.getSelectedIndex()));
        }
        return selectedOptions;
    }

    private class CalendarListRenderer
    extends JLabel
    implements ListCellRenderer {
        public CalendarListRenderer() {
            this.setOpaque(true);
            this.setBorder(new EmptyBorder(2, 2, 0, 2));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            AbstractFolder f = (AbstractFolder)value;
            this.setIcon(ControlsUtils.getImageForFolder(f));
            this.setText(f.getName());
            if (isSelected || cellHasFocus) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    private class CalendarListModel
    extends DefaultListModel {
        private List folderList;
        private CalendarFolder calendarFolder = EngineCommandManager.getCalendarFolder(EngineCommandManager.getUserGuid());

        public CalendarListModel() {
            this.folderList = this.calendarFolder.getChildFolders();
        }

        public Object getElementAt(int index) {
            if (index == 0) {
                return this.calendarFolder;
            }
            return this.folderList.get(index - 1);
        }

        public int getSize() {
            return this.folderList.size() + 1;
        }
    }

    public static class Options {
        AppointmentAcceptLevel acceptLevel;
        boolean deleteItem;
        String comment;
        AbstractFolder calendar;

        public AppointmentAcceptLevel getAcceptLevel() {
            return this.acceptLevel;
        }

        public void setAcceptLevel(AppointmentAcceptLevel acceptLevel) {
            this.acceptLevel = acceptLevel;
        }

        public boolean isDeleteItem() {
            return this.deleteItem;
        }

        public void setDeleteItem(boolean deleteItem) {
            this.deleteItem = deleteItem;
        }

        public String getComment() {
            return this.comment;
        }

        public AbstractFolder getCalendar() {
            return this.calendar;
        }

        public void setCalendar(AbstractFolder calendar) {
            this.calendar = calendar;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public String toString() {
            return "[acceptLevel=" + (Object)((Object)this.acceptLevel) + ", " + "deleteItem=" + this.deleteItem + ", " + "comment=" + this.comment + ']';
        }
    }

    private class DeleteItemCheckBoxActionListener
    implements ActionListener {
        private DeleteItemCheckBoxActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            AcceptDeclineOptionPane pane = AcceptDeclineOptionPane.this;
            if (pane.mode == 2) {
                pane.setEnabledAcceptLevelPanel(!pane.cbDeleteItem.isSelected());
            }
        }
    }

    private class CancelButtonAction
    extends AbstractAction {
        public CancelButtonAction() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent e) {
            AcceptDeclineOptionPane.this.fireButtonPressed(e.getSource());
        }
    }

    private class OKButtonAction
    extends AbstractAction {
        public OKButtonAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent e) {
            AcceptDeclineOptionPane form = AcceptDeclineOptionPane.this;
            form.setSelectedOptions(form.createSelectedOptins());
            AcceptDeclineOptionPane.this.fireButtonPressed(e.getSource());
        }
    }
}

