/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ApplicationFrameActionList;
import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.actions.AbstractActionBusySearch;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.ActionNewAppointment;
import com.novell.gw.jclient.application.controls.busysearch.BusySearchDialog;
import com.novell.gw.jclient.application.controls.busysearch.BusySearchFrame;
import com.novell.gw.jclient.application.controls.busysearch.BusySearchFrameActionList;
import com.novell.gw.jclient.application.controls.busysearch.BusySearchUtils;
import com.novell.gw.jclient.application.controls.busysearch.GWBusySearch;
import com.novell.gw.jclient.application.controls.busysearch.RecipientDescriptionsList;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ActionBusySearch
extends AbstractActionBusySearch {
    public ActionBusySearch(ApplicationFrameActionList theAppActionList) {
        super(theAppActionList, ActionKey.BUSYSEARCH);
    }

    protected void performAction(ActionEvent event) {
        BusySearchDialog inviteToMeetingDialog = new BusySearchDialog((JFrame)this.getActionList().getMVCView(), (MVCController)this.getActionList());
        inviteToMeetingDialog.pack();
        inviteToMeetingDialog.setLocationRelativeTo(null);
        inviteToMeetingDialog.setVisible(true);
        if (inviteToMeetingDialog.isOkActionProcessed()) {
            int daysCount = inviteToMeetingDialog.getDaysCount();
            Date startDate = inviteToMeetingDialog.getStartDate();
            Date endDate = new Date(startDate.getTime() + (long)(daysCount * 24 * 60 * 60 * 1000));
            RecipientDescriptionsList recipientDescriptionsList = inviteToMeetingDialog.getRecepientDescriptinsList();
            Date appIntEnd = new Date(startDate.getTime() + 3600000L);
            TimeInterval appointmentTimeInterval = new TimeInterval(startDate, appIntEnd);
            try {
                if (!BusySearchUtils.hasValidRecipient(recipientDescriptionsList.getDistributionList())) {
                    JOptionPane.showMessageDialog(null, StringResources.BYSY_SEARCH_NO_VALID_USERS);
                    return;
                }
                GWBusySearch gwBusySearch = GWCommandManager.getInstance(this.getUserGuid()).composeBusySearch(recipientDescriptionsList, startDate, daysCount, appointmentTimeInterval);
                BusySearchFrame busySearchFrame = new BusySearchFrame(gwBusySearch, GWClient.getApplication(), this.getUserGuid());
                ActionNewAppointment actionNewAppointment = (ActionNewAppointment)this.getActionList().getAction(ActionKey.NEW_APPOINTMENT);
                busySearchFrame.setNewAppointmentAction(actionNewAppointment);
                busySearchFrame.showMe();
                GlobalCommand command = new GlobalCommand(480, busySearchFrame);
                ((BusySearchFrameActionList)busySearchFrame.getController()).processCommand(command);
            }
            catch (GWCommandException e) {
                logger.error((Object)e, (Throwable)e);
            }
        }
        inviteToMeetingDialog.dispose();
    }
}

