/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrame;
import com.appframework.ApplicationFrameActionList;
import com.appframework.components.customizedbutton.listpopuppane.ListPopupPane;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.novell.gw.jclient.api.enums.ContactType;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.ContactDetailsDialog;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.SelectContactTypeDialog;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;

public class ActionCreateABItem
extends AppAction {
    public ActionCreateABItem(ApplicationFrameActionList theAppActionList) {
        super((ActionList)theAppActionList, ActionKey.CREATE_CONTACT, StringResources.ACTION_ADD_D, ImageResources.ICON_ADDRESS_BOOK_NEW_ENTRY);
        boolean isProxyDataStore = EngineCommandManager.getInstance(ControlsUtils.getUserGuid(this.actionList)).isProxyDataStore();
        this.setEnabled(!isProxyDataStore);
    }

    protected void performAction(ActionEvent e) {
        ApplicationFrame applicationFrame = (ApplicationFrame)this.getActionList().getMVCView();
        SelectContactTypeDialog newEntryDialog = new SelectContactTypeDialog(applicationFrame);
        newEntryDialog.showMe();
        if (newEntryDialog.isActionCompleteSuccessfully()) {
            ContactType contactType = newEntryDialog.getContactType();
            AbstractAddressBook directory = (AbstractAddressBook)this.getMVCModel();
            if (directory == null) {
                directory = EngineCommandManager.getContactsFolderAddressBook();
            }
            ContactDetailsDialog dialog = ContactDetailsDialog.createContactDetailsDialog((Window)applicationFrame, directory, contactType);
            dialog.showMe();
        }
        newEntryDialog.dispose();
    }

    protected void registerListeners() {
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 360, new DIRECTORY_SELECTED_Listener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 800, new STORE_MODE_CHANGED_Listener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 750, new PROXY_DATA_STORE_INSTALLED_Listener()));
    }

    public JComponent getToolBarComponent() {
        ListPopupPane buttons = new ListPopupPane(this, StringResources.NEW);
        buttons.addAction(this.actionList.getAction(ActionKey.NEW_CONTACT), StringResources.CONTACT);
        buttons.addAction(this.actionList.getAction(ActionKey.NEW_RESOURCE), StringResources.RESOURCE);
        buttons.addAction(this.actionList.getAction(ActionKey.NEW_ORGANIZATION), StringResources.ORGANIZATION);
        buttons.addAction(this.actionList.getAction(ActionKey.NEW_GROUP), StringResources.GROUP);
        return buttons;
    }

    private class PROXY_DATA_STORE_INSTALLED_Listener
    extends AppEventListener {
        private PROXY_DATA_STORE_INSTALLED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            ActionCreateABItem.this.setEnabled(false);
        }
    }

    private class STORE_MODE_CHANGED_Listener
    extends AppEventListener {
        private STORE_MODE_CHANGED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            AbstractAddressBook directory = (AbstractAddressBook)ActionCreateABItem.this.getMVCModel();
            ActionCreateABItem.this.setEnabled(!directory.isReadOnly());
        }
    }

    private class DIRECTORY_SELECTED_Listener
    extends AppEventListener {
        private DIRECTORY_SELECTED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            AbstractAddressBook tempDirectory = (AbstractAddressBook)theEvent.getData();
            ActionCreateABItem.super.setMVCModel(tempDirectory);
            boolean isProxyDataStore = EngineCommandManager.getInstance(ControlsUtils.getUserGuid(ActionCreateABItem.this.getActionList())).isProxyDataStore();
            if (isProxyDataStore) {
                ActionCreateABItem.this.setEnabled(false);
                return;
            }
            if (tempDirectory.isReadOnly()) {
                ActionCreateABItem.this.setEnabled(false);
            } else {
                ActionCreateABItem.this.setEnabled(true);
            }
        }
    }
}

