/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrameActionList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import com.novell.gw.jclient.bl.om.directory.PersonalAddressBook;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class ActionDeleteAddressBook
extends AppAction {
    private static Logger logger = Logger.getLogger(ActionDeleteAddressBook.class);

    public ActionDeleteAddressBook(ApplicationFrameActionList theAppActionList) {
        super((ActionList)theAppActionList, ActionKey.DELETE_ADDRESSBOOK, StringResources.DELETE_BOOK_D, ImageResources.ACT_ITEM_REMOVE);
        this.setEnabled(false);
    }

    protected void performAction(ActionEvent e) {
        try {
            AbstractAddressBook directory = (AbstractAddressBook)this.getMVCModel();
            int result = JOptionPane.showConfirmDialog(this.getActionList().getOwnerComponent(), StringResources.formatString(StringResources.DELETING_THE_ADDRESS_BOOK_NAMED_Q, directory.getName(), directory.getName()), StringResources.ADDRESS_BOOK_K_QUESTION, 0);
            if (result == 0) {
                EngineCommandManager.deleteAddressBook((PersonalAddressBook)directory);
            }
        }
        catch (EngineException e1) {
            logger.debug((Object)e1, (Throwable)e1);
        }
    }

    protected void registerListeners() {
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 360, new DIRECTORY_SELECTED_Listener()));
    }

    private class DIRECTORY_SELECTED_Listener
    extends AppEventListener {
        private DIRECTORY_SELECTED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            Object data = theEvent.getData();
            ActionDeleteAddressBook.this.setMVCModel(data);
            if (data instanceof PersonalAddressBook && !((PersonalAddressBook)data).getNativeAddressBook().isFrequentContacts()) {
                ActionDeleteAddressBook.this.setEnabled(true);
            } else {
                ActionDeleteAddressBook.this.setEnabled(false);
            }
        }
    }
}

