/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.ApplicationFrameActionList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.item.AbstractGWItemAction;
import com.novell.gw.jclient.application.controls.folderstree.MainGWFoldersTree;
import com.novell.gw.jclient.application.dialogs.folderproperties.FolderPropertiesDialog;
import com.novell.gw.jclient.application.frames.open.FrameOpen;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class ActionDisplayFolderOrItemProperties
extends AbstractGWItemAction {
    private AbstractFolder folder;

    public ActionDisplayFolderOrItemProperties(ApplicationFrameActionList theAppActionList) {
        super((ActionList)theAppActionList, ActionKey.ITEM_PROPERTIES, StringResources.PROPERTIES, ImageResources.ACT_ITEM_PROPERTIES);
        this.setToolTipText(StringResources.DESCRIPTION_PROPERTIES);
        this.setAccelerator(KeyStroke.getKeyStroke(10, 8));
    }

    protected void performAction(ActionEvent e) {
        if (this.folder == null) {
            if (this.hasItems()) {
                MessageUtils.openItem(this.getItemList(), this.getItem(), this.getUserGuid(), false);
                FrameOpen tempFrameOpen = GWClient.getOpenFrame(this.getItem());
                tempFrameOpen.showProperties();
            }
        } else {
            JFrame parent = (JFrame)this.getActionList().getMVCView();
            FolderPropertiesDialog folderPropertiesDialog = new FolderPropertiesDialog((Frame)parent, this.getController(), this.folder);
            folderPropertiesDialog.setLocationRelativeTo(parent);
            folderPropertiesDialog.setVisible(true);
        }
    }

    protected void registerListeners() {
        super.registerListeners();
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 240, new ADDRESS_BOOK_SELECT_DIRECTORY_ITEMS_Listener()));
        AppEventListener listener = new ILTREE_FOCUS_GAINED_Listener();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 1980, listener));
        listener = new ITEM_LIST_VIEW_SELECTED_Listener();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 2070, listener));
    }

    protected boolean checkEnableOnSelect() {
        return this.folder != null || this.hasItems() && this.getItem().canDoInfo();
    }

    protected void handle_ADDRESS_BOOK_SELECT_DIRECTORY_ITEMS(AppEvent event) {
        this.setMVCModel((Object)null);
    }

    protected void handle_OPEN_FOLDER(AppEvent theEvent) {
        super.handle_OPEN_FOLDER(theEvent);
        this.folder = (AbstractFolder)theEvent.getData();
    }

    protected void handle_MULTIPLE_ITEMS_SELECTED(AppEvent event) {
        this.setMVCModel((Object)null);
    }

    public JMenuItem getMenuItem() {
        JMenuItem item = OS.createMenuItem(this);
        item.setAccelerator(KeyStroke.getKeyStroke(10, 8));
        return item;
    }

    public JMenuItem getPopupMenuItem() {
        JMenuItem popupMenuItem = super.getPopupMenuItem();
        UIUtils.setMnemonic(popupMenuItem, 6);
        return popupMenuItem;
    }

    public boolean showWithText() {
        return false;
    }

    public void setMVCModel(Object theModel) {
        super.setMVCModel(theModel);
        if (!(theModel instanceof AbstractFolder)) {
            this.folder = null;
        }
    }

    protected void handle_FOLDER_SELECTED(AppEvent event) {
        this.folder = (AbstractFolder)event.getData();
        this.setEnabled(this.checkEnableOnSelect());
    }

    private class ITEM_LIST_VIEW_SELECTED_Listener
    extends AppEventListener {
        private ITEM_LIST_VIEW_SELECTED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            ActionDisplayFolderOrItemProperties.this.folder = null;
        }
    }

    private class ILTREE_FOCUS_GAINED_Listener
    extends AppEventListener {
        private ILTREE_FOCUS_GAINED_Listener() {
        }

        public void handle(AppEvent event) {
            ActionDisplayFolderOrItemProperties.this.folder = ((MainGWFoldersTree)event.getData()).getSelectedFolder();
        }
    }

    private class ADDRESS_BOOK_SELECT_DIRECTORY_ITEMS_Listener
    extends AppEventListener {
        private ADDRESS_BOOK_SELECT_DIRECTORY_ITEMS_Listener() {
        }

        public void handle(AppEvent theEvent) {
            ActionDisplayFolderOrItemProperties.this.handle_ADDRESS_BOOK_SELECT_DIRECTORY_ITEMS(theEvent);
        }
    }
}

