/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrame;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.utils.OS;
import com.appframework.utils.OSXAdapter;
import com.novell.gw.jclient.api.enums.DataStoreAccessRequestType;
import com.novell.gw.jclient.api.enums.ItemType;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.StorageMode;
import com.novell.gw.jclient.application.frames.options.OptionsDialog;
import com.novell.gw.jclient.application.frames.options.OptionsDialogController;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class ActionOptions
extends AppAction {
    private String optionsPage = "General";

    public ActionOptions(ActionList theAppActionList) {
        super(theAppActionList, ActionKey.OPTIONS, StringResources.ACTION_OPTIONS, ImageResources.ACT_OPTIONS);
        this.setToolTipText(StringResources.DESCRIPTION_OPTIONS);
    }

    public String getOptionsPage() {
        return this.optionsPage;
    }

    public void setOptionsPage(String theOptionsPage) {
        this.optionsPage = theOptionsPage;
    }

    protected void performAction(ActionEvent e) {
        MVCController controller;
        MessageUtils.showBusyCursor(true);
        ApplicationFrame parent = null;
        if (this.actionList != null) {
            controller = this.actionList;
            parent = (ApplicationFrame)this.actionList.getOwnerComponent();
        } else {
            parent = GWClient.getActiveFrame() != null ? GWClient.getActiveFrame() : GWClient.getLastActiveMainFrame();
            controller = parent.getController();
        }
        OptionsDialog optionsDialog = new OptionsDialog(parent, controller);
        Command command = new Command(120, this.optionsPage);
        ((OptionsDialogController)optionsDialog.getController()).processCommand(command);
        optionsDialog.setVisible(true);
        this.optionsPage = "General";
        MessageUtils.showBusyCursor(false);
    }

    private boolean checkAccess() {
        return GWCommandManager.getInstance(this.getUserGuid()).getCurrentDataStore().checkAccess(DataStoreAccessRequestType.EDIT_PREFS, ItemType.ANY, 0);
    }

    protected String getUserGuid() {
        if (this.actionList == null) {
            return EngineCommandManager.getUserGuid();
        }
        Component ownerComponent = null;
        ownerComponent = this.getActionList().getOwnerComponent();
        if (ownerComponent instanceof ApplicationFrame) {
            return ((ApplicationFrame)ownerComponent).getUserGuid();
        }
        throw new IllegalStateException("not ApplicationFrame");
    }

    protected void registerListeners() {
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 800, new STORE_MODE_CHANGED_EventListener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 750, new PROXY_DATA_STORE_INSTALLED_EventListener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 740, new ACTION_SWITCH_ONLINE_PERFORMED_EventListener()));
    }

    private class ACTION_SWITCH_ONLINE_PERFORMED_EventListener
    extends AppEventListener {
        private ACTION_SWITCH_ONLINE_PERFORMED_EventListener() {
        }

        public void handle(AppEvent theEvent) {
            ActionOptions.this.setEnabled(true);
            if (OS.isMacOS()) {
                OSXAdapter.enablePrefs(true);
            }
        }
    }

    private class PROXY_DATA_STORE_INSTALLED_EventListener
    extends AppEventListener {
        private PROXY_DATA_STORE_INSTALLED_EventListener() {
        }

        public void handle(AppEvent theEvent) {
            boolean state = ActionOptions.this.checkAccess();
            ActionOptions.this.setEnabled(state);
            if (OS.isMacOS()) {
                OSXAdapter.enablePrefs(state);
            }
        }
    }

    private class STORE_MODE_CHANGED_EventListener
    extends AppEventListener {
        private STORE_MODE_CHANGED_EventListener() {
        }

        public void handle(AppEvent theEvent) {
            StorageMode storeMode = (StorageMode)theEvent.getData();
            boolean state = storeMode.isNormal() && ActionOptions.this.checkAccess();
            ActionOptions.this.setEnabled(state);
            if (OS.isMacOS()) {
                OSXAdapter.enablePrefs(state);
            }
        }
    }
}

