/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrameActionList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.Command;
import com.appframework.mvc.GlobalCommand;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.impl.cache.FoldersCache;
import com.novell.gw.jclient.bl.impl.cache.ItemsCache;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.ItemListsCache;
import com.novell.gw.jclient.bl.om.folders.QueryFolder;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

public class ActionRefresh
extends AppAction {
    public ActionRefresh(ApplicationFrameActionList theAppActionList) {
        super((ActionList)theAppActionList, ActionKey.REFRESH, StringResources.ACTION_REFRESH, ImageResources.ACT_REFRESH);
        this.setToolTipText(StringResources.DESCRIPTION_REFRESH);
        this.setAccelerator(KeyStroke.getKeyStroke(116, 0));
    }

    protected void performAction(ActionEvent e) {
        String userGuid = ControlsUtils.getUserGuid(this.getActionList());
        ItemsCache.clear(userGuid);
        FoldersCache.clear(userGuid);
        ItemListsCache.clear(userGuid);
        MVCController controller = this.getController();
        controller.processCommand(new Command(810));
        AbstractFolder folder = (AbstractFolder)this.getMVCModel();
        if (folder instanceof QueryFolder) {
            this.getActionList().performAction(ActionKey.START_QUERY_FOLDER);
        } else {
            controller.processCommand(new Command(1770));
        }
        controller.processCommand(new GlobalCommand(80));
        GWClient.getGWMainAppFrame().markQuickViewerBtnState();
    }

    protected void registerListeners() {
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 10, new FOLDER_SELECTED_Listener()));
    }

    class FOLDER_SELECTED_Listener
    extends AppEventListener {
        FOLDER_SELECTED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            AbstractFolder folder = (AbstractFolder)theEvent.getData();
            ActionRefresh.this.setMVCModel(folder);
        }
    }
}

