/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.ApplicationFrameActionList;
import com.appframework.components.customizedbutton.listpopuppane.ListPopupPane;
import com.novell.gw.account.Account;
import com.novell.gw.jclient.application.actions.AbstractAccountsAction;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.ActionSelectAccount;
import com.novell.gw.jclient.application.controls.menus.GWMenu;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class ActionSendRetrive
extends AbstractAccountsAction {
    private MenuListener menuListener = new SendRetrieveMenuListener();

    public ActionSendRetrive(ApplicationFrameActionList actionList) {
        super((ActionList)actionList, ActionKey.SEND_RETRIVE, StringResources.SEND_RETRIEVE, ImageResources.ICON_ACT_SEND_RETRIVE);
        this.setToolTipText(StringResources.DESCRIPTION_SEND_RETRIEVE);
    }

    protected void performAction(ActionEvent e) {
        GWCommandManager.getInstance(this.getUserGuid()).syncDataStore();
    }

    public JComponent getToolBarComponent() {
        Account[] accounts;
        ListPopupPane buttons = new ListPopupPane(this);
        buttons.setToolTipText(this.getToolTipText());
        ActionList actionList = this.getActionList();
        buttons.addAction(actionList.getAction(ActionKey.ALL_MARKED_ACCOUNTS));
        buttons.addSeparator();
        for (Account aNew : accounts = EngineCommandManager.getMailAccounts()) {
            buttons.addAction(new ActionSelectAccount(actionList, aNew));
        }
        for (Account account : accounts = EngineCommandManager.getNewsAccounts()) {
            buttons.addAction(new ActionSelectAccount(actionList, account));
        }
        return buttons;
    }

    public boolean showWithText() {
        return true;
    }

    public JMenuItem getMenuItem() {
        GWMenu menu = new GWMenu(this);
        menu.addMenuListener(this.menuListener);
        return menu;
    }

    public class SendRetrieveMenuListener
    implements MenuListener {
        public void menuSelected(MenuEvent e) {
            JMenu menu = (JMenu)e.getSource();
            menu.removeAll();
            JMenuItem menuItem = ActionSendRetrive.this.getActionList().getAction(ActionKey.ALL_MARKED_ACCOUNTS).getMenuItem();
            menu.add(menuItem);
            menu.add(new JSeparator());
            for (Account account : EngineCommandManager.getAccounts()) {
                menuItem = new ActionSelectAccount(ActionSendRetrive.this.getActionList(), account).getMenuItem();
                menu.add(menuItem);
            }
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuCanceled(MenuEvent e) {
        }
    }
}

