/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.components.ButtonList;
import com.appframework.mvc.Command;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.actions.AbstractSwitchViewAction;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;

public class ActionSwitchAttachmentWindow
extends AbstractSwitchViewAction {
    protected ButtonList buttons;

    public ActionSwitchAttachmentWindow(ActionList appActionList) {
        super(appActionList, ActionKey.SWITCH_ATTACHMENT_WINDOW, StringResources.ATTACHMENT_WINDOW);
        this.setIcon(ImageResources.ICON_ATTACHMENT_WINDOW);
        this.setType(AppAction.ActionType.CHECKABLE);
        if (this.getFrame() instanceof GWMainAppFrame) {
            this.setEnabled(this.isQuickViewerVisible());
        } else {
            this.setEnabled(true);
        }
        this.menuItem = OS.createMenuItem(this);
        this.buttons = new ButtonList(false);
        this.setSelected();
        this.buttons.add(this.menuItem);
    }

    protected void setSelected() {
        boolean isSelected = ApplicationOptions.getInstance().getBoolean("ATTACHLIST_VISIBLE", true);
        this.buttons.setSelected(isSelected);
    }

    public JComponent getToolBarComponent() {
        AbstractButton button = (AbstractButton)super.getToolBarComponent();
        this.buttons.add(button);
        return button;
    }

    protected void performAction(ActionEvent e) {
        boolean selected = ((AbstractButton)e.getSource()).isSelected();
        this.performSwitch(selected);
    }

    public void performSwitch(boolean enabled) {
        this.buttons.setSelected(enabled);
        ApplicationOptions.getInstance().put("ATTACHLIST_VISIBLE", enabled);
        this.getActionList().processCommand(new Command(890));
    }

    public boolean showWithText() {
        return false;
    }
}

