/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrame;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.actions.AbstractMainFrameAction;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.frames.compose.FrameCompose;
import com.novell.gw.jclient.application.frames.open.FrameOpen;
import com.novell.gw.jclient.application.options.AppearanceSettings;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class ActionSwitchMainToolBar
extends AbstractMainFrameAction {
    private static Logger logger = Logger.getLogger(ActionSwitchMainToolBar.class);
    protected JMenuItem menuItem;
    private boolean isGroupSelected;
    private String toolBarName;

    public ActionSwitchMainToolBar(ActionList theAppActionList) {
        super(theAppActionList, ActionKey.SWITCH_MAIN_TOOLBAR, StringResources.TOOLBAR);
        this.setType(AppAction.ActionType.CHECKABLE);
        this.menuItem = OS.createMenuItem(this);
    }

    protected void performAction(ActionEvent e) {
        AppearanceSettings settings = GWCommandManager.getInstance(this.getUserGuid()).getAppearanceSettings();
        if (!settings.isLockedMainToolBarVisibility()) {
            boolean isVisible = true;
            ApplicationFrame frame = this.getFrame();
            if (frame instanceof GWMainAppFrame) {
                isVisible = !settings.isMainToolBarVisible();
                settings.setMainToolBarVisible(isVisible);
                ((GWMainAppFrame)this.getFrame()).setMainToolbarVisible(isVisible);
            } else if (frame instanceof FrameCompose || frame instanceof FrameOpen) {
                isVisible = !ApplicationOptions.getInstance().getBoolean(this.toolBarName, true);
                frame.getToolBarPanel().setVisible(isVisible);
            }
            if (this.toolBarName != null) {
                ApplicationOptions.getInstance().put(this.toolBarName, isVisible ? Boolean.TRUE : Boolean.FALSE);
            } else {
                logger.warn((Object)">>---toolbar options won't be saved---<<");
                logger.warn((Object)">>---toolbar name = null---<<");
                logger.debug((Object)">>---NEED TO FIX IT ---<<");
            }
            this.menuItem.setSelected(isVisible);
        }
    }

    public JMenuItem getMenuItem() {
        return this.menuItem;
    }

    public void setToolBarName(String toolBarName) {
        this.toolBarName = toolBarName;
        boolean isSelected = this.getFrame() instanceof GWMainAppFrame ? this.isMainToolBarVisible() : ApplicationOptions.getInstance().getBoolean(this.toolBarName, true);
        this.menuItem.setSelected(isSelected);
    }

    private boolean isMainToolBarVisible() {
        return GWCommandManager.getInstance(this.getUserGuid()).getAppearanceSettings().isMainToolBarVisible();
    }

    protected void registerListeners() {
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 1260, new ACTION_SHOW_HIDE_MAIN_TOOLBAR_Listener()));
    }

    private class ACTION_SHOW_HIDE_MAIN_TOOLBAR_Listener
    extends AppEventListener {
        private ACTION_SHOW_HIDE_MAIN_TOOLBAR_Listener() {
        }

        public void handle(AppEvent event) {
            if (ActionSwitchMainToolBar.this.getFrame() instanceof GWMainAppFrame) {
                ActionSwitchMainToolBar.this.menuItem.setSelected(ActionSwitchMainToolBar.this.isMainToolBarVisible());
            }
        }
    }
}

