/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.contact;

import com.appframework.ActionList;
import com.appframework.ApplicationFrame;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.contact.AbstractContactAction;
import com.novell.gw.jclient.application.controls.addressbook.ABUtils;
import com.novell.gw.jclient.application.controls.addressbook.AbstractAddressSelectorDialog;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.AddressBookListDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import java.awt.event.ActionEvent;
import java.util.List;

public class ActionCopyContacts
extends AbstractContactAction {
    private AbstractAddressBook selectedAddressbook;

    public ActionCopyContacts(ActionList theAppActionList) {
        super(theAppActionList, ActionKey.COPY_CONTACTS, StringResources.ACTION_COPY_TO);
    }

    protected void performAction(ActionEvent e) {
        List<AbstractAddressBook> addressBooks = EngineCommandManager.getEditableAddressBooks();
        addressBooks.remove(this.selectedAddressbook);
        AddressBookListDialog addressBookListDialog = new AddressBookListDialog((ApplicationFrame)this.getController().getActionList().getMVCView(), addressBooks);
        addressBookListDialog.showMe();
        if (addressBookListDialog.isActionCompleteSuccessfully() && this.hasContacts()) {
            AbstractAddressBook selectedAddressBook = addressBookListDialog.getSelectedAddressBook();
            ABUtils.copyContacts(selectedAddressBook, this.getContacts(), this.getActionList().getOwnerComponent());
        }
    }

    protected void registerListeners() {
        super.registerListeners();
        Level level = this.getController().getFrameLevel();
        ABSelectedListener listener = new ABSelectedListener();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 360, listener));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 270, new NoItemSelectedListener()));
    }

    protected boolean checkEnableOnSelect() {
        return this.hasContacts() && this.selectedAddressbook != null;
    }

    public void setMVCModel(Object model) {
        if (model instanceof AbstractAddressBook) {
            this.selectedAddressbook = (AbstractAddressBook)model;
        } else {
            super.setMVCModel(model);
        }
    }

    private class NoItemSelectedListener
    extends AppEventListener {
        private NoItemSelectedListener() {
        }

        public void handle(AppEvent theEvent) {
            if (!(ActionCopyContacts.this.getActionList().getMVCView() instanceof AbstractAddressSelectorDialog) || ActionCopyContacts.this.getActionList().getMVCView() == AbstractAddressSelectorDialog.getLastInstance()) {
                ActionCopyContacts.this.setEnabled(false);
            }
        }
    }

    private class ABSelectedListener
    extends AppEventListener {
        private ABSelectedListener() {
        }

        public void handle(AppEvent theEvent) {
            if (!(ActionCopyContacts.this.getActionList().getMVCView() instanceof AbstractAddressSelectorDialog) || ActionCopyContacts.this.getActionList().getMVCView() == AbstractAddressSelectorDialog.getLastInstance()) {
                ActionCopyContacts.this.setMVCModel(theEvent.getData());
            }
        }
    }
}

