/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.edit.text;

import com.appframework.ActionList;
import com.appframework.components.htmleditor.GWMozillaBrowserCanvas;
import com.appframework.components.htmleditor.HTMLTextPane;
import com.appframework.resources.ImageResources;
import com.appframework.utils.OS;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.edit.text.EditAction;
import com.novell.gw.jclient.application.dialogs.fontchooser.FontChooserDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import org.apache.log4j.Logger;

public class ActionFont
extends EditAction {
    private static Logger logger = Logger.getLogger(ActionFont.class);
    private static final Font DEFAULT_FONT = new Font("Arial", 0, 12);
    private static final String[] HTML_FONT_SIZES = new String[]{"8", "10", "12", "14", "18", "24", "36"};
    private FontChooserDialog fontDialog;
    private boolean inBody;
    private Font lastSelectedFont = null;

    public ActionFont(ActionList theActionList) {
        super(theActionList, ActionKey.FONT, StringResources.FONT_D, ImageResources.ACT_FONT);
        KeyStroke keyStroke = OS.isMacOS() ? KeyStroke.getKeyStroke(120, OS.getMetaKey()) : KeyStroke.getKeyStroke(120, 0);
        this.setAccelerator(keyStroke);
    }

    private void setHTMLTextPaneFont(Font theFont) {
        HTMLTextPane pane = (HTMLTextPane)this.getMVCModel();
        if (pane.getMode() == 1) {
            HTMLDocument doc = (HTMLDocument)pane.getDocument();
            pane.setDocument(new HTMLDocument());
            Element root = doc.getDefaultRootElement();
            this.inBody = false;
            this.setElementFont(doc, root, theFont, 0);
            pane.setDocument(doc);
        } else if (pane.getMode() == 2 || pane.getMode() == 3) {
            pane.setRTFTextFont(theFont);
        }
    }

    private void setBrowserFont(Font choosenFont) {
        GWMozillaBrowserCanvas browser = (GWMozillaBrowserCanvas)this.getMVCModel();
        browser.setBrowserFont(choosenFont);
    }

    private void setElementFont(HTMLDocument document, Element theRoot, Font font, int end) {
        AttributeSet attributes = theRoot.getAttributes();
        HTML.Tag name = (HTML.Tag)attributes.getAttribute(StyleConstants.NameAttribute);
        if (name == HTML.Tag.BODY) {
            this.inBody = !this.inBody;
        } else if (this.inBody && name == HTML.Tag.P || name == HTML.Tag.DIV || name == HTML.Tag.CONTENT || name == HTML.Tag.IMPLIED) {
            boolean empty;
            int startOffset = theRoot.getStartOffset();
            int endOffset = theRoot.getEndOffset();
            int length = endOffset - startOffset;
            boolean bl = empty = theRoot.getName().length() == length;
            if (!empty && endOffset > end) {
                end = endOffset;
                int charEnd = startOffset;
                Element characterElement = null;
                SimpleAttributeSet a1 = null;
                while (charEnd < endOffset) {
                    characterElement = document.getCharacterElement(charEnd);
                    int charStart = characterElement.getStartOffset();
                    charEnd = characterElement.getEndOffset();
                    int charLength = charEnd - charStart;
                    a1 = new SimpleAttributeSet(characterElement.getAttributes());
                    a1.removeAttribute(CSS.Attribute.FONT_SIZE);
                    a1.removeAttribute(CSS.Attribute.FONT_STYLE);
                    a1.removeAttribute(CSS.Attribute.FONT_FAMILY);
                    a1.removeAttribute(CSS.Attribute.FONT_WEIGHT);
                    a1.removeAttribute(HTML.Tag.FONT);
                    a1.addAttribute(StyleConstants.FontFamily, font.getFamily());
                    a1.addAttribute(StyleConstants.FontSize, new Integer(font.getSize()));
                    a1.addAttribute(StyleConstants.Italic, font.isItalic());
                    a1.addAttribute(StyleConstants.Bold, font.isBold());
                    document.setCharacterAttributes(charStart, charLength, a1, true);
                }
            }
        }
        int nCount = theRoot.getElementCount();
        for (int i = 0; i < nCount; ++i) {
            Element element = theRoot.getElement(i);
            this.setElementFont(document, element, font, end);
        }
    }

    public void setMVCModel(Object theModel) {
        super.setMVCModel(theModel);
        if (this.getMVCModel() instanceof HTMLTextPane || theModel instanceof GWMozillaBrowserCanvas) {
            this.lastSelectedFont = null;
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    private Font getFont() {
        HTMLTextPane pane = (HTMLTextPane)this.getMVCModel();
        this.inBody = false;
        if (pane.getDocument() instanceof HTMLDocument) {
            HTMLDocument doc = (HTMLDocument)pane.getDocument();
            Element root = doc.getDefaultRootElement();
            return this.getElementFont(doc, root, 0);
        }
        StyledDocument document = pane.getStyledDocument();
        int caretPosition = pane.getCaretPosition();
        if (caretPosition > 0) {
            Element characterElement = document.getCharacterElement(caretPosition - 1);
            AttributeSet characterAttributes = characterElement.getAttributes();
            return document.getFont(characterAttributes);
        }
        return pane.getFont();
    }

    private Font getElementFont(HTMLDocument document, Element theRoot, int end) {
        AttributeSet attributes = theRoot.getAttributes();
        HTML.Tag name = (HTML.Tag)attributes.getAttribute(StyleConstants.NameAttribute);
        if (name == HTML.Tag.BODY) {
            this.inBody = !this.inBody;
        } else if (this.inBody && name == HTML.Tag.P || name == HTML.Tag.DIV || name == HTML.Tag.CONTENT || name == HTML.Tag.IMPLIED) {
            boolean empty;
            int startOffset = theRoot.getStartOffset();
            int endOffset = theRoot.getEndOffset();
            int length = endOffset - startOffset;
            boolean bl = empty = theRoot.getName().length() == length;
            if (!empty && endOffset > end) {
                end = endOffset;
                Element characterElement = document.getCharacterElement(startOffset);
                AttributeSet characterAttributes = characterElement.getAttributes();
                return document.getFont(characterAttributes);
            }
        }
        int nCount = theRoot.getElementCount();
        for (int i = 0; i < nCount; ++i) {
            Element element = theRoot.getElement(i);
            Font result = this.getElementFont(document, element, end);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected void performAction(ActionEvent e) {
        if (!this.isValid()) {
            return;
        }
        Component textComponent = (Component)this.getMVCModel();
        this.fontDialog = new FontChooserDialog((JFrame)SwingUtilities.getWindowAncestor(textComponent));
        this.fontDialog.setModal(true);
        Component ancestorOfClass = this.getMVCModel() instanceof GWMozillaBrowserCanvas ? textComponent : SwingUtilities.getAncestorOfClass(JScrollPane.class, textComponent);
        this.fontDialog.setLocationRelativeTo(ancestorOfClass);
        this.fontDialog.setFont(this.getOldFont(), HTML_FONT_SIZES);
        this.fontDialog.pack();
        this.fontDialog.setVisible(true);
        if (!this.fontDialog.isOkActionProcessed()) {
            return;
        }
        Font choosenFont = this.fontDialog.getChoosenFont();
        if (choosenFont == null) {
            return;
        }
        this.lastSelectedFont = choosenFont;
        if (this.getMVCModel() instanceof HTMLTextPane) {
            this.setHTMLTextPaneFont(choosenFont, (HTMLTextPane)this.getMVCModel());
        } else if (this.getMVCModel() instanceof GWMozillaBrowserCanvas) {
            this.setBrowserFont(choosenFont);
        }
    }

    private void setHTMLTextPaneFont(Font choosenFont, HTMLTextPane textPane) {
        AttributeSet attributes = this.getFontAttributes(choosenFont);
        if (!Utils.isNullOrEmpty(textPane.getSelectedText())) {
            this.setTextPaneSelectionAttributes(attributes, textPane);
        } else {
            textPane.addInputAttributes(attributes);
        }
    }

    private AttributeSet getFontAttributes(Font choosenFont) {
        SimpleAttributeSet attributes = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attributes, choosenFont.getFamily());
        StyleConstants.setFontSize(attributes, choosenFont.getSize());
        StyleConstants.setBold(attributes, choosenFont.isBold());
        StyleConstants.setItalic(attributes, choosenFont.isItalic());
        return attributes;
    }

    private void setTextPaneSelectionAttributes(AttributeSet attributes, JTextPane textPane) {
        if (textPane.getDocument() instanceof HTMLDocument) {
            HTMLDocument document = (HTMLDocument)textPane.getDocument();
            int selectionLength = textPane.getSelectionEnd() - textPane.getSelectionStart();
            document.setCharacterAttributes(textPane.getSelectionStart(), selectionLength, attributes, false);
        }
    }

    private Font getOldFont() {
        Font result = null;
        if (this.lastSelectedFont != null) {
            result = this.lastSelectedFont;
        } else if (this.getMVCModel() instanceof HTMLTextPane) {
            result = this.getFont();
        }
        if (result == null) {
            result = DEFAULT_FONT;
        }
        return result;
    }

    public boolean showWithText() {
        return false;
    }
}

