/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.edit.text;

import com.appframework.components.htmleditor.HTMLTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import org.apache.log4j.Logger;

public class TextZoomer {
    private static Logger logger = Logger.getLogger(TextZoomer.class);
    private static boolean inBody;
    private static final int MAX_FONT_SIZE = 36;
    private static final int MIN_FONT_SIZE = 8;
    private static final int RTF_ZOOM_STEP = 2;

    public static void zoom(HTMLTextPane pane, boolean in) {
        if (pane.getMode() == 1) {
            HTMLDocument doc = (HTMLDocument)pane.getDocument();
            pane.setDocument(new HTMLDocument());
            Element root = doc.getDefaultRootElement();
            inBody = false;
            TextZoomer.zoomElement(doc, root, in, 0);
            pane.setDocument(doc);
        } else if (pane.getMode() == 2 || pane.getMode() == 3) {
            StyledDocument styledDocument = pane.getStyledDocument();
            pane.setDocument(new DefaultStyledDocument());
            TextZoomer.zoomRTFElement(styledDocument, styledDocument.getDefaultRootElement(), in);
            pane.setDocument(styledDocument);
        }
    }

    private static void zoomElement(HTMLDocument document, Element theRoot, boolean in, int end) {
        AttributeSet attributes = theRoot.getAttributes();
        HTML.Tag name = (HTML.Tag)attributes.getAttribute(StyleConstants.NameAttribute);
        if (name == HTML.Tag.BODY) {
            inBody = !inBody;
        } else if (inBody && name == HTML.Tag.P || name == HTML.Tag.DIV || name == HTML.Tag.CONTENT || name == HTML.Tag.IMPLIED) {
            boolean empty;
            int startOffset = theRoot.getStartOffset();
            int endOffset = theRoot.getEndOffset();
            int length = endOffset - startOffset;
            boolean bl = empty = theRoot.getName().length() == length;
            if (!empty && endOffset > end) {
                end = endOffset;
                int charEnd = startOffset;
                AttributeSet characterAttributes = null;
                Element characterElement = null;
                SimpleAttributeSet a1 = null;
                while (charEnd < endOffset) {
                    characterElement = document.getCharacterElement(charEnd);
                    int charStart = characterElement.getStartOffset();
                    charEnd = characterElement.getEndOffset();
                    int charLength = charEnd - charStart;
                    characterAttributes = characterElement.getAttributes();
                    int orgSize = StyleConstants.getFontSize(characterAttributes);
                    int newSize = TextZoomer.getCSSSize(orgSize, in);
                    if (newSize > 36 || newSize < 8) continue;
                    a1 = new SimpleAttributeSet(characterAttributes);
                    a1.removeAttribute(CSS.Attribute.FONT_SIZE);
                    a1.removeAttribute(HTML.Tag.FONT);
                    a1.addAttribute(StyleConstants.FontSize, new Integer(newSize));
                    document.setCharacterAttributes(charStart, charLength, a1, true);
                }
            }
        }
        int nCount = theRoot.getElementCount();
        for (int i = 0; i < nCount; ++i) {
            Element element = theRoot.getElement(i);
            TextZoomer.zoomElement(document, element, in, end);
        }
    }

    private static int getCSSSize(int size, boolean in) {
        int step = 0;
        step = size <= 14 ? 2 : (size <= 18 ? 4 : (size <= 24 ? 8 : 12));
        return in ? size + step : size - step;
    }

    private static void zoomRTFElement(StyledDocument theDocument, Element theElement, boolean in) {
        int i;
        int nSize = theDocument.getLength();
        for (i = 0; i < nSize; ++i) {
            int oldSize = StyleConstants.getFontSize(theDocument.getCharacterElement(i).getAttributes());
            if ((oldSize - 2 >= 8 || in) && (oldSize + 2 <= 36 || !in)) continue;
            return;
        }
        for (i = 0; i < nSize; ++i) {
            AttributeSet oldAttr = theDocument.getCharacterElement(i).getAttributes();
            int oldSize = StyleConstants.getFontSize(oldAttr);
            int newSize = in ? oldSize + 2 : oldSize - 2;
            SimpleAttributeSet newAttr = new SimpleAttributeSet();
            StyleConstants.setFontSize(newAttr, newSize);
            theDocument.setCharacterAttributes(i, 1, newAttr, false);
        }
    }
}

