/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.filter;

import com.appframework.ActionList;
import com.appframework.ApplicationFrame;
import com.appframework.mvc.Command;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.filter.AbstractActionContextItemFilter;
import com.novell.gw.jclient.application.controls.filter.ContactFilterDialog;
import com.novell.gw.jclient.application.controls.filter.CustomFilter;
import com.novell.gw.jclient.application.controls.filter.FilterDialog;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.event.ActionEvent;

public class ActionContextItemFilter
extends AbstractActionContextItemFilter {
    private AbstractItem item;
    private String column;

    public ActionContextItemFilter(ActionList theAppActionList) {
        super(theAppActionList, ActionKey.CONTEXT_ITEM_FILTER, StringResources.FIND_D, ImageResources.ICON_UNACTIVE_FILTER);
    }

    public void setModel(AbstractItem item, String column, String folderName, boolean isInPanel) {
        this.item = item;
        this.column = column;
        this.folderOrPanelName = folderName;
        this.isInPanel = isInPanel;
    }

    protected void performAction(ActionEvent e) {
        ContactFilterDialog dialog;
        CustomFilter filter = new CustomFilter();
        ApplicationFrame applicationFrame = (ApplicationFrame)this.getActionList().getMVCView();
        if (this.column != null && this.item != null) {
            if (this.column.equals(StringResources.FROM)) {
                filter.setFrom(this.item.getSender().getDisplayText());
            } else if (this.column.equals(StringResources.SUBJECT)) {
                ItemListFilter itemListFilter = new ItemListFilter();
                itemListFilter.setSubject(this.item.getSubject(), true);
                filter.setSubject(itemListFilter.getSubjectText());
            } else if (this.column.equals(StringResources.TO)) {
                filter.setToCC(this.item.getTo());
            } else if (this.column.equals(StringResources.NAME)) {
                if (this.item.isSentItem()) {
                    filter.setToCC(this.item.getTo());
                } else {
                    filter.setFrom(this.item.getSender().getDisplayText());
                }
            }
            dialog = new ContactFilterDialog(applicationFrame, filter);
        } else {
            dialog = new ContactFilterDialog(applicationFrame, filter);
        }
        dialog.setVisible(true);
        if (dialog.isOkActionProcessed()) {
            MessageUtils.showBusyCursor(true);
            Command command = new Command(400, ((FilterDialog)dialog).getFilter());
            applicationFrame.getController().processCommand(command);
            MessageUtils.showBusyCursor(false);
        }
    }
}

