/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.folder;

import com.appframework.AppAction;
import com.appframework.ApplicationFrameActionList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.GlobalCommand;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.impl.cache.FoldersCache;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.ItemListsCache;
import java.awt.event.ActionEvent;

public class ActionSortSubFolders
extends AppAction {
    public ActionSortSubFolders(ApplicationFrameActionList theAppActionList) {
        super(theAppActionList, ActionKey.SORT_SUBFOLDERS, StringResources.SORT_SUBFOLDERS);
    }

    protected void performAction(ActionEvent e) {
        if (this.getMVCModel() != null) {
            FoldersCache.clear();
            ItemListsCache.clear();
            AbstractFolder folder = (AbstractFolder)this.getMVCModel();
            folder.sortSubFolders();
            AbstractFolder selectedFolder = GWClient.getGWMainAppFrame().getFolder();
            if (folder == selectedFolder || folder.getID().equals(selectedFolder.getID())) {
                GlobalCommand cmd = new GlobalCommand(1090, folder);
                cmd.setAttribute("FORCE_REFRESH", Boolean.TRUE);
                this.getController().processCommand(cmd);
            }
        }
    }

    protected void registerListeners() {
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 960, new FOLDER_SELECTED_Listener()));
    }

    protected class FOLDER_SELECTED_Listener
    extends AppEventListener {
        protected FOLDER_SELECTED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            AbstractFolder folder = (AbstractFolder)theEvent.getData();
            ActionSortSubFolders.this.setMVCModel(folder);
            ActionSortSubFolders.this.setEnabled(folder.canSortSubfolders());
        }
    }
}

