/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.item;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.components.ButtonList;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.item.AbstractGWItemAction;
import com.novell.gw.jclient.application.dialogs.alarm.AlarmDialog;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;

public class ActionAlarm
extends AbstractGWItemAction {
    private ButtonList buttons;

    public ActionAlarm(ActionList appActionList) {
        super(appActionList, ActionKey.ALARM, StringResources.ALARM_D, ImageResources.ACT_SETALARM);
        this.setType(AppAction.ActionType.CHECKABLE);
        this.setToolTipText(StringResources.DESCRIPTION_ALARM);
        this.buttons = new ButtonList(false);
    }

    protected boolean checkEnableOnSelect() {
        AbstractItem item;
        if (this.hasItems() && (item = this.getItem()).getType().equals("Appointment")) {
            AppointmentItem appointment = (AppointmentItem)item;
            return appointment.canSetAlarm() || appointment.canClearAlarm();
        }
        return false;
    }

    public void setEnabled(boolean newValue) {
        super.setEnabled(newValue);
        if (this.buttons != null) {
            this.buttons.setEnabled(newValue);
        }
    }

    public boolean showWithText() {
        return false;
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (this.buttons != null) {
            this.buttons.setSelected(selected);
        }
    }

    protected void performAction(ActionEvent e) {
        AlarmDialog alarmDialog = new AlarmDialog((JFrame)this.getActionList().getMVCView(), (AppointmentItem)this.getItem());
        alarmDialog.showMe();
        this.setSelected(alarmDialog.isAlarmSet());
    }

    public JMenuItem getMenuItem() {
        JMenuItem menuItem = OS.createMenuItem(this);
        this.buttons.add(menuItem);
        return menuItem;
    }

    public JComponent getToolBarComponent() {
        AbstractButton button = (AbstractButton)super.getToolBarComponent();
        this.buttons.add(button);
        return button;
    }
}

