/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.item;

import com.appframework.ActionList;
import com.appframework.ApplicationFrame;
import com.appframework.components.customizedbutton.listpopuppane.ListPopupPane;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.item.AbstractGWItemAction;
import com.novell.gw.jclient.application.impl.SelectedItemsInfoImpl;
import com.novell.gw.jclient.application.printing.PrintManagerDialog;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class ActionPrint
extends AbstractGWItemAction {
    private static Logger logger = Logger.getLogger(ActionPrint.class);
    private GWAttachment selectedAttachment;
    private boolean propertiesSelected = false;

    public ActionPrint(ActionList theAppActionList) {
        super(theAppActionList, ActionKey.PRINT, StringResources.ACTION_PRINT_D, ImageResources.ACT_PRINT);
        this.setToolTipText(StringResources.DESCRIPTION_PRINT);
        this.setAccelerator(KeyStroke.getKeyStroke(80, OS.getMetaKey()));
    }

    protected void registerListeners() {
        super.registerListeners();
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 1350, new OPEN_FRAME_SHOW_ITEM_CONTENT_Listener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 1360, new OPEN_FRAME_SHOW_PROPERTIES_Listener()));
    }

    public boolean showWithText() {
        return false;
    }

    protected void performAction(ActionEvent e) {
        MessageUtils.showBusyCursor(true);
        PrintManagerDialog printManagerDialog = new PrintManagerDialog((ApplicationFrame)this.getActionList().getOwnerComponent(), this.getItem(), this.selectedAttachment, this.propertiesSelected);
        UIUtils.centerWindow((Window)printManagerDialog, (ApplicationFrame)this.getActionList().getMVCView());
        printManagerDialog.setVisible(true);
        MessageUtils.showBusyCursor(false);
    }

    protected boolean checkEnableOnSelect() {
        return this.hasItems() && this.getItem().canPrint();
    }

    public JComponent getToolBarComponent() {
        ListPopupPane popupPane = new ListPopupPane(this);
        popupPane.addAction(this.getActionList().getAction(ActionKey.PRINT_CALENDAR), StringResources.CALENDAR);
        popupPane.addSeparator();
        popupPane.addAction(this);
        return popupPane;
    }

    protected void handle_ATTACHMENT_SELECTED(AppEvent theEvent) {
        Object data = theEvent.getData();
        if (data instanceof AbstractItem) {
            AbstractItem item = (AbstractItem)theEvent.getData();
            this.setMVCModel(new SelectedItemsInfoImpl(null, item));
        } else if (data instanceof GWAttachment) {
            this.selectedAttachment = (GWAttachment)data;
        }
    }

    private class OPEN_FRAME_SHOW_PROPERTIES_Listener
    extends AppEventListener {
        private OPEN_FRAME_SHOW_PROPERTIES_Listener() {
        }

        public void handle(AppEvent theEvent) {
            ActionPrint.this.propertiesSelected = true;
        }
    }

    private class OPEN_FRAME_SHOW_ITEM_CONTENT_Listener
    extends AppEventListener {
        private OPEN_FRAME_SHOW_ITEM_CONTENT_Listener() {
        }

        public void handle(AppEvent theEvent) {
            ActionPrint.this.propertiesSelected = false;
        }
    }
}

