/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.item;

import com.appframework.ActionList;
import com.appframework.ApplicationFrameActionList;
import com.appframework.components.customizedbutton.listpopuppane.ListPopupPane;
import com.appframework.event.AppEvent;
import com.appframework.mvc.GlobalCommand;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.item.AbstractGWItemAction;
import com.novell.gw.jclient.application.actions.item.AbstractReplyDialog;
import com.novell.gw.jclient.application.actions.item.ReplyDialog;
import com.novell.gw.jclient.application.actions.item.ReplyPostingDialog;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.itemedit.ComposeMode;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.frames.compose.FrameCompose;
import com.novell.gw.jclient.application.frames.compose.FrameComposeActionList;
import com.novell.gw.jclient.application.frames.compose.FrameComposeDiscussion;
import com.novell.gw.jclient.application.frames.compose.FrameComposeMail;
import com.novell.gw.jclient.application.frames.compose.FrameComposePostedItem;
import com.novell.gw.jclient.application.impl.SelectedItemsInfoImpl;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.NntpSubFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public class ActionReply
extends AbstractGWItemAction {
    private static Logger logger = Logger.getLogger(ActionReply.class);

    public ActionReply(ActionList actionList, ActionKey actionKey, String name) {
        super(actionList, actionKey, name);
    }

    public ActionReply(ApplicationFrameActionList theAppActionList) {
        super((ActionList)theAppActionList, ActionKey.REPLY, StringResources.ACTION_REPLY, ImageResources.ACT_REPLY);
        this.setToolTipText(StringResources.DESCRIPTION_REPLY);
    }

    protected void performAction(ActionEvent e) {
        AbstractItem item = this.getItem();
        AbstractReplyDialog result = null;
        JFrame ownerFrame = (JFrame)this.getActionList().getOwnerComponent();
        Object message = item.getNativeItem();
        result = MessageUtils.isAdvancedReplyDialogNeeded(message) ? new ReplyPostingDialog(ownerFrame, (IMessage)message) : new ReplyDialog(ownerFrame);
        result.showMe();
        if (!result.isActionCompleteSuccessfully()) {
            return;
        }
        this.replyToItem(result.getResult(), result.isMessageIncluded(), result.isAttachmentsIncluded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replyToItem(int style, boolean withMessage, boolean withAttachments) {
        try {
            FrameCompose frameCompose;
            MessageUtils.showBusyCursor(true);
            AbstractItem item = this.getItem();
            Object originalMessage = item.getNativeItem();
            AbstractItem newItem = GWEngineUtils.composeReplyItem(item, style, withMessage, withAttachments, ControlsUtils.getSelectedTextFromItemViewer(this.getActionList()));
            if (style == (style | 0x80) && MessageUtils.isNntpMessageOrHeader(originalMessage)) {
                NntpSubFolder nntpSubFolder = (NntpSubFolder)item.getViewFolder(this.getUserGuid());
                MessageUtils.prepareNewNntpMessage(newItem, nntpSubFolder);
                frameCompose = new FrameComposeDiscussion(newItem, null, ComposeMode.REPLY, this.getUserGuid());
            } else {
                frameCompose = style != (style | 1) && item.isPersonal() ? new FrameComposePostedItem(newItem, false, ComposeMode.REPLY, this.getUserGuid()) : new FrameComposeMail(newItem, true, ComposeMode.REPLY, this.getUserGuid(), item.isPersonal());
            }
            frameCompose.showMe();
            GlobalCommand command = new GlobalCommand(480, frameCompose);
            ((FrameComposeActionList)frameCompose.getController()).processCommand(command);
        }
        catch (GWCommandException e) {
            logger.error((Object)e, (Throwable)e);
            ErrorDialog.processGWException(e, this.getActionList().getOwnerComponent());
        }
        finally {
            MessageUtils.showBusyCursor(false);
        }
    }

    protected void doReply(int style, boolean withMessage, boolean withAttachments) {
        if (this.getItem() != null) {
            if (MessageUtils.isNntpMessageOrHeader(this.getItem().getNativeItem())) {
                this.replyToItem(style | 0x80, withMessage, withAttachments);
            } else {
                this.replyToItem(style, withMessage, withAttachments);
            }
        }
    }

    protected boolean checkEnableOnSelect() {
        return this.hasItems() && this.getItem().canReply();
    }

    public JComponent getToolBarComponent() {
        ListPopupPane buttons = new ListPopupPane(this);
        buttons.addAction(this);
        buttons.addSeparator();
        buttons.addAction(this.getActionList().getAction(ActionKey.REPLY_TO_SENDER_WITH_MESSAGE));
        buttons.addAction(this.getActionList().getAction(ActionKey.REPLY_TO_SENDER));
        buttons.addSeparator();
        buttons.addAction(this.getActionList().getAction(ActionKey.REPLY_TO_ALL_WITH_MESSAGE));
        buttons.addAction(this.getActionList().getAction(ActionKey.REPLY_TO_ALL));
        return buttons;
    }

    protected void handle_ATTACHMENT_SELECTED(AppEvent theEvent) {
        if (theEvent.getData() instanceof AbstractItem) {
            AbstractItem item = (AbstractItem)theEvent.getData();
            this.setMVCModel(new SelectedItemsInfoImpl(null, item));
        }
    }
}

