/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.send;

import com.appframework.Application;
import com.novell.gw.engine.SendCallback;
import com.novell.gw.jclient.api.APIFactory;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.frames.compose.FrameCompose;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.exceptions.GWException;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class SendCallbackImpl
implements SendCallback {
    private static Logger logger = Logger.getLogger(SendCallbackImpl.class);
    private FrameCompose frameCompose;
    private IMessage message;
    private boolean wasCalled = false;

    public SendCallbackImpl(FrameCompose frameCompose, IMessage message) {
        this.frameCompose = frameCompose;
        this.message = message;
    }

    public boolean isWasCalled() {
        return this.wasCalled;
    }

    public void sendFailed(final int errorCode) {
        logger.debug((Object)"SendCallback FAILED");
        this.wasCalled = true;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SendCallbackImpl.this.frameCompose.setVisible(true);
                if (errorCode != 0) {
                    ErrorDialog.processGWException(new GWException(StringResources.SENDING_ERROR + APIFactory.getEngine().getResourceString(errorCode)));
                }
            }
        });
    }

    public void sendSucceeded() {
        logger.debug((Object)"SendCallback SUCCESED");
        this.wasCalled = true;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Application.disposeFrame(SendCallbackImpl.this.frameCompose);
                SendCallbackImpl.this.message.deleteAutoSaveFile();
            }
        });
    }
}

