/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.view;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.components.ButtonList;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.view.AbstractTasklistViewAction;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListView;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

public class ActionHideItemsNotInTasklist
extends AbstractTasklistViewAction {
    private ButtonList buttonList = new ButtonList();

    public ActionHideItemsNotInTasklist(ActionList actionList) {
        super(actionList, ActionKey.HIDE_ITEMS_NOT_IN_TASKLIST, StringResources.HIDE_ITEMS_NOT_IN_TASKLIST, ImageResources.HIDE_ITEMS_NOT_IN_TASKLIST);
        this.setToolTipText(StringResources.HIDE_OR_DISPLAY_ALL_ITEMS_THAT_ARE_NOT_IN_THE_TASKLIST);
        this.setType(AppAction.ActionType.CHECKABLE);
    }

    protected void performAction(ActionEvent e) {
        ItemListView itemListView = (ItemListView)this.getMVCModel();
        IViewDisplaySettings viewDisplaySettings = itemListView.getViewDisplaySettings();
        boolean hideNonChecklist = !viewDisplaySettings.isHideNonChecklist();
        viewDisplaySettings.setHideNonChecklist(hideNonChecklist);
        this.setSelected(hideNonChecklist);
        itemListView.refresh();
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.buttonList.setSelected(selected);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.buttonList.setEnabled(enabled);
    }

    public JMenuItem getMenuItem() {
        JMenuItem menuItem = super.getMenuItem();
        this.buttonList.add(menuItem);
        return menuItem;
    }

    public JComponent getToolBarComponent() {
        JComponent component = super.getToolBarComponent();
        if (component instanceof AbstractButton) {
            this.buttonList.add((AbstractButton)component);
        }
        return component;
    }

    public void setMVCModel(ItemListView model) {
        super.setMVCModel(model);
        this.setSelected(model != null && model.getViewDisplaySettings().isHideNonChecklist());
    }
}

