/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls;

import com.appframework.ActionList;
import com.appframework.Application;
import com.appframework.ApplicationFrame;
import com.appframework.event.AppEvent;
import com.appframework.listener.ListenerManager;
import com.appframework.listener.ListenerManagerOwner;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.DoubleImageIcon;
import com.appframework.utils.MutableImageIcon;
import com.appframework.utils.Utils;
import com.novell.gw.engine.EngineLocale;
import com.novell.gw.jclient.api.enums.AttachmentDownloadState;
import com.novell.gw.jclient.api.enums.FolderCalSubscribe;
import com.novell.gw.jclient.api.enums.FolderType;
import com.novell.gw.jclient.api.enums.RecipientCopyType;
import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.IFolderDisplaySettings;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IPanelDisplaySettings;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.application.GWClient;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.controls.addressbook.SearchTextField;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarController;
import com.novell.gw.jclient.application.controls.panelviews.PanelView;
import com.novell.gw.jclient.application.controls.popedit.StringParser;
import com.novell.gw.jclient.application.controls.skinnable.ComponentProperty;
import com.novell.gw.jclient.application.controls.skinnable.ISkinnable;
import com.novell.gw.jclient.application.controls.skinnable.SkinProperty;
import com.novell.gw.jclient.application.controls.skinnable.SkinnableCheckBox;
import com.novell.gw.jclient.application.controls.skinnable.SkinnableLabel;
import com.novell.gw.jclient.application.controls.skinnable.SkinnablePanel;
import com.novell.gw.jclient.application.controls.skinnable.SkinnableTextField;
import com.novell.gw.jclient.application.controls.toolbars.ApplicationFrameToolBar;
import com.novell.gw.jclient.application.controls.toolbars.AppointmentOperationsToolBar;
import com.novell.gw.jclient.application.controls.toolbars.ItemOperationsToolBar;
import com.novell.gw.jclient.application.controls.toolbars.ReminderNoteOperationsToolBar;
import com.novell.gw.jclient.application.controls.toolbars.SentItemOperationsToolBar;
import com.novell.gw.jclient.application.controls.toolbars.TaskOperationsToolBar;
import com.novell.gw.jclient.application.frames.open.FrameOpen;
import com.novell.gw.jclient.application.frames.search.FrameItemSearch;
import com.novell.gw.jclient.application.interfaces.ISelectedItemsInfo;
import com.novell.gw.jclient.application.notify.NotifyController;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StartupImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.impl.StreamHandler;
import com.novell.gw.jclient.bl.om.PathManager;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import com.novell.gw.jclient.bl.om.directory.GroupWiseAddressBook;
import com.novell.gw.jclient.bl.om.directory.PersonalAddressBook;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.folders.CabinetFolder;
import com.novell.gw.jclient.bl.om.folders.CalendarFolder;
import com.novell.gw.jclient.bl.om.folders.CheckListFolder;
import com.novell.gw.jclient.bl.om.folders.ContactsFolder;
import com.novell.gw.jclient.bl.om.folders.DocumentFolder;
import com.novell.gw.jclient.bl.om.folders.ImapFolder;
import com.novell.gw.jclient.bl.om.folders.JunkMailFolder;
import com.novell.gw.jclient.bl.om.folders.NntpFolder;
import com.novell.gw.jclient.bl.om.folders.NntpSubFolder;
import com.novell.gw.jclient.bl.om.folders.NormalFolder;
import com.novell.gw.jclient.bl.om.folders.QueryFolder;
import com.novell.gw.jclient.bl.om.folders.RSSFolder;
import com.novell.gw.jclient.bl.om.folders.SentItemsFolder;
import com.novell.gw.jclient.bl.om.folders.SharedFolder;
import com.novell.gw.jclient.bl.om.folders.SubCalendarFolder;
import com.novell.gw.jclient.bl.om.folders.TaskListFolder;
import com.novell.gw.jclient.bl.om.folders.TrashFolder;
import com.novell.gw.jclient.bl.om.folders.UniversalFolder;
import com.novell.gw.jclient.bl.om.folders.UnopenedFolder;
import com.novell.gw.jclient.bl.om.folders.UserFolder;
import com.novell.gw.jclient.bl.om.folders.WorkinProgressFolder;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.DocumentItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import com.novell.gw.jclient.bl.om.items.GWSharedFolderNotification;
import com.novell.gw.jclient.bl.om.items.MailItem;
import com.novell.gw.jclient.bl.om.items.PhoneItem;
import com.novell.gw.jclient.bl.om.items.ReminderNote;
import com.novell.gw.jclient.bl.om.items.SharedAddressBookNotificationItem;
import com.novell.gw.jclient.bl.om.items.TableItem;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ControlsUtils {
    private static Logger logger = Logger.getLogger(ControlsUtils.class);
    public static final int STATE_FOLDER = 0;
    public static final int STATE_ITEM = 1;
    public static final int STATE_MULTIPLE_ITEMS = 2;
    public static final int STATE_CONTACTS = 3;
    public static final int STATE_CALENDAR = 4;
    public static final int STATE_SUBCALENDAR = 5;
    private static BitSet dontNeedEncoding = null;
    private static BitSet notURLDivider = null;

    public static ImageIcon getSplashImage() {
        return StartupImageResources.getIcon("GW_Splash", EngineLocale.getCurrent().getLocale());
    }

    public static ImageIcon getAboutImage() {
        return StartupImageResources.getIcon("GW_Splash", EngineLocale.getCurrent().getLocale());
    }

    public static ImageIcon getImageForFolder(AbstractFolder folder, boolean isOpenIcon) {
        ImageIcon imageIcon = null;
        if (folder instanceof UniversalFolder) {
            imageIcon = isOpenIcon ? ImageResources.FLD_MAILBOX_OPEN : ImageResources.FLD_MAILBOX;
        } else if (folder instanceof SubCalendarFolder) {
            imageIcon = folder.getParent() == null ? ((SubCalendarFolder)folder).getColorSquare() : (!folder.getParent().isCalendarFolder() ? ImageResources.FOLDER_SUBCALENDAR : ((SubCalendarFolder)folder).getColorSquare());
        } else if (folder instanceof NormalFolder || folder instanceof SharedFolder) {
            imageIcon = isOpenIcon ? ImageResources.FLD_FOLDER_OPEN : ImageResources.FLD_FOLDER;
        } else if (folder instanceof UserFolder) {
            imageIcon = ImageResources.FLD_FOLDER_HOME;
        } else if (folder instanceof CabinetFolder) {
            imageIcon = isOpenIcon ? ImageResources.FLD_CABINET_OPEN : ImageResources.FLD_CABINET;
        } else if (folder instanceof CalendarFolder) {
            imageIcon = isOpenIcon ? ImageResources.FLD_CALENDAR_OPEN : ImageResources.FLD_CALENDAR;
        } else if (folder instanceof TrashFolder) {
            imageIcon = folder.getDisplayCount() > 0 ? ImageResources.FLD_TRASH_FILLED : ImageResources.FLD_TRASH_EMPTY;
        } else if (folder instanceof QueryFolder) {
            imageIcon = isOpenIcon ? ImageResources.FLD_QUERY_OPEN : ImageResources.FLD_QUERY;
        } else if (folder instanceof UnopenedFolder) {
            imageIcon = ImageResources.FLD_QUERY;
        } else if (folder instanceof TaskListFolder) {
            imageIcon = ImageResources.FLD_QUERY;
        } else if (folder instanceof SentItemsFolder) {
            imageIcon = isOpenIcon ? ImageResources.FLD_SENTITEMS_OPEN : ImageResources.FLD_SENTITEMS;
        } else if (folder instanceof CheckListFolder) {
            imageIcon = ImageResources.FLD_CHEKLIST;
        } else if (folder instanceof DocumentFolder) {
            imageIcon = isOpenIcon ? ImageResources.FLD_DOCUMENTS_OPEN : ImageResources.FLD_DOCUMENTS;
        } else if (folder instanceof JunkMailFolder) {
            imageIcon = isOpenIcon ? ImageResources.FLD_FOLDER_JUNKMAIL_OPEN : ImageResources.FLD_FOLDER_JUNKMAIL;
        } else if (folder instanceof WorkinProgressFolder) {
            imageIcon = isOpenIcon ? ImageResources.FLD_WORKINPROGRESS_OPEN : ImageResources.FLD_WORKINPROGRESS;
        } else if (folder instanceof ContactsFolder) {
            imageIcon = isOpenIcon ? ImageResources.FLD_CONTACTS_OPEN : ImageResources.FLD_CONTACTS;
        } else if (folder instanceof NntpFolder) {
            imageIcon = isOpenIcon ? ImageResources.FLD_NNTP_SERVER_OPEN : ImageResources.FLD_NNTP_SERVER;
        } else if (folder instanceof ImapFolder) {
            imageIcon = isOpenIcon ? ImageResources.FLD_IMAP_OPEN : ImageResources.FLD_IMAP;
        } else if (folder instanceof NntpSubFolder) {
            imageIcon = isOpenIcon ? ImageResources.FLD_NNTP_NEWSGROUPS_OPEN : ImageResources.FLD_NNTP_NEWSGROUPS_OPEN;
        } else if (folder instanceof RSSFolder) {
            imageIcon = ImageResources.FLD_RSS;
        }
        if (imageIcon == null) {
            imageIcon = ImageResources.FLD_FOLDER;
        }
        if (folder != null && folder.getNativeFolder() != null) {
            IFolder nativeFolder = folder.getNativeFolder();
            if (nativeFolder.isCalendarSubscribe()) {
                FolderCalSubscribe subscribeState = nativeFolder.getCalendarSubscribeState();
                if (subscribeState == FolderCalSubscribe.COMPLETE) {
                    return new DoubleImageIcon(imageIcon, ImageResources.FOLDER_CALENDAR_SUBSCRIBE);
                }
                if (subscribeState == FolderCalSubscribe.DORMANT) {
                    return new DoubleImageIcon(imageIcon, ImageResources.FOLDER_CALENDAR_SUBSCRIBE_UNSELECTED);
                }
                if (subscribeState == FolderCalSubscribe.ERROR) {
                    return new DoubleImageIcon(imageIcon, ImageResources.FOLDER_CALENDAR_SUBSCRIBE_ERROR);
                }
                if (subscribeState == FolderCalSubscribe.INPROGRESS) {
                    return new DoubleImageIcon(imageIcon, ImageResources.FOLDER_CALENDAR_SUBSCRIBE);
                }
            } else {
                if (nativeFolder.isPublishedCalendar()) {
                    if (nativeFolder.isSharedFolder()) {
                        return new DoubleImageIcon(imageIcon, ImageResources.FOLDER_CALENDAR_USER_PUBLISHED);
                    }
                    return new DoubleImageIcon(imageIcon, ImageResources.FOLDER_CALENDAR_PUBLISHED);
                }
                if (nativeFolder.isSharedFolder()) {
                    return new DoubleImageIcon(imageIcon, ImageResources.FOLDER_SHARED_TO_OVERLAY);
                }
                if (nativeFolder.isSharedFolderReference()) {
                    return new DoubleImageIcon(imageIcon, ImageResources.FOLDER_SHARED_FROM_OVERLAY);
                }
            }
        }
        return imageIcon;
    }

    public static ImageIcon getImageForFolder(AbstractFolder theFolder) {
        return ControlsUtils.getImageForFolder(theFolder, false);
    }

    public static ImageIcon getImageForTableItem(TableItem theTableItem) {
        if (theTableItem instanceof AbstractItem) {
            return ControlsUtils.getImageForGWItem((AbstractItem)theTableItem);
        }
        if (theTableItem instanceof AbstractFolder) {
            return ControlsUtils.getImageForFolder((AbstractFolder)theTableItem);
        }
        return ImageResources.UNKNOWN_DOCUMENT_SMALL;
    }

    public static ImageIcon getAttachmentIconForGWItem(AbstractItem theGWItem) {
        return ControlsUtils.getAttachmentIconForGWItem(theGWItem, false);
    }

    public static ImageIcon getAttachmentIconForGWItem(AbstractItem theItem, boolean isLarge) {
        boolean hasAtt = theItem.getNativeItem().hasPaperclipAttachments();
        if (theItem instanceof MailItem) {
            return isLarge ? (hasAtt ? ImageResources.ICON_MAIL_WITH_ATT : ImageResources.ITM_MAIL) : (hasAtt ? ImageResources.ICON_MAIL_WITH_ATT_SMALL : ImageResources.ITM_MAIL_SMALL);
        }
        if (theItem instanceof AppointmentItem) {
            return isLarge ? (hasAtt ? ImageResources.ICON_APPOINTMENT_WITH_ATT : ImageResources.ITM_APPOINTMENT) : (hasAtt ? ImageResources.ICON_APPOINTMENT_WITH_ATT_SMALL : ImageResources.ITM_APPOINTMENT_SMALL);
        }
        if (theItem instanceof TaskItem) {
            return isLarge ? (hasAtt ? ImageResources.ICON_TASK_WITH_ATT : ImageResources.ITM_TASK) : (hasAtt ? ImageResources.ICON_TASK_WITH_ATT_SMALL : ImageResources.ITM_TASK_SMALL);
        }
        if (theItem instanceof PhoneItem) {
            return isLarge ? (hasAtt ? ImageResources.ICON_PHONE_WITH_ATT : ImageResources.ITM_PHONE) : (hasAtt ? ImageResources.ICON_PHONE_WITH_ATT_SMALL : ImageResources.ITM_PHONE_SMALL);
        }
        if (theItem instanceof ReminderNote) {
            return isLarge ? (hasAtt ? ImageResources.ICON_REMINDER_WITH_ATT : ImageResources.ITM_REMINDER_NOTE) : (hasAtt ? ImageResources.ICON_REMINDER_WITH_ATT_SMALL : ImageResources.ITM_REMINDER_NOTE_SMALL);
        }
        return ImageResources.ITM_MAIL;
    }

    public static ImageIcon getIconForAddressBook(AbstractAddressBook theAddressBook) {
        if (theAddressBook instanceof GroupWiseAddressBook) {
            return ImageResources.ICON_SYSTEM_ADDRESS_BOOK;
        }
        if (theAddressBook instanceof PersonalAddressBook) {
            ImageIcon icon = ImageResources.ICON_PERSONAL_ADDRESS_BOOK;
            if (theAddressBook.getNativeAddressBook().isSharedByMe()) {
                return new DoubleImageIcon(icon, ImageResources.FOLDER_SHARED_TO_OVERLAY);
            }
            if (theAddressBook.getNativeAddressBook().isSharedToMe()) {
                return new DoubleImageIcon(icon, ImageResources.FOLDER_SHARED_FROM_OVERLAY);
            }
            return icon;
        }
        return null;
    }

    public static ImageIcon getImageForGWItem(AbstractItem theGWItem) {
        ImageIcon result = ImageResources.ITM_MAIL_READ;
        Object message = theGWItem.getNativeItem();
        result = message.isRSSMessage() ? ImageResources.FLD_RSS : (message.isNNTPHeader() ? ImageResources.ITM_NNTP_HEADER : (message.isNNTPMessage() ? ImageResources.ITM_NNTP_MESSAGE : (theGWItem instanceof GWSharedFolderNotification ? ImageResources.ICON_ITM_SHARED_FOLDER : (theGWItem instanceof SharedAddressBookNotificationItem ? ImageResources.ICON_SHARED_TO_ME_ADDRESS_BOOK : (theGWItem.isReplyRequested() ? (theGWItem.getPriority() == 4 ? ImageResources.ITM_REPLY_REQUESTED_HIGHT : (theGWItem.getPriority() == 1 ? ImageResources.ITM_REPLY_REQUESTED_LOW : ImageResources.ITM_REPLY_REQUESTED)) : (theGWItem instanceof MailItem ? (theGWItem.isStatusRead() && !theGWItem.isSentItem() || theGWItem.isSentItemRead() ? (theGWItem.getPriority() == 4 ? ImageResources.ITM_MAIL_READ_HIGH : (theGWItem.getPriority() == 1 ? ImageResources.ITM_MAIL_READ_LOW : ImageResources.ITM_MAIL_READ)) : (theGWItem.getPriority() == 4 ? ImageResources.ITM_MAIL_UNREAD_HIGH : (theGWItem.getPriority() == 1 ? ImageResources.ITM_MAIL_UNREAD_LOW : ImageResources.ITM_MAIL_UNREAD))) : (theGWItem instanceof TaskItem ? (theGWItem.isStatusRead() && !theGWItem.isSentItem() || theGWItem.isSentItemRead() ? (theGWItem.getPriority() == 4 ? ImageResources.ITM_TASK_READ_HIGH : (theGWItem.getPriority() == 1 ? ImageResources.ITM_TASK_READ_LOW : ImageResources.ITM_TASK_READ)) : (theGWItem.getPriority() == 4 ? ImageResources.ITM_TASK_UNREAD_HIGH : (theGWItem.getPriority() == 1 ? ImageResources.ITM_TASK_UNREAD_LOW : ImageResources.ITM_TASK_UNREAD))) : (theGWItem instanceof ReminderNote ? (theGWItem.isStatusRead() && !theGWItem.isSentItem() || theGWItem.isSentItemRead() ? (theGWItem.getPriority() == 4 ? ImageResources.ITM_NOTE_READ_HIGH : (theGWItem.getPriority() == 1 ? ImageResources.ITM_NOTE_READ_LOW : ImageResources.ITM_NOTE_READ)) : (theGWItem.getPriority() == 4 ? ImageResources.ITM_NOTE_UNREAD_HIGH : (theGWItem.getPriority() == 1 ? ImageResources.ITM_NOTE_UNREAD_LOW : ImageResources.ITM_NOTE_UNREAD))) : (theGWItem instanceof AppointmentItem ? (theGWItem.isStatusRead() && !theGWItem.isSentItem() || theGWItem.isSentItemRead() ? (theGWItem.getPriority() == 4 ? ImageResources.ITM_APPOINTMENT_READ_HIGH : (theGWItem.getPriority() == 1 ? ImageResources.ITM_APPOINTMENT_READ_LOW : ImageResources.ITM_APPOINTMENT_READ)) : (theGWItem.getPriority() == 4 ? ImageResources.ITM_APPOINTMENT_UNREAD_HIGH : (theGWItem.getPriority() == 1 ? ImageResources.ITM_APPOINTMENT_UNREAD_LOW : ImageResources.ITM_APPOINTMENT_UNREAD))) : (theGWItem instanceof PhoneItem ? (theGWItem.isStatusRead() && !theGWItem.isSentItem() || theGWItem.isSentItemRead() ? (theGWItem.getPriority() == 4 ? ImageResources.ITM_PHONE_READ_HIGH : (theGWItem.getPriority() == 1 ? ImageResources.ITM_PHONE_READ_LOW : ImageResources.ITM_PHONE_READ)) : (theGWItem.getPriority() == 4 ? ImageResources.ITM_PHONE_UNREAD_HIGH : (theGWItem.getPriority() == 1 ? ImageResources.ITM_PHONE_UNREAD_LOW : ImageResources.ITM_PHONE_UNREAD))) : (theGWItem instanceof DocumentItem ? (theGWItem.isStatusRead() && !theGWItem.isSentItem() || theGWItem.isSentItemRead() ? ImageResources.ITM_DOCUMENT_READ : ImageResources.ITM_DOCUMENT_UNREAD) : ImageResources.ITM_MAIL_READ)))))))))));
        return new MutableImageIcon(result, true, theGWItem.getPriority());
    }

    public static boolean isImage(String theFileExtention) {
        return "gif".equalsIgnoreCase(theFileExtention) || "jpg".equalsIgnoreCase(theFileExtention) || "jpeg".equalsIgnoreCase(theFileExtention) || "png".equalsIgnoreCase(theFileExtention) || "tif".equalsIgnoreCase(theFileExtention) || "tiff".equalsIgnoreCase(theFileExtention) || "bmp".equalsIgnoreCase(theFileExtention);
    }

    public static boolean isPDF(String theFileExtention) {
        return "pdf".equalsIgnoreCase(theFileExtention);
    }

    public static Icon getItemIcon(AbstractItem theItem) {
        if (theItem.getNativeItem().hasPaperclipAttachments()) {
            return ImageResources.ITEM_ENCLOSURE_DRAFT;
        }
        if (theItem instanceof MailItem) {
            return ImageResources.ITM_MAIL;
        }
        if (theItem instanceof AppointmentItem) {
            return ImageResources.ITM_APPOINTMENT;
        }
        if (theItem instanceof TaskItem) {
            return ImageResources.ITM_TASK;
        }
        if (theItem instanceof PhoneItem) {
            return ImageResources.ITM_PHONE;
        }
        if (theItem instanceof ReminderNote) {
            return ImageResources.ITM_REMINDER_NOTE;
        }
        return ImageResources.ITM_MAIL;
    }

    public static ImageIcon getBigIconForAttachment(String fileName, AttachmentDownloadState theDownloadState) {
        if (theDownloadState == AttachmentDownloadState.NOT_DOWNLOADED) {
            return ImageResources.ATTACHMENT_NOT_DOWNLOADED;
        }
        if (theDownloadState == AttachmentDownloadState.QUEUED_FOR_DOWNLOAD) {
            return ImageResources.ATTACHMENT_QUEUED_FOR_DOWNLOAD;
        }
        String str = Utils.getExtention(fileName);
        if ("pdf".equalsIgnoreCase(str)) {
            return ImageResources.PDF_DOCUMENT;
        }
        if ("doc".equalsIgnoreCase(str)) {
            return ImageResources.MSWORD_DOCUMENT;
        }
        if ("rtf".equalsIgnoreCase(str)) {
            return ImageResources.MSWORD_DOCUMENT;
        }
        if ("xls".equalsIgnoreCase(str)) {
            return ImageResources.MSEXCEL_DOCUMENT;
        }
        if ("htm".equalsIgnoreCase(str)) {
            return ImageResources.HTML_DOCUMENT;
        }
        if ("html".equalsIgnoreCase(str)) {
            return ImageResources.HTML_DOCUMENT;
        }
        if ("vcf".equalsIgnoreCase(str)) {
            return ImageResources.VCF_DOCUMENT;
        }
        if ("ppt".equalsIgnoreCase(str)) {
            return ImageResources.PPT_DOCUMENT;
        }
        if ("sxw".equalsIgnoreCase(str)) {
            return ImageResources.SXW_DOCUMENT;
        }
        if ("stw".equalsIgnoreCase(str)) {
            return ImageResources.STW_DOCUMENT;
        }
        if ("sxc".equalsIgnoreCase(str)) {
            return ImageResources.SXC_DOCUMENT;
        }
        if ("stc".equalsIgnoreCase(str)) {
            return ImageResources.STC_DOCUMENT;
        }
        if ("sxi".equalsIgnoreCase(str)) {
            return ImageResources.SXI_DOCUMENT;
        }
        if ("sti".equalsIgnoreCase(str)) {
            return ImageResources.STI_DOCUMENT;
        }
        if ("sxd".equalsIgnoreCase(str)) {
            return ImageResources.SXD_DOCUMENT;
        }
        if ("std".equalsIgnoreCase(str)) {
            return ImageResources.STD_DOCUMENT;
        }
        if ("sxg".equalsIgnoreCase(str)) {
            return ImageResources.SXG_DOCUMENT;
        }
        if ("sxm".equalsIgnoreCase(str)) {
            return ImageResources.SXM_DOCUMENT;
        }
        if (ControlsUtils.isImage(str)) {
            return ImageResources.IMAGE_DOCUMENT_LOCAL;
        }
        if ("odt".equalsIgnoreCase(str)) {
            return ImageResources.ODT_DOCUMENT;
        }
        if ("odf".equalsIgnoreCase(str)) {
            return ImageResources.ODF_DOCUMENT;
        }
        if ("odg".equalsIgnoreCase(str)) {
            return ImageResources.ODG_DOCUMENT;
        }
        if ("odm".equalsIgnoreCase(str)) {
            return ImageResources.ODM_DOCUMENT;
        }
        if ("odp".equalsIgnoreCase(str)) {
            return ImageResources.ODP_DOCUMENT;
        }
        if ("ods".equalsIgnoreCase(str)) {
            return ImageResources.ODS_DOCUMENT;
        }
        if ("ott".equalsIgnoreCase(str)) {
            return ImageResources.OTT_DOCUMENT;
        }
        if ("otg".equalsIgnoreCase(str)) {
            return ImageResources.OTG_DOCUMENT;
        }
        if ("otp".equalsIgnoreCase(str)) {
            return ImageResources.OTP_DOCUMENT;
        }
        if ("ots".equalsIgnoreCase(str)) {
            return ImageResources.OTS_DOCUMENT;
        }
        if (ControlsUtils.isText(str)) {
            return ImageResources.UNKNOWN_DOCUMENT;
        }
        return ImageResources.BINARY_FILE;
    }

    public static ImageIcon getSmallIconForAttachment(String fileName, AttachmentDownloadState downloadState) {
        if (downloadState == AttachmentDownloadState.NOT_DOWNLOADED) {
            return ImageResources.ATTACHMENT_NOT_DOWNLOADED_SMALL;
        }
        if (downloadState == AttachmentDownloadState.QUEUED_FOR_DOWNLOAD) {
            return ImageResources.ATTACHMENT_QUEUED_FOR_DOWNLOAD_SMALL;
        }
        String str = Utils.getExtention(fileName);
        if ("pdf".equalsIgnoreCase(str)) {
            return ImageResources.PDF_DOCUMENT_SMALL;
        }
        if ("doc".equalsIgnoreCase(str)) {
            return ImageResources.MSWORD_DOCUMENT_SMALL;
        }
        if ("rtf".equalsIgnoreCase(str)) {
            return ImageResources.MSWORD_DOCUMENT_SMALL;
        }
        if ("xls".equalsIgnoreCase(str)) {
            return ImageResources.MSEXCEL_DOCUMENT_SMALL;
        }
        if ("htm".equalsIgnoreCase(str)) {
            return ImageResources.HTML_DOCUMENT_SMALL;
        }
        if ("html".equalsIgnoreCase(str)) {
            return ImageResources.HTML_DOCUMENT_SMALL;
        }
        if (ControlsUtils.isImage(str)) {
            return ImageResources.IMAGE_DOCUMENT_LOCAL_SMALL;
        }
        if ("vcf".equalsIgnoreCase(str)) {
            return ImageResources.VCF_DOCUMENT_SMALL;
        }
        if ("ppt".equalsIgnoreCase(str)) {
            return ImageResources.PPT_DOCUMENT_SMALL;
        }
        if ("sxw".equalsIgnoreCase(str)) {
            return ImageResources.SXW_DOCUMENT_SMALL;
        }
        if ("stw".equalsIgnoreCase(str)) {
            return ImageResources.STW_DOCUMENT_SMALL;
        }
        if ("sxc".equalsIgnoreCase(str)) {
            return ImageResources.SXC_DOCUMENT_SMALL;
        }
        if ("stc".equalsIgnoreCase(str)) {
            return ImageResources.STC_DOCUMENT_SMALL;
        }
        if ("sxi".equalsIgnoreCase(str)) {
            return ImageResources.SXI_DOCUMENT_SMALL;
        }
        if ("sti".equalsIgnoreCase(str)) {
            return ImageResources.STI_DOCUMENT_SMALL;
        }
        if ("sxd".equalsIgnoreCase(str)) {
            return ImageResources.SXD_DOCUMENT_SMALL;
        }
        if ("std".equalsIgnoreCase(str)) {
            return ImageResources.STD_DOCUMENT_SMALL;
        }
        if ("sxg".equalsIgnoreCase(str)) {
            return ImageResources.SXG_DOCUMENT_SMALL;
        }
        if ("sxm".equalsIgnoreCase(str)) {
            return ImageResources.SXM_DOCUMENT_SMALL;
        }
        if ("odt".equalsIgnoreCase(str)) {
            return ImageResources.ODT_DOCUMENT_SMALL;
        }
        if ("odf".equalsIgnoreCase(str)) {
            return ImageResources.ODF_DOCUMENT_SMALL;
        }
        if ("odg".equalsIgnoreCase(str)) {
            return ImageResources.ODG_DOCUMENT_SMALL;
        }
        if ("odm".equalsIgnoreCase(str)) {
            return ImageResources.ODM_DOCUMENT_SMALL;
        }
        if ("odp".equalsIgnoreCase(str)) {
            return ImageResources.ODP_DOCUMENT_SMALL;
        }
        if ("ods".equalsIgnoreCase(str)) {
            return ImageResources.ODS_DOCUMENT_SMALL;
        }
        if ("ott".equalsIgnoreCase(str)) {
            return ImageResources.OTT_DOCUMENT_SMALL;
        }
        if ("otg".equalsIgnoreCase(str)) {
            return ImageResources.OTG_DOCUMENT_SMALL;
        }
        if ("otp".equalsIgnoreCase(str)) {
            return ImageResources.OTP_DOCUMENT_SMALL;
        }
        if ("ots".equalsIgnoreCase(str)) {
            return ImageResources.OTS_DOCUMENT_SMALL;
        }
        if (ControlsUtils.isText(str)) {
            return ImageResources.UNKNOWN_DOCUMENT_SMALL;
        }
        return ImageResources.BINARY_FILE_SMALL;
    }

    public static Window getWindowForComponent(Component parentComponent) {
        if (parentComponent == null) {
            return null;
        }
        if (parentComponent instanceof Window) {
            return (Window)parentComponent;
        }
        return ControlsUtils.getWindowForComponent(parentComponent.getParent());
    }

    public static Frame getFrameForComponent(Component parentComponent) {
        if (parentComponent == null) {
            return null;
        }
        if (parentComponent instanceof Frame) {
            return (Frame)parentComponent;
        }
        return ControlsUtils.getFrameForComponent(parentComponent.getParent());
    }

    private static File createFolder(String thePath) {
        File file = new File(thePath);
        file.mkdirs();
        if (!file.exists()) {
            throw new IllegalStateException("Can not create file [" + thePath + "]");
        }
        return file;
    }

    private static File getAttachmentLocalDir(GWAttachment theAttachment) {
        StringBuffer path = new StringBuffer(PathManager.getTempFolderPath());
        path.append(File.separator);
        path.append(theAttachment.getGwItem().getID());
        path.append(File.separator);
        path.append(theAttachment.getID());
        path.append(File.separator);
        return ControlsUtils.createFolder(path.toString());
    }

    public static File getAttachmentFilePath(GWAttachment theAttachment) {
        File dir = ControlsUtils.getAttachmentLocalDir(theAttachment);
        String filePath = dir.getAbsolutePath() + System.getProperty("file.separator") + theAttachment.getFileName();
        return new File(filePath);
    }

    public static File getDNDAttachmentsLocalDir(GWAttachment theAttachment) {
        StringBuffer path = new StringBuffer(PathManager.getTempFolderPath());
        path.append(File.separator);
        path.append(theAttachment.getGwItem().getID());
        path.append("_dnd");
        path.append(File.separator);
        return ControlsUtils.createFolder(path.toString());
    }

    public static String getDraftsAttachmentsLocalDir(GWAttachment theDraftAttachment) {
        StringBuffer path = new StringBuffer(PathManager.getTempFolderPath());
        path.append(File.separator);
        path.append(theDraftAttachment.getGwItem().getID());
        path.append("_drafts");
        path.append(File.separator);
        return path.toString();
    }

    public static boolean isAttachmentIsLocalyStored(GWAttachment theAttachment) {
        String ext = Utils.getExtention(theAttachment.getFileName());
        if (ControlsUtils.isImage(ext)) {
            String dirPath = ControlsUtils.getAttachmentLocalDir(theAttachment).getPath() + File.separator;
            String filePath = dirPath + theAttachment.getFileName();
            File tmpFile = new File(filePath);
            return ControlsUtils.compare(tmpFile, theAttachment);
        }
        String dirPath = ControlsUtils.getAttachmentLocalDir(theAttachment).getPath() + System.getProperty("file.separator");
        String filePath = dirPath + Utils.normalizePreviewFileName(theAttachment.getFileName());
        File tmpFile1 = new File(filePath);
        filePath = dirPath + theAttachment.getFileName();
        File tmpFile = new File(filePath);
        return ControlsUtils.compare(tmpFile1, theAttachment) || ControlsUtils.compare(tmpFile, theAttachment);
    }

    private static boolean compare(File theFile, GWAttachment theAttachment) {
        return theFile.length() >= theAttachment.getSize();
    }

    public static File getItemLocalDir(String itemID) {
        StringBuffer path = new StringBuffer(PathManager.getTempFolderPath());
        path.append(File.separator);
        path.append(itemID);
        path.append(File.separator);
        File dir = new File(path.toString());
        if (!dir.isDirectory()) {
            dir.mkdir();
        }
        return dir;
    }

    public static String getPage(String theFilePath) {
        return new String(ControlsUtils.getByteSequenceFromPage(theFilePath));
    }

    public static byte[] getByteSequenceFromPage(String theFilePath) {
        byte[] result = "<html><body><h1><b><c>ERROR WHILE LOADING THIS FILE</c></b></h1></body></html>".getBytes();
        try {
            FileInputStream in = new FileInputStream(theFilePath);
            result = StreamHandler.getInstance().getStreamData(in);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e);
            return result;
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        return result;
    }

    public static boolean isComponentTextVisible(JTextField textField) {
        int textWidth = SwingUtilities.computeStringWidth(textField.getFontMetrics(textField.getFont()), textField.getText());
        if (textField.getWidth() == 0) {
            return textField.getText().length() == 0;
        }
        return textField.getWidth() >= textWidth;
    }

    public static String getItemTypeName(AbstractItem theItem) {
        if (ReminderNote.class.isInstance(theItem)) {
            return StringResources.REMINDER_NOTE;
        }
        if (TaskItem.class.isInstance(theItem)) {
            return StringResources.TASK;
        }
        if (AppointmentItem.class.isInstance(theItem)) {
            return StringResources.APPOINTMENT;
        }
        if (PhoneItem.class.isInstance(theItem)) {
            return StringResources.PHONE;
        }
        if (MailItem.class.isInstance(theItem) || theItem instanceof GWSharedFolderNotification || theItem instanceof SharedAddressBookNotificationItem) {
            return StringResources.MAIL;
        }
        if (DocumentItem.class.isInstance(theItem)) {
            return StringResources.DOCUMENT;
        }
        return StringResources.MAIL;
    }

    public static boolean isHTML(String theExt) {
        return "html".equalsIgnoreCase(theExt) || "htm".equalsIgnoreCase(theExt);
    }

    public static boolean isComponentInContainer(Container theContainer, Component theSearchedComponent) {
        if (theContainer == theSearchedComponent) {
            return true;
        }
        for (Component component : theContainer.getComponents()) {
            if (component == theSearchedComponent) {
                return true;
            }
            if (!(component instanceof Container) || !ControlsUtils.isComponentInContainer((Container)component, theSearchedComponent)) continue;
            return true;
        }
        return false;
    }

    public static List<IRecipient> convertToRecipientsList(String theRecipients, RecipientCopyType copyType) {
        List tokens = StringParser.getTokens(theRecipients, SearchTextField.DELIMETERS);
        int nSize = tokens.size();
        ArrayList<IRecipient> result = new ArrayList<IRecipient>(nSize);
        for (int i = 0; i < nSize; ++i) {
            String token = (String)tokens.get(i);
            IRecipient recipient = APIAbWrapperManager.createRecipient(APIAbWrapperManager.createAddress(token, token), copyType);
            result.add(recipient);
        }
        return result;
    }

    public static String recipientsToString(List<IRecipient> theRecipients) {
        int nSize = theRecipients.size();
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < nSize; ++i) {
            IRecipient recipient = theRecipients.get(i);
            result.append(ControlsUtils.recipientToString(recipient));
            result.append("; ");
        }
        int length = result.length();
        if (length >= 2) {
            result.delete(length - 2, length);
        }
        return result.toString();
    }

    public static String recipientToString(IRecipient theRecipient) {
        StringBuffer result = new StringBuffer();
        String displayName = theRecipient.getAddressable().getDisplayName();
        result.append(displayName);
        return result.toString();
    }

    public static boolean isText(String theExt) {
        return "txt".equalsIgnoreCase(theExt) || "log".equalsIgnoreCase(theExt) || "ini".equalsIgnoreCase(theExt) || "java".equalsIgnoreCase(theExt) || "sh".equalsIgnoreCase(theExt) || "bat".equalsIgnoreCase(theExt) || "xml".equalsIgnoreCase(theExt) || "nfo".equalsIgnoreCase(theExt) || "cpp".equalsIgnoreCase(theExt) || "c".equalsIgnoreCase(theExt) || "h".equalsIgnoreCase(theExt) || "822".equalsIgnoreCase(theExt);
    }

    public static boolean isRTF(String theExt) {
        return "rtf".equalsIgnoreCase(theExt);
    }

    public static BitSet getDontNeedEncoding() {
        if (dontNeedEncoding == null) {
            int i;
            dontNeedEncoding = new BitSet(257);
            for (i = 97; i <= 122; ++i) {
                dontNeedEncoding.set(i);
            }
            for (i = 65; i <= 90; ++i) {
                dontNeedEncoding.set(i);
            }
            for (i = 48; i <= 57; ++i) {
                dontNeedEncoding.set(i);
            }
            dontNeedEncoding.set(45);
            dontNeedEncoding.set(95);
            dontNeedEncoding.set(46);
            dontNeedEncoding.set(47);
            dontNeedEncoding.set(58);
            dontNeedEncoding.set(64);
        }
        return dontNeedEncoding;
    }

    public static BitSet getNotURLDivider() {
        if (notURLDivider == null) {
            int i;
            notURLDivider = new BitSet(257);
            for (i = 97; i <= 122; ++i) {
                notURLDivider.set(i);
            }
            for (i = 65; i <= 90; ++i) {
                notURLDivider.set(i);
            }
            for (i = 48; i <= 57; ++i) {
                notURLDivider.set(i);
            }
            notURLDivider.set(37);
            notURLDivider.set(47);
            notURLDivider.set(58);
            notURLDivider.set(63);
            notURLDivider.set(35);
            notURLDivider.set(91);
            notURLDivider.set(93);
            notURLDivider.set(64);
            notURLDivider.set(33);
            notURLDivider.set(36);
            notURLDivider.set(38);
            notURLDivider.set(39);
            notURLDivider.set(40);
            notURLDivider.set(41);
            notURLDivider.set(42);
            notURLDivider.set(43);
            notURLDivider.set(44);
            notURLDivider.set(59);
            notURLDivider.set(61);
            notURLDivider.set(45);
            notURLDivider.set(95);
            notURLDivider.set(46);
            notURLDivider.set(126);
            notURLDivider.set(124);
        }
        return notURLDivider;
    }

    public static Dimension getHeaderRendererSize() {
        return new Dimension(20, 20);
    }

    public static List<IItem> itemListToList(IItemList theItemList) {
        int size = theItemList.getSize();
        ArrayList<IItem> result = new ArrayList<IItem>(size);
        for (int i = 0; i < size; ++i) {
            result.add(theItemList.getItemAt(i));
        }
        return result;
    }

    public static String getUserGuid(MVCController controller) {
        if (controller == null) {
            return null;
        }
        if (controller instanceof NotifyController) {
            return ((NotifyController)controller).getUserGuid();
        }
        ActionList actionList = controller.getActionList();
        if (actionList != null) {
            Component ownerComponent = actionList.getOwnerComponent();
            if (ownerComponent instanceof ApplicationFrame) {
                return ((ApplicationFrame)ownerComponent).getUserGuid();
            }
            MVCController<MVCView> parentController = actionList.getParentController();
            return ControlsUtils.getUserGuid(parentController);
        }
        return null;
    }

    public static String getUserGuid(Component theComponent) {
        ApplicationFrame frame = (ApplicationFrame)SwingUtilities.getAncestorOfClass(ApplicationFrame.class, theComponent);
        if (frame != null) {
            return frame.getUserGuid();
        }
        PanelView panelView = (PanelView)SwingUtilities.getAncestorOfClass(PanelView.class, theComponent);
        if (panelView != null) {
            return panelView.getUserGuid();
        }
        return null;
    }

    public static ApplicationFrame getFrameForController(MVCController controller) {
        if (controller == null) {
            return null;
        }
        ActionList actionList = controller.getActionList();
        if (actionList != null) {
            Component ownerComponent = actionList.getOwnerComponent();
            if (ownerComponent instanceof ApplicationFrame) {
                return (ApplicationFrame)ownerComponent;
            }
            MVCController<MVCView> parentController = actionList.getParentController();
            return ControlsUtils.getFrameForController(parentController);
        }
        return null;
    }

    public static boolean isViewByCalendarSupported(AbstractFolder folder, boolean onPanel) {
        if (folder == null) {
            throw new IllegalArgumentException("folder is null");
        }
        if (onPanel && folder instanceof UserFolder) {
            return true;
        }
        return !folder.isContactsFolder() && !(folder instanceof TrashFolder) && !(folder instanceof UserFolder);
    }

    public static boolean isViewByConversationSupported(AbstractFolder folder, boolean onPanel) {
        if (folder == null) {
            throw new IllegalArgumentException("folder is null");
        }
        if (onPanel && folder instanceof UserFolder) {
            return true;
        }
        return !folder.isContactsFolder() && !(folder instanceof UserFolder);
    }

    public static boolean isViewByCheckListSupported(AbstractFolder folder, boolean onPanel) {
        if (folder == null) {
            throw new IllegalArgumentException("folder is null");
        }
        if (onPanel && folder instanceof UserFolder) {
            return true;
        }
        return !folder.isContactsFolder() && !(folder instanceof QueryFolder) && !(folder instanceof UserFolder);
    }

    public static Integer[] getSupportedViewMods(IFolder folder, boolean onPanel) {
        ArrayList<Integer> viewMods = new ArrayList<Integer>();
        if (onPanel || folder == null) {
            viewMods.add(1);
            viewMods.add(6);
            viewMods.add(5);
            viewMods.add(7);
        } else {
            if (folder.isContactsFolder()) {
                viewMods.add(1);
            } else if (folder.getType() != FolderType.USER) {
                viewMods.add(1);
                viewMods.add(5);
                if (folder.getType() != FolderType.TRASH) {
                    viewMods.add(6);
                }
                if (folder.getType() != FolderType.QUERY) {
                    viewMods.add(7);
                }
            }
            viewMods.add(8);
        }
        return viewMods.toArray(new Integer[viewMods.size()]);
    }

    public static boolean isViewByContactDetailsSupported(AbstractFolder folder, boolean onPanel) {
        if (folder == null) {
            throw new IllegalArgumentException("folder is null");
        }
        return folder.isContactsFolder();
    }

    public static boolean isViewByDetailsSupported(AbstractFolder folder, boolean onPanel) {
        if (folder == null) {
            throw new IllegalArgumentException("folder is null");
        }
        return onPanel && folder instanceof UserFolder || ControlsUtils.isViewByContactDetailsSupported(folder, onPanel) || !(folder instanceof UserFolder);
    }

    public static IPanelDisplaySettings getPanelDisplaySettings(IFolderDisplaySettings folderDisplaySettings, int panelColumn, int panelColumnPosition) {
        if (folderDisplaySettings == null) {
            throw new IllegalArgumentException("folderDisplaySettings is null");
        }
        if (panelColumn < 0) {
            throw new IllegalArgumentException("panelColumn is less than 0: " + panelColumn);
        }
        if (panelColumnPosition < 0) {
            throw new IllegalArgumentException("panelColumnPosition is less than 0: " + panelColumn);
        }
        IPanelDisplaySettings result = null;
        int count = folderDisplaySettings.getPanelCount();
        for (int i = 0; i < count; ++i) {
            IPanelDisplaySettings settings = folderDisplaySettings.getPanelSettings(i);
            if (settings.getPanelColumnNum() != panelColumn || settings.getPanelIndex() != panelColumnPosition) continue;
            result = settings;
            break;
        }
        if (result == null) {
            logger.warn((Object)("panel for column " + panelColumn + " and position " + panelColumnPosition + " was not found"));
        }
        return result;
    }

    public static MVCController findClosestController(Window window) {
        if (window == null) {
            throw new IllegalArgumentException("window is null");
        }
        Application controller = null;
        for (Container parent = window; controller == null && parent != null; parent = parent.getParent()) {
            if (!(parent instanceof MVCView)) continue;
            controller = ((MVCView)((Object)parent)).getController();
        }
        if (controller == null) {
            controller = GWClient.getApplication();
        }
        return controller;
    }

    public static DefaultComboBoxModel getComboBoxModelWithAllAddressBooks() {
        List<AbstractAddressBook> addressBooks = EngineCommandManager.getEditableAddressBooks();
        DefaultComboBoxModel<AbstractAddressBook> model = new DefaultComboBoxModel<AbstractAddressBook>();
        for (AbstractAddressBook addressBook : addressBooks) {
            if (!(addressBook instanceof PersonalAddressBook)) continue;
            model.addElement(addressBook);
        }
        return model;
    }

    public static ListenerManager getListenerManager(MVCController controller) {
        MVCController<MVCView> currentController = controller;
        do {
            Object view;
            if (!((view = currentController.getMVCView()) instanceof ListenerManagerOwner)) continue;
            logger.debug((Object)("view: " + view));
            return ((ListenerManagerOwner)view).getListenerManager();
        } while ((currentController = currentController.getParentController()) != null);
        logger.warn((Object)("not found for controller: " + controller));
        return null;
    }

    public static GWCalendarController getParentGWCalendarController(MVCController controller) {
        MVCController<MVCView> temp = controller;
        while (temp.getParentController() != null) {
            if (!((temp = temp.getParentController()) instanceof GWCalendarController)) continue;
            return (GWCalendarController)temp;
        }
        return null;
    }

    public static AbstractItem getGWItemSelectedCommandObjectAsItem(AppEvent event) {
        Object o = event.getData();
        if (o instanceof ISelectedItemsInfo) {
            ISelectedItemsInfo itemsInfo = (ISelectedItemsInfo)o;
            return itemsInfo.hasItems() ? itemsInfo.getItem() : null;
        }
        return null;
    }

    public static Class<? extends ApplicationFrameToolBar> getItemToolbarClass(AbstractItem item) {
        if (item == null) {
            throw new IllegalArgumentException("item is null");
        }
        Class toolbarClass = item.isSentItem() ? SentItemOperationsToolBar.class : (item instanceof AppointmentItem ? AppointmentOperationsToolBar.class : (item instanceof TaskItem ? TaskOperationsToolBar.class : (item instanceof ReminderNote ? ReminderNoteOperationsToolBar.class : ItemOperationsToolBar.class)));
        return toolbarClass;
    }

    public static <S extends SkinnablePanel> S prepareHeaderPanel(S panel) {
        panel.clearPropertyBindings();
        panel.putSkinProperty(SkinProperty.HEADER_BACKGROUND_COLOR, ComponentProperty.BACKGROUND);
        panel.putSkinProperty(SkinProperty.HEADER_TEXT_COLOR, ComponentProperty.FOREGROUND);
        return panel;
    }

    public static <S extends SkinnableTextField> S prepareHeaderTextField(S component) {
        component.clearPropertyBindings();
        component.putSkinProperty(SkinProperty.HEADER_BACKGROUND_COLOR, ComponentProperty.BACKGROUND);
        component.putSkinProperty(SkinProperty.HEADER_TEXT_COLOR, ComponentProperty.FOREGROUND);
        component.putSkinProperty(SkinProperty.HEADER_FONT_SIZE, ComponentProperty.FONT_SIZE);
        return component;
    }

    public static <S extends SkinnableLabel> S prepareHeaderLabel(S component) {
        component.clearPropertyBindings();
        component.putSkinProperty(SkinProperty.HEADER_BACKGROUND_COLOR, ComponentProperty.BACKGROUND);
        component.putSkinProperty(SkinProperty.HEADER_TEXT_COLOR, ComponentProperty.FOREGROUND);
        component.putSkinProperty(SkinProperty.HEADER_FONT_SIZE, ComponentProperty.FONT_SIZE);
        return component;
    }

    public static <S extends SkinnableCheckBox> S prepareHeaderCheckBox(S component) {
        component.clearPropertyBindings();
        component.putSkinProperty(SkinProperty.HEADER_BACKGROUND_COLOR, ComponentProperty.BACKGROUND);
        component.putSkinProperty(SkinProperty.HEADER_TEXT_COLOR, ComponentProperty.FOREGROUND);
        component.putSkinProperty(SkinProperty.HEADER_FONT_SIZE, ComponentProperty.FONT_SIZE);
        return component;
    }

    public static String getSelectedTextFromItemViewer(MVCController controller) {
        if (controller == null) {
            throw new IllegalArgumentException("controller is null");
        }
        String selectedText = null;
        Object view = controller.getMVCView();
        if (view instanceof Component) {
            Window window = view instanceof Window ? (Window)view : SwingUtilities.getWindowAncestor((Component)view);
            if (window instanceof FrameOpen) {
                selectedText = ((FrameOpen)window).getSelectedText();
            } else if (window instanceof GWMainAppFrame) {
                selectedText = ((GWMainAppFrame)window).getSelectedTextFromItemViewer();
            } else if (window instanceof FrameItemSearch) {
                selectedText = ((FrameItemSearch)window).getSelectedTextFromItemViewer();
            }
        }
        if (selectedText != null && selectedText.length() == 0) {
            selectedText = null;
        }
        return selectedText;
    }

    public static JComponent setToSkinlessComponent(JComponent toolBarComponent) {
        if (toolBarComponent instanceof ISkinnable) {
            ISkinnable skinnableComponent = (ISkinnable)((Object)toolBarComponent);
            skinnableComponent.setSkinabilityEnabled(false);
        } else assert (false) : toolBarComponent;
        return toolBarComponent;
    }
}

