/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.novell.gw.ab.AddressBookItemListFilter;
import com.novell.gw.jclient.api.enums.CategoryListRecordStatusType;
import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.interfaces.ICategory;
import com.novell.gw.jclient.api.interfaces.ICategoryList;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.GWMainAppFrameActionList;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.ABUtils;
import com.novell.gw.jclient.application.controls.filter.AdvancedFilter;
import com.novell.gw.jclient.application.controls.filter.ContactFilter;
import com.novell.gw.jclient.application.controls.filter.CustomFilter;
import com.novell.gw.jclient.application.controls.filter.EmptyFilter;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.categories.CategoryUtils;
import com.novell.gw.jclient.bl.om.filter.Filter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterUtils {
    public static final Set<ICategory> EMPTY_CATEGORY_SET = Collections.emptySet();

    public static void filterByCategory(Filter filter, Set<ICategory> categorySet, MVCController controller) {
        if (categorySet == null) {
            throw new IllegalArgumentException("categorySet is null");
        }
        HashSet<String> searchedCategoryNames = new HashSet<String>();
        for (ICategory category : categorySet) {
            searchedCategoryNames.add(category.getName());
        }
        IDataStore dataStore = EngineCommandManager.getInstance(ControlsUtils.getUserGuid(controller)).getCurrentDataStore();
        ICategoryList categories = APIWrapperManager.createCategoryList(dataStore);
        String userGuid = ControlsUtils.getUserGuid(controller);
        for (int i = 0; i < CategoryUtils.getCategoryCount(userGuid); ++i) {
            if (!searchedCategoryNames.contains(CategoryUtils.getCategory(i, userGuid).getName())) continue;
            categories.addCategory(CategoryUtils.getCategory(i, userGuid), CategoryListRecordStatusType.ADD);
        }
        boolean isContact = false;
        if (controller instanceof GWMainAppFrameActionList) {
            isContact = ((GWMainAppFrame)((GWMainAppFrameActionList)controller).getMVCView()).getFolder().isContactsFolder();
        }
        if (filter == null || filter instanceof EmptyFilter) {
            if (isContact) {
                boolean isSystem = ABUtils.isSystemABAbstractFolder(controller.getActionList());
                ContactFilter contactFilter = new ContactFilter(new AddressBookItemListFilter(isSystem), isSystem);
                contactFilter.setCategories(categories);
                filter = contactFilter;
            } else {
                filter = new CustomFilter();
                ((CustomFilter)filter).setCategories(categories);
            }
        } else if (filter instanceof CustomFilter) {
            ((CustomFilter)filter).setCategories(categories);
        } else if (filter instanceof AdvancedFilter) {
            filter.getItemListFilter().setCategories(categories.getNativeCategoryList());
        } else if (filter instanceof ContactFilter) {
            ((ContactFilter)filter).setCategories(categories);
        } else {
            filter = new AdvancedFilter(filter.getItemListFilter());
            filter.getItemListFilter().setCategories(categories.getNativeCategoryList());
        }
        if (filter instanceof AdvancedFilter) {
            ((AdvancedFilter)filter).setContactType(isContact);
        }
        Command command = new Command(400, filter);
        ((MVCController)controller.getMVCView().getController()).processCommand(command);
    }
}

