/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;

public class RadioButtonGroup
extends ButtonGroup {
    public RadioButtonGroup(Window parent) {
        parent.setFocusTraversalPolicy(new RBFTPolicy());
    }

    private void selectNextButton(AbstractButton selectedButton) {
        int index = this.buttons.indexOf(selectedButton);
        if (++index >= this.buttons.size()) {
            index = 0;
        }
        this.selectButtonAt(index);
    }

    private boolean selectButtonAt(int index) {
        AbstractButton button = (AbstractButton)this.buttons.get(index);
        if (button.isEnabled()) {
            button.setSelected(true);
            button.requestFocus();
            return true;
        }
        return false;
    }

    private void selectPrevButton(AbstractButton selectedButton) {
        int index = this.buttons.indexOf(selectedButton);
        if (--index < 0) {
            index = this.buttons.size() - 1;
        }
        this.selectButtonAt(index);
    }

    private AbstractButton getSelectedButton() {
        int nSize = this.buttons.size();
        for (int i = 0; i < nSize; ++i) {
            AbstractButton button = (AbstractButton)this.buttons.get(i);
            if (!button.isSelected()) continue;
            return button;
        }
        return null;
    }

    public void add(AbstractButton b) {
        super.add(b);
        b.setFocusTraversalKeys(0, new HashSet());
        b.setFocusTraversalKeys(1, new HashSet());
        b.addKeyListener(new RBGKeyListener());
    }

    private class RBFTPolicy
    extends LayoutFocusTraversalPolicy {
        private RBFTPolicy() {
        }

        public Component getComponentAfter(Container aContainer, Component aComponent) {
            return this.findSelectedButton(aContainer, super.getComponentAfter(aContainer, aComponent), true);
        }

        private Component findSelectedButton(Container container, Component component, boolean forward) {
            if (component instanceof JRadioButton) {
                AbstractButton button = (AbstractButton)component;
                if (button.isSelected() && button.isEnabled()) {
                    return button;
                }
                Component next = forward ? super.getComponentAfter(container, component) : super.getComponentBefore(container, component);
                return this.findSelectedButton(container, next, forward);
            }
            return component;
        }

        public Component getComponentBefore(Container aContainer, Component aComponent) {
            return this.findSelectedButton(aContainer, super.getComponentBefore(aContainer, aComponent), false);
        }
    }

    private class RBGKeyListener
    extends KeyAdapter {
        private RBGKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            Component component;
            AbstractButton button = (AbstractButton)e.getSource();
            if (e.getKeyCode() == 40 || e.getKeyCode() == 225) {
                RadioButtonGroup.this.selectNextButton(button);
            }
            if (e.getKeyCode() == 38 || e.getKeyCode() == 224) {
                RadioButtonGroup.this.selectPrevButton((AbstractButton)e.getSource());
            }
            if (KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers()).equals(KeyStroke.getKeyStroke(9, 0))) {
                component = (Component)RadioButtonGroup.this.buttons.get(RadioButtonGroup.this.buttons.size() - 1);
                component.transferFocus();
            }
            if (KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers()).equals(KeyStroke.getKeyStroke(9, 64))) {
                component = (JComponent)RadioButtonGroup.this.buttons.get(0);
                component.transferFocusBackward();
            }
        }
    }
}

