/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.UIUtils;
import com.novell.gw.ab.AddressBookEvent;
import com.novell.gw.ab.AddressBookEventListener;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.ABUtils;
import com.novell.gw.jclient.application.controls.addressbook.DirectoriesTreeController;
import com.novell.gw.jclient.application.controls.addressbook.DirectoriesTreeModel;
import com.novell.gw.jclient.application.controls.folderstree.GWTree;
import com.novell.gw.jclient.application.controls.folderstree.TextTreeRenderer;
import com.novell.gw.jclient.application.controls.menus.DirectoriesTreePopupMenu;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.impl.dnd.GWFlavors;
import com.novell.gw.jclient.bl.om.directory.AbstractAddressBook;
import com.novell.gw.jclient.bl.om.directory.GroupWiseAddressBook;
import com.novell.gw.jclient.bl.om.options.GeneralOptions;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class AddressBookTree
extends GWTree
implements MVCView {
    private static Logger logger = Logger.getLogger(AddressBookTree.class);
    private DirectoriesTreeController controller;
    private AbstractAddressBook targetDirectory;
    private AddressBookEventListener addressBookEventListener;
    private SelectionListener selectionListener;

    public AddressBookTree(MVCController theParentController) {
        this.controller = new DirectoriesTreeController(this, theParentController);
        this.setComponentOrientation(UIUtils.getComponentOrientation());
        this.setCellRenderer(new Renderrer());
        this.getSelectionModel().setSelectionMode(1);
        this.selectionListener = new SelectionListener();
        this.addTreeSelectionListener(this.selectionListener);
        this.setModel(new DirectoriesTreeModel());
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.addMouseListener(new MouseListener());
        this.setDropTarget(new DropTarget(this, 3, new DTDropTargetListener()));
        this.initSelection();
        this.addressBookEventListener = new AddressBookEventListener(){

            public void bookChanged(AddressBookEvent e) {
                AddressBookTree.this.updateTree(e);
            }

            public void entryChanged(AddressBookEvent e) {
                AddressBookTree.this.updateTree(e);
            }
        };
        EngineCommandManager.getAddressBookManager().addAddressBookEventListener(this.addressBookEventListener);
        this.setToolTipFont(this.getFont());
    }

    private void initSelection() {
        String selectedAddressBookID = OptionManager.getInstance().getGeneralOptions().getSelectedAddressBookID();
        if (selectedAddressBookID != null && selectedAddressBookID.length() > 0) {
            this.setSelectedNode(selectedAddressBookID);
        } else {
            DefaultMutableTreeNode firstChild;
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
            if (root != null && root.getFirstChild() instanceof DefaultMutableTreeNode && (firstChild = (DefaultMutableTreeNode)root.getFirstChild()).getUserObject() instanceof AbstractAddressBook) {
                this.setSelectedNode(((AbstractAddressBook)firstChild.getUserObject()).getID());
            }
        }
    }

    public String getName() {
        return "AddressBookTree";
    }

    public String getUIClassID() {
        return "TreeUI";
    }

    public void dispose() {
        this.removeTreeSelectionListener(this.selectionListener);
        ((DefaultMutableTreeNode)this.getModel().getRoot()).removeAllChildren();
        this.setModel(null);
        EngineCommandManager.getAddressBookManager().removeAddressBookEventListener(this.addressBookEventListener);
    }

    private void updateTree(final AddressBookEvent e) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.update(e);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AddressBookTree.this.update(e);
                }
            });
        }
    }

    public void update(AddressBookEvent e) {
        String bookId = String.valueOf(e.getBookId());
        int row = this.getLeadSelectionRow();
        DirectoriesTreeModel model = (DirectoriesTreeModel)this.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        switch (e.getType()) {
            case 1: {
                AbstractAddressBook addressBook = EngineCommandManager.getAddressBook(bookId);
                root.add(new DefaultMutableTreeNode(addressBook));
                model.nodeChanged(root);
                break;
            }
            case 2: {
                model.getDirectoryNode(bookId).removeFromParent();
                model.nodeChanged(root);
                break;
            }
            case 3: {
                model.nodeChanged(model.getDirectoryNode(bookId));
            }
        }
        this.clearSelection();
        this.updateUI();
        this.selectNearestRow(row);
    }

    private void setSelectedNode(String theBookID) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        AbstractAddressBook addressBook = null;
        if (theBookID != null) {
            for (AbstractAddressBook ab : EngineCommandManager.getAddressBooks()) {
                if (!ab.getID().equals(theBookID)) continue;
                addressBook = ab;
                break;
            }
            if (root.getChildCount() > 0 && root.getFirstChild() != null) {
                TreePath treePath = null;
                for (int i = 0; i < root.getChildCount(); ++i) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)root.getChildAt(i);
                    if (!node.getUserObject().equals(addressBook)) continue;
                    treePath = new TreePath(node.getPath());
                }
                if (treePath == null) {
                    DefaultMutableTreeNode firstNode = (DefaultMutableTreeNode)root.getFirstChild();
                    treePath = new TreePath(firstNode.getPath());
                }
                this.setSelectionPath(treePath);
            }
        }
    }

    private void selectNearestRow(int theRow) {
        int index = theRow;
        int size = this.getRowCount();
        index = index >= size ? size - 1 : theRow;
        this.setSelectionRow(index);
    }

    public void setController(MVCController theController) {
        if (!(theController instanceof DirectoriesTreeController)) {
            throw new IllegalArgumentException("Bad controller");
        }
        this.controller = (DirectoriesTreeController)theController;
    }

    public MVCController getController() {
        return this.controller;
    }

    public void setMVCModel(Object theModel) {
    }

    public Object getMVCModel() {
        return null;
    }

    public void repaintDragFolder(Point cursorPos) {
        super.repaintDragFolder(cursorPos);
        this.targetDirectory = this.getDirectoryForPath(this.getPathForRow(this.lastSelectedRow));
    }

    private AbstractAddressBook getDirectoryForPath(TreePath pathForRow) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)pathForRow.getLastPathComponent();
        if (!node.isLeaf()) {
            this.expandPath(pathForRow);
        }
        return (AbstractAddressBook)node.getUserObject();
    }

    private class DTDropTargetListener
    extends DropTargetAdapter {
        private DTDropTargetListener() {
        }

        public void dragOver(DropTargetDragEvent dtde) {
            AddressBookTree.this.repaintDragFolder(dtde.getLocation());
            if (AddressBookTree.this.targetDirectory instanceof GroupWiseAddressBook || AddressBookTree.this.targetDirectory.equals(AddressBookTree.this.getDirectoryForPath(AddressBookTree.this.getSelectionPath()))) {
                dtde.rejectDrag();
            } else {
                dtde.acceptDrag(3);
            }
        }

        public void dragExit(DropTargetEvent dte) {
            AddressBookTree.this.targetDirectory = null;
            AddressBookTree.this.repaint();
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            AddressBookTree.this.repaint();
        }

        public void drop(DropTargetDropEvent dtde) {
            if (dtde.isLocalTransfer()) {
                try {
                    Object data = dtde.getTransferable().getTransferData(GWFlavors.contactsFlavor);
                    dtde.acceptDrop(dtde.getDropAction());
                    if (data instanceof IContact[]) {
                        IContact[] contacts = (IContact[])data;
                        ABUtils.copyContacts(AddressBookTree.this.targetDirectory, Arrays.asList(contacts), SwingUtilities.getWindowAncestor(AddressBookTree.this));
                        dtde.dropComplete(true);
                    }
                }
                catch (UnsupportedFlavorException e) {
                    logger.error((Object)e);
                    logger.debug((Object)e, (Throwable)e);
                }
                catch (IOException e) {
                    logger.error((Object)e);
                    logger.debug((Object)e, (Throwable)e);
                }
                AddressBookTree.this.targetDirectory = null;
                AddressBookTree.this.repaint();
            }
        }
    }

    private class MouseListener
    extends MouseAdapter {
        private MouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.doPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.doPopup(e);
        }

        private void doPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                int row = AddressBookTree.this.getRowForLocation(e.getX(), e.getY());
                if (row < 0) {
                    return;
                }
                AddressBookTree.this.setSelectionRow(row);
                Object object = ((DefaultMutableTreeNode)AddressBookTree.this.getSelectionPath().getLastPathComponent()).getUserObject();
                DirectoriesTreePopupMenu popup = new DirectoriesTreePopupMenu(AddressBookTree.this.getController().getActionList(), (AbstractAddressBook)object);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class SelectionListener
    implements TreeSelectionListener {
        private SelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            Object selectedObject = e.getPath().getLastPathComponent();
            logger.debug((Object)("selectedObject = " + selectedObject));
            if (((DefaultMutableTreeNode)selectedObject).getUserObject() instanceof AbstractAddressBook) {
                AbstractAddressBook directory = (AbstractAddressBook)((DefaultMutableTreeNode)selectedObject).getUserObject();
                Command command = new Command(360, directory);
                AddressBookTree.this.getController().processCommand(command);
                GeneralOptions generalOptions = OptionManager.getInstance().getGeneralOptions();
                generalOptions.setSelectedAddressBookID(directory.getID());
                OptionManager.getInstance().setGeneralOptions(generalOptions);
            }
        }
    }

    private class Renderrer
    extends DefaultTreeCellRenderer
    implements TextTreeRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (AddressBookTree.this.targetDirectory != null) {
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                sel = userObject != null && userObject.equals(AddressBookTree.this.targetDirectory);
            }
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            Object userobject = ((DefaultMutableTreeNode)value).getUserObject();
            if (userobject instanceof AbstractAddressBook) {
                this.setIcon(ControlsUtils.getIconForAddressBook((AbstractAddressBook)userobject));
            } else {
                this.setIcon(null);
            }
            return this;
        }

        public int getTextX() {
            return ImageResources.ICON_SHARED_BY_ME_ADDRESS_BOOK.getIconWidth() + this.getIconTextGap();
        }
    }
}

