/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook;

import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.application.controls.addressbook.AddressSelectorCloseListener;
import com.novell.gw.jclient.application.controls.addressbook.SearchResultListener;
import com.novell.gw.jclient.application.controls.addressbook.SearchTextField;
import com.novell.gw.jclient.application.controls.addressbook.SimpleSelectorDialog;
import com.novell.gw.jclient.application.controls.toolbars.GWToolBar;
import com.novell.gw.jclient.application.resources.ImageResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class AddressSelector
extends JComponent {
    protected SearchTextField searchField;
    protected AbstractButton pickerButton;
    private SimpleSelectorDialog dialog;
    private MVCController controller;
    private AddressSelectorCloseListener closeListener;

    public AddressSelector(IContact theContact, MVCController theParentController) {
        this.controller = theParentController;
        this.init();
        this.setContact(theContact);
    }

    public void setContact(IContact theContact) {
        if (theContact != null) {
            this.searchField.setTextToParse(theContact.getDisplayName());
        }
    }

    public IContact getContact() {
        return this.searchField.getContact();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setComponentOrientation(UIUtils.getComponentOrientation());
        this.searchField = new SearchTextField();
        this.add((Component)this.searchField, "Center");
        this.initPickerButton();
        GWToolBar toolBar = new GWToolBar();
        toolBar.add(this.pickerButton);
        toolBar.setBorder(null);
        this.add((Component)toolBar, "After");
    }

    private void initPickerButton() {
        this.pickerButton = UIUtils.createToolButton(new ContactPickerAction());
        this.pickerButton.setIcon(ImageResources.ICON_ACT_VIEW_ADDRESS_SELECTOR);
    }

    private void createDialog() {
        Window frame = SwingUtilities.getWindowAncestor(this);
        if (frame instanceof JFrame) {
            this.dialog = new SimpleSelectorDialog((JFrame)frame, this.controller);
        }
        if (frame instanceof JDialog) {
            this.dialog = new SimpleSelectorDialog((JDialog)frame, this.controller);
        }
    }

    private void showDialog() {
        this.createDialog();
        this.dialog.setSelectedEntry(this.searchField.getContact());
        this.dialog.setVisible(true);
        if (this.dialog.isOkActionProcessed()) {
            IContact selectedEntry = this.dialog.getSelectedEntry();
            this.setContact(selectedEntry);
            if (this.closeListener != null && selectedEntry != null) {
                this.closeListener.contactSelected(selectedEntry);
            }
        }
    }

    public JTextComponent getTextComponent() {
        return this.searchField;
    }

    public void setIcon(ImageIcon theIcon) {
        this.pickerButton.setIcon(theIcon);
    }

    public void setText(String theText) {
        this.searchField.setText(theText);
    }

    public void selectAll() {
        this.searchField.selectAll();
    }

    public String getText() {
        return this.searchField.getText();
    }

    public void setSearchResultListener(SearchResultListener theListener) {
        this.searchField.setListener(theListener);
    }

    public void setAddressSelectorCloseListener(AddressSelectorCloseListener theListener) {
        this.closeListener = theListener;
    }

    public void updateListener() {
        this.searchField.updateListener();
    }

    public void requestFocus() {
        this.searchField.requestFocus();
    }

    private class ContactPickerAction
    extends AbstractAction {
        private ContactPickerAction() {
        }

        public void actionPerformed(ActionEvent e) {
            AddressSelector selector = AddressSelector.this;
            if (!selector.searchField.isFocusOwner()) {
                selector.searchField.grabFocus();
            }
            selector.showDialog();
        }
    }
}

