/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook;

import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.addressbook.AbstractAddressSelectorDialog;
import com.novell.gw.jclient.application.controls.addressbook.table.AbstractAddressBookTable;
import com.novell.gw.jclient.application.controls.addressbook.table.ContactNotFoundException;
import com.novell.gw.jclient.application.options.OptionManager;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class SimpleSelectorDialog
extends AbstractAddressSelectorDialog {
    private static Logger logger = Logger.getLogger(SimpleSelectorDialog.class);

    public SimpleSelectorDialog(JDialog theDialog, MVCController theParentController) {
        super(theDialog, theParentController);
    }

    public SimpleSelectorDialog(JFrame theFrame, MVCController theParentController) {
        super(theFrame, theParentController);
    }

    protected void init() {
        this.tableAddressList = new SelectorTable((MVCController)this.getController());
        this.tableAddressList.getSelectionModel().setSelectionMode(0);
        super.init();
        this.toggleSizeSaving("Simple Selector Dialog");
        this.tfSearch.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 40 || e.getKeyCode() == 38) {
                    SimpleSelectorDialog.this.requestFocus();
                }
            }
        });
        this.pack();
    }

    public void setSelectedEntry(IContact theContact) {
        if (theContact == null) {
            return;
        }
        try {
            this.tableAddressList.setSelectedEntry(theContact);
        }
        catch (ContactNotFoundException e) {
            this.tfSearch.setText(theContact.getDisplayName());
        }
    }

    public IContact getSelectedEntry() {
        IItem item = this.tableAddressList.getSelectedEntry();
        if (item != null && item instanceof IContact) {
            return (IContact)item;
        }
        return null;
    }

    void buildUI() {
        super.buildUI();
        JPanel pnlContent = (JPanel)this.getContentPane();
        pnlContent.add((Component)new JPanel(), "After");
    }

    protected JPanel buildToggleButtons() {
        return null;
    }

    private class SelectorTable
    extends AbstractAddressBookTable {
        public SelectorTable(MVCController theParentController) {
            super(theParentController, SimpleSelectorDialog.this.tfSearch);
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    int index;
                    if (e.isPopupTrigger() && (index = SelectorTable.this.rowAtPoint(e.getPoint())) != -1) {
                        SelectorTable.this.setRowSelectionInterval(index, index);
                    }
                }
            });
            this.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    int itemDeleteKey = OptionManager.getInstance().getGeneralOptions().getItemDeleteKey();
                    if (e.getKeyCode() == itemDeleteKey) {
                        SelectorTable.this.controller.getActionList().performAction(ActionKey.DELETE_CONTACT);
                    }
                }
            });
        }

        protected void performDefaultAction() {
            SimpleSelectorDialog.this.processOkAction(null);
            SimpleSelectorDialog.this.dispose();
        }
    }
}

