/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.dialogs;

import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class GridBagAdapter {
    private static Logger logger = Logger.getLogger(GridBagAdapter.class);
    private JPanel container;
    private GridBagConstraints constraints;
    private int columnCount;
    private int componentNumber;
    private Insets defaultInsets = new Insets(0, 5, 10, 5);

    public GridBagAdapter(JPanel theContainer) {
        this.container = theContainer;
        this.constraints = new GridBagConstraints();
        this.componentNumber = 0;
        this.constraintsToDefault();
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
    }

    public void endRow() {
        this.constraints.gridx = 0;
        ++this.constraints.gridy;
    }

    public void addComponent(Component theComponent) {
        this.container.add(theComponent, this.constraints);
        this.constraints.gridx += this.constraints.gridwidth;
        if (this.constraints.gridx >= this.columnCount) {
            ++this.constraints.gridy;
            this.constraints.gridx = 0;
        }
        this.constraintsToDefault();
    }

    public void removeComponent(Component theComponent) {
        this.container.remove(theComponent);
        if (this.constraints.gridx == 0) {
            this.constraints.gridx = this.columnCount - this.constraints.gridwidth;
            --this.constraints.gridy;
        } else {
            this.constraints.gridx -= this.constraints.gridwidth;
        }
        if (this.constraints.gridx >= this.columnCount) {
            ++this.constraints.gridy;
            this.constraints.gridx = 0;
        }
        this.constraintsToDefault();
    }

    public void setResizableColumn(int theColumn) {
        this.constraints.gridx = theColumn;
        this.constraints.weightx = 100.0;
        this.container.add((Component)new OrientableLabel(), this.constraints);
        this.constraints.gridx = 0;
        this.constraintsToDefault();
    }

    public void setColumnCount(int theCount) {
        for (int i = 0; i < theCount; ++i) {
            this.container.add((Component)new OrientableLabel(), this.constraints);
            ++this.constraints.gridx;
        }
        this.columnCount = theCount;
        this.constraints.gridx = 0;
        this.constraintsToDefault();
    }

    public void setRowCount(int theCount) {
        for (int i = 0; i < theCount; ++i) {
            this.container.add((Component)new OrientableLabel(), this.constraints);
            ++this.constraints.gridy;
        }
        this.constraints.gridy = 0;
        this.constraintsToDefault();
    }

    public void setIpadx(int theIpadx) {
        this.constraints.ipadx = theIpadx;
    }

    public void setGridX(int theGridX) {
        this.constraints.gridx = theGridX;
    }

    public void setGridY(int theGridY) {
        this.constraints.gridy = theGridY;
    }

    public void setIpady(int theIpady) {
        this.constraints.ipady = theIpady;
    }

    public void setAnchor(int theAnchor) {
        this.constraints.anchor = theAnchor;
    }

    public void setGridWidth(int theGridWidth) {
        this.constraints.gridwidth = theGridWidth;
    }

    public void setGridHeight(int theGridHeight) {
        this.constraints.gridheight = theGridHeight;
    }

    public void setInsets(Insets theInsets) {
        this.constraints.insets = theInsets;
    }

    public void setWidthX(int theWidthX) {
        this.constraints.weightx = theWidthX;
    }

    public void setWidthY(int theWidthY) {
        this.constraints.weighty = theWidthY;
    }

    public void setFill(int theFill) {
        this.constraints.fill = theFill;
    }

    private void constraintsToDefault() {
        this.constraints.fill = 1;
        this.constraints.insets = this.defaultInsets;
        this.constraints.ipadx = 0;
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 1;
        this.constraints.anchor = 10;
        this.constraints.weightx = 0.0;
        this.constraints.weighty = 0.0;
    }

    private Insets getDefaultInsets() {
        return this.defaultInsets;
    }

    public void setDefaultInsets(Insets theDefaultInsets) {
        this.defaultInsets = theDefaultInsets;
    }
}

