/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook.dialogs;

import com.novell.gw.jclient.api.interfaces.ab.IUserContact;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.ContactDetailsPane;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.TitleValueContainer;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.UserContactDetailsPane;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;

class PersonalPane
extends UserContactDetailsPane {
    private JTextField tfState = new GWTextField();
    private JTextField tfZip = new GWTextField();
    private JTextField tfCountry = new GWTextField();
    private JTextField tfCity = new GWTextField();
    private JTextArea taAddress = new GWTextArea(4, 1);
    private JTextField tfWebSite = new GWTextField("http://");
    private JButton btnWebSite = new JButton(new ContactDetailsPane.LaunchWebSiteAction(this.tfWebSite, this));

    public PersonalPane(IUserContact theContact) {
        super(theContact);
        this.tfState.setName("PersonalPane_tfState");
        this.tfZip.setName("PersonalPane_tfZip");
        this.tfCountry.setName("PersonalPane_tfCountry");
        this.tfCity.setName("PersonalPane_tfCity");
        this.taAddress.setName("PersonalPane_taAddress");
        this.tfWebSite.setName("PersonalPane_tfWebSite");
        this.setName(StringResources.PERSONAL);
        this.setLayout(new GridBagLayout());
        this.buildUI();
        this.setBorder(BorderFactory.createTitledBorder(StringResources.PERSONAL));
    }

    private void addPropertiesChangeListener() {
        if (!this.isReadOnly) {
            this.taAddress.addKeyListener(this.getPropertiesChangeListener());
            this.tfCity.addKeyListener(this.getPropertiesChangeListener());
            this.tfCountry.addKeyListener(this.getPropertiesChangeListener());
            this.tfState.addKeyListener(this.getPropertiesChangeListener());
            this.tfWebSite.addKeyListener(this.getPropertiesChangeListener());
            this.tfZip.addKeyListener(this.getPropertiesChangeListener());
        }
    }

    private void buildUI() {
        int width = this.btnWebSite.getIcon().getIconWidth() + 8;
        this.btnWebSite.setPreferredSize(new Dimension(width, this.tfWebSite.getPreferredSize().height));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(5, 3, 5, 5);
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.gridy = 0;
        this.add((Component)new JMnemonicLabel(StringResources.ADDRESS_C, this.taAddress), constraints);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.gridwidth = 3;
        this.add((Component)new OrientableScrollPane(this.taAddress), constraints);
        constraints.fill = 2;
        constraints.gridwidth = 1;
        TitleValueContainer container = new TitleValueContainer(this);
        container.buildRow(new JMnemonicLabel(StringResources.CITY_C, this.tfCity), this.tfCity, 5);
        container.buildRow(new JMnemonicLabel(StringResources.STATE_PROVINCE_C, this.tfState), this.tfState, new JMnemonicLabel(StringResources.ZIP_POSTAL_CODE_C, this.tfZip), this.tfZip, 6);
        container.buildRow(new JMnemonicLabel(StringResources.COUNTRY_C, this.tfCountry), this.tfCountry, new OrientableLabel(), new OrientableLabel(), 7);
        container.buildRow((JComponent)new JMnemonicLabel(StringResources.WEB_SITE_C, this.tfWebSite), (JComponent)this.tfWebSite, this.btnWebSite, 8);
        constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridy = 9;
        constraints.gridx = 1;
        this.add((Component)new OrientableLabel(), constraints);
    }

    public boolean loadProperties() {
        this.tfCity.setText(this.contact.getHomeCity());
        this.tfCountry.setText(this.contact.getHomeCountry());
        this.tfState.setText(this.contact.getHomeState());
        this.tfWebSite.setText(this.contact.getHomeWebsite());
        this.tfZip.setText(this.contact.getHomePostalCode());
        this.taAddress.setText(this.contact.getHomeStreetAddress());
        this.addPropertiesChangeListener();
        return true;
    }

    public boolean saveProperties() {
        return this.contact.setHomeCity(this.tfCity.getText()) & this.contact.setHomeCountry(this.tfCountry.getText()) & this.contact.setHomeState(this.tfState.getText()) & this.contact.setHomeWebsite(this.tfWebSite.getText()) & this.contact.setHomePostalCode(this.tfZip.getText()) & this.contact.setHomeStreetAddress(this.taAddress.getText());
    }

    public JComponent getDefaultComponent() {
        return this.taAddress;
    }
}

