/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.attachmentlist;

import com.novell.gw.jclient.application.controls.ScrollPaneBorderHighlightFocusListener;
import com.novell.gw.jclient.application.controls.attachmentlist.LargeIconsListRenderer;
import com.novell.gw.jclient.application.controls.attachmentlist.SmallIconsListRenderer;
import com.novell.gw.jclient.application.controls.attachmentlist.ViewContent;
import com.novell.gw.jclient.application.controls.orientable.OrientableList;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;

class ListView
extends OrientableList
implements ViewContent {
    private boolean viewMessage;
    private Object popupItem;
    private boolean locked;
    private boolean selectionEnabled = true;

    public ListView(boolean isViewMessage, Object[] theElements) {
        this.setBackground(Color.WHITE);
        this.viewMessage = isViewMessage;
        this.setVisibleRowCount(0);
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        int nCount = theElements.length;
        for (int i = 0; i < nCount; ++i) {
            model.add(i, theElements[i]);
        }
        this.setModel(model);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.addFocusListener(new ScrollPaneBorderHighlightFocusListener(this));
        this.setName("Attachment list view");
        this.setDragEnabled(true);
    }

    public void scrollRectToVisible(Rectangle aRect) {
        if (aRect.height > this.getVisibleRect().height) {
            aRect.height = this.getVisibleRect().height;
        }
        super.scrollRectToVisible(aRect);
    }

    public Object getItemAtPoint(Point thePoint) {
        int index = this.locationToIndex(thePoint);
        Object item = null;
        if (index != -1 && this.getCellBounds(index, index).contains(thePoint)) {
            item = this.getModel().getElementAt(index);
        }
        return item;
    }

    public void setViewMode(int viewMode) {
        switch (viewMode) {
            case 1: {
                this.setCellRenderer(new LargeIconsListRenderer(this.viewMessage, this));
                this.setLayoutOrientation(2);
                break;
            }
            case 0: {
                this.setCellRenderer(new SmallIconsListRenderer(this.viewMessage, this));
                this.setLayoutOrientation(2);
                break;
            }
            case 2: {
                this.setCellRenderer(new SmallIconsListRenderer(this.viewMessage, this));
                this.setLayoutOrientation(1);
            }
        }
        this.revalidate();
    }

    public void removeAllElements() {
        ((DefaultListModel)this.getModel()).removeAllElements();
    }

    public void addElement(Object obj) {
        ((DefaultListModel)this.getModel()).addElement(obj);
    }

    public Object getElementAt(int index) {
        return this.getModel().getElementAt(index);
    }

    public int getItemsCount() {
        return this.getModel().getSize();
    }

    public boolean removeElement(Object obj) {
        return ((DefaultListModel)this.getModel()).removeElement(obj);
    }

    private int getItemIndex(Object theObject) {
        int size = this.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            if (!this.getElementAt(i).equals(theObject)) continue;
            return i;
        }
        return -1;
    }

    public Object[] getElements() {
        int size = this.getModel().getSize();
        Object[] result = new Object[size];
        for (int i = 0; i < size; ++i) {
            result[i] = this.getElementAt(i);
        }
        return result;
    }

    public void selectItems(Object[] theSelectedValues) {
        this.clearSelection();
        int[] indeces = new int[theSelectedValues.length];
        for (Object selectedValue : theSelectedValues) {
            int index;
            indeces[i] = index = this.getItemIndex(selectedValue);
        }
        if (indeces.length > 0) {
            int index = indeces[0];
            this.setSelectedIndices(indeces);
            this.ensureIndexIsVisible(index);
        }
    }

    public void setPopupItem(Object o, boolean lock) {
        this.locked = lock;
        this.popupItem = o;
    }

    public void setPopupItem(Object o) {
        if (!this.locked) {
            this.popupItem = o;
        }
    }

    public Object getPopupItem() {
        return this.popupItem;
    }

    public void setSelectionEnabled(boolean b) {
        this.selectionEnabled = b;
    }

    public boolean isSelectionEnabled() {
        return this.selectionEnabled;
    }

    public boolean containsObject(Object theObject) {
        for (Object element : this.getElements()) {
            if (!element.equals(theObject)) continue;
            return true;
        }
        return false;
    }

    public void setFocused(boolean theFocused) {
        if (theFocused) {
            this.grabFocus();
        }
    }

    public boolean isFocused() {
        return this.isFocusOwner();
    }

    public int[] getSelectedIndices() {
        return super.getSelectedIndices();
    }

    public void updateScrollPane() {
    }
}

