/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.attachmentlist;

import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.attachmentlist.BorderLabel;
import com.novell.gw.jclient.application.controls.attachmentlist.ViewContent;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.GWAttachment;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

class SmallIconsListRenderer
implements ListCellRenderer {
    private static final Color LIGHT_SELECTION_COLOR = Color.LIGHT_GRAY;
    private BorderLabel lbIcon = new BorderLabel();
    private JPanel pnlContent;
    private boolean viewMessage;
    private ViewContent viewContent;

    public SmallIconsListRenderer(boolean theViewMessage, ViewContent theViewContent) {
        this.lbIcon.setOpaque(true);
        this.pnlContent = new OrientablePanel(new BorderLayout(0, 2));
        this.pnlContent.add((Component)this.lbIcon, "Center");
        this.pnlContent.setOpaque(false);
        this.pnlContent.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.viewMessage = theViewMessage;
        this.viewContent = theViewContent;
    }

    public static Icon getIconForAttachment(Object theAttachment) {
        if (theAttachment instanceof GWAttachment) {
            GWAttachment attachment = (GWAttachment)theAttachment;
            return ControlsUtils.getSmallIconForAttachment(attachment.getFileName(), attachment.getDownloadState());
        }
        if (theAttachment instanceof AbstractItem) {
            return ControlsUtils.getAttachmentIconForGWItem((AbstractItem)theAttachment, false);
        }
        throw new IllegalArgumentException("Unsupported attachment type [" + theAttachment.getClass().getName() + ']');
    }

    public static boolean isMessage(Object theObject) {
        return theObject instanceof AbstractItem;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (index == 0 && SmallIconsListRenderer.isMessage(value) && this.viewMessage) {
            this.lbIcon.setText(StringResources.MESSAGE);
            this.lbIcon.setIcon(ImageResources.ICON_MESSAGE_SMALL);
        } else {
            this.lbIcon.setIcon(SmallIconsListRenderer.getIconForAttachment(value));
            this.lbIcon.setText(value.toString());
        }
        if (isSelected) {
            if (this.viewContent.isSelectionEnabled()) {
                this.lbIcon.setBackground(list.getSelectionBackground());
            } else if (this.viewContent.getPopupItem() == value) {
                this.lbIcon.setBackground(list.getSelectionBackground());
            } else {
                this.lbIcon.setBackground(LIGHT_SELECTION_COLOR);
            }
            this.lbIcon.setForeground(list.getSelectionForeground());
        } else {
            this.lbIcon.setBackground(list.getBackground());
            this.lbIcon.setForeground(list.getForeground());
        }
        this.lbIcon.setPaintBorder(value == this.viewContent.getPopupItem());
        return this.pnlContent;
    }
}

