/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.autodate;

import com.appframework.utils.Day;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.controls.autodate.AutodateCalendarPanel;
import com.novell.gw.jclient.application.controls.basicdialogs.OkCancelDialog;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.Calendar;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class AutoDateDialog
extends OkCancelDialog {
    private AutodateCalendarPanel autodateCalendarPanel;
    private Calendar[] selectedDates;

    public AutoDateDialog(JFrame theParent) {
        super((Frame)theParent, true);
        this.buildUI();
    }

    private void buildUI() {
        this.setTitle(StringResources.AUTO_DATE);
        OrientableTabbedPane tabbedPane = new OrientableTabbedPane();
        this.autodateCalendarPanel = new AutodateCalendarPanel();
        tabbedPane.add(StringResources.DATES, new OrientableScrollPane(this.autodateCalendarPanel));
        this.getContentPane().add((Component)tabbedPane, "Center");
        this.getContentPane().add((Component)this.buildButtonsPanel(), "South");
    }

    protected JPanel buildButtonsPanel() {
        OrientableButton btnReset = new OrientableButton(new ActionReset());
        this.setDefaultButton(this.getBtnOk());
        if (OS.isMacOS()) {
            return OS.buildButtonsPanel(this.getBtnOk(), this.getBtnCancel(), null, btnReset);
        }
        OrientablePanel buttonPanel = new OrientablePanel(new FlowLayout(4));
        OS.addButtons(buttonPanel, this.getBtnOk(), this.getBtnCancel(), btnReset);
        return buttonPanel;
    }

    public Day[] getSelectedDays() {
        Calendar[] dates = this.autodateCalendarPanel.getSelectedDates();
        return GWCalendarUtils.convertCalendarsToDays(dates);
    }

    public void setSelectedDays(Day[] days) {
        Calendar[] dates = GWCalendarUtils.convertDaysToCalendars(days);
        this.selectedDates = GWCalendarUtils.cloneCalendarArray(dates);
        this.autodateCalendarPanel.setSelectedDates(dates);
    }

    public void reset() {
        this.autodateCalendarPanel.reset();
    }

    private void cancel() {
        this.autodateCalendarPanel.setSelectedDates(GWCalendarUtils.cloneCalendarArray(this.selectedDates));
    }

    protected void processCancelAction(ActionEvent event) {
        this.cancel();
        super.processCancelAction(event);
    }

    protected void processCloseAction(WindowEvent event) {
        this.cancel();
        super.processCloseAction(event);
    }

    protected void processOkAction(ActionEvent event) {
        Day[] dates = this.getSelectedDays();
        if (dates == null || dates.length == 0) {
            JOptionPane.showMessageDialog(this, StringResources.THIS_AUTO_DATE_DOESNT_GENERATE, StringResources.GROUP_WISE_ERROR, 2);
            return;
        }
        super.processOkAction(event);
    }

    private class ActionReset
    extends AbstractAction {
        public ActionReset() {
            super(StringResources.RESET);
        }

        public void actionPerformed(ActionEvent e) {
            AutoDateDialog.this.reset();
        }
    }
}

