/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.autodate;

import com.novell.gw.jclient.application.controls.orientable.OrientableTabbedPane;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.apache.log4j.Logger;

public class CheckChangeTabbedPane
extends OrientableTabbedPane
implements MouseListener {
    private static Logger logger = Logger.getLogger(CheckChangeTabbedPane.class);
    private MouseListener tabbedPaneMouseListener;
    private ModifiedTabbedPaneUI tpUI = new ModifiedTabbedPaneUI();

    public CheckChangeTabbedPane() {
        this.setUI(this.tpUI);
        MouseListener[] ml = this.getMouseListeners();
        for (int i = 0; i < ml.length; ++i) {
            if (!(ml[i] instanceof BasicTabbedPaneUI.MouseHandler)) continue;
            this.tabbedPaneMouseListener = ml[i];
            this.removeMouseListener(this.tabbedPaneMouseListener);
            break;
        }
        this.removeMouseListener(ml[0]);
        this.addMouseListener(this);
    }

    public static boolean canChangeTabPanel() {
        return true;
    }

    public void mouseClicked(MouseEvent e) {
        this.tabbedPaneMouseListener.mouseClicked(e);
    }

    public void mousePressed(MouseEvent e) {
        int tabClicked = this.getTabAtLocation(e.getPoint());
        if (tabClicked != -1 && tabClicked != this.getSelectedIndex() && CheckChangeTabbedPane.canChangeTabPanel()) {
            this.tabbedPaneMouseListener.mousePressed(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.tabbedPaneMouseListener.mouseReleased(e);
    }

    public void mouseEntered(MouseEvent e) {
        this.tabbedPaneMouseListener.mouseEntered(e);
    }

    public void mouseExited(MouseEvent e) {
        this.tabbedPaneMouseListener.mouseExited(e);
    }

    int getTabAtLocation(Point point) {
        return this.tpUI.getTabAtLocation(point);
    }

    class ModifiedTabbedPaneUI
    extends BasicTabbedPaneUI {
        ModifiedTabbedPaneUI() {
        }

        private int getTabAtLocation(Point point) {
            int tabCount = this.tabPane.getTabCount();
            for (int i = 0; i < tabCount; ++i) {
                if (!this.rects[i].contains(point.x, point.y)) continue;
                return i;
            }
            return -1;
        }
    }
}

