/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.autodate;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.autodate.ChangeYearDialog;
import com.novell.gw.jclient.application.controls.autodate.SpinButtons;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class SpinYearButtons
extends SpinButtons {
    private static Logger logger = Logger.getLogger(SpinYearButtons.class);
    public static final String DATA_CHANGED = "Date_changed";
    private Calendar gcDay = GWCalendarUtils.getToday();

    public SpinYearButtons() {
        super(new BorderLayout());
        this.buildUI();
        this.addButtonListeners();
        this.refreshView();
    }

    protected void addButtonListeners() {
        this.btnCenter.addActionListener(new BtnYearAction());
        if (UIUtils.getComponentOrientation().isLeftToRight()) {
            this.btnLess.addActionListener(new LessAction());
            this.btnMore.addActionListener(new MoreAction());
        } else {
            this.btnLess.addActionListener(new MoreAction());
            this.btnMore.addActionListener(new LessAction());
        }
    }

    protected void refreshView() {
        String text = String.valueOf(this.gcDay.get(1));
        this.btnCenter.setText(text);
        int btnWidth = SwingUtilities.computeStringWidth(this.btnCenter.getFontMetrics(this.btnCenter.getFont()), text) + 50;
        this.btnCenter.setPreferredSize(new Dimension(btnWidth, PLAFChanger.getFontSize() + 5));
    }

    public void setYear(int theYear) {
        this.gcDay.set(1, theYear);
        this.refreshView();
        this.firePropertyChange(DATA_CHANGED, null, this.gcDay);
    }

    class BtnYearAction
    extends AbstractAction {
        BtnYearAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ChangeYearDialog dialog = new ChangeYearDialog(SpinButtons.getParentDialog(SpinYearButtons.this), SpinYearButtons.this.gcDay);
            dialog.showMe();
            if (dialog.isActionCompleteSuccessfully()) {
                SpinYearButtons.this.gcDay.set(1, dialog.getYear());
                SpinYearButtons.this.refreshView();
                SpinYearButtons.this.firePropertyChange(SpinYearButtons.DATA_CHANGED, null, SpinYearButtons.this.gcDay);
            }
        }
    }

    class MoreAction
    extends AbstractAction {
        MoreAction() {
        }

        public void actionPerformed(ActionEvent e) {
            SpinYearButtons.this.gcDay.add(1, 1);
            SpinYearButtons.this.refreshView();
            SpinYearButtons.this.firePropertyChange(SpinYearButtons.DATA_CHANGED, null, SpinYearButtons.this.gcDay);
        }
    }

    class LessAction
    extends AbstractAction {
        LessAction() {
        }

        public void actionPerformed(ActionEvent e) {
            SpinYearButtons.this.gcDay.add(1, -1);
            SpinYearButtons.this.refreshView();
            SpinYearButtons.this.firePropertyChange(SpinYearButtons.DATA_CHANGED, null, SpinYearButtons.this.gcDay);
        }
    }
}

