/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.busysearch;

import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.api.enums.BusySearchRecipientResultUserstatus;
import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.impl.message.APIMessageWrapperManager;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.api.interfaces.message.IBusySearch;
import com.novell.gw.jclient.application.controls.addressbook.ABUtils;
import com.novell.gw.jclient.application.controls.busysearch.RecipientDescription;
import com.novell.gw.jclient.application.controls.busysearch.RecipientDescriptionsList;
import com.novell.gw.jclient.application.controls.busysearch.TimeBlockInfo;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.TimeInterval;
import com.novell.gw.message.BusySearchEvent;
import com.novell.gw.message.BusySearchListener;
import com.novell.gw.message.BusySearchRecipientResult;
import com.novell.gw.message.BusySearchTimeBlock;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GWBusySearch {
    private static Logger logger = Logger.getLogger(GWBusySearch.class);
    private TreeMap<String, List<TimeBlockInfo>> tmOutOfOfficeTime = new TreeMap();
    private TreeMap<String, List<TimeBlockInfo>> tmBusyTime = new TreeMap();
    private TreeMap<String, List<TimeBlockInfo>> tmTentativeTime = new TreeMap();
    private TreeMap<String, List<TimeBlockInfo>> tmWorkshedule = new TreeMap();
    private TimeInterval appointmentTime = new TimeInterval();
    private IBusySearch nativeBusySearch;
    private Calendar start = GWCalendarUtils.getToday();
    private Calendar end = GWCalendarUtils.getToday();
    private Calendar dayEnd = GWCalendarUtils.getToday();
    private boolean stillWorking = true;
    private Date searchStartTime;
    private int daysCount;
    private RecipientDescriptionsList recipientDescriptionsList;
    private int completedRecipientSize;
    private Set<GWBusySearchListener> listeners = new HashSet<GWBusySearchListener>();
    private boolean busySearchResultsComplete = false;

    public GWBusySearch(IDataStore dataStore, Date appointmentStartTime, Date appointmentEndTime, RecipientDescriptionsList recipientsList, Date searchStartTime, int daysCount) throws EngineException {
        this.nativeBusySearch = APIMessageWrapperManager.createBusySearch(dataStore, appointmentStartTime, appointmentEndTime, recipientsList.getDistributionList(), searchStartTime, daysCount);
        this.busySearchResultsComplete = false;
        this.nativeBusySearch.addBusySearchListener(new NativeBusySearchListener());
        this.searchStartTime = searchStartTime;
        this.daysCount = daysCount;
        this.init();
    }

    public IBusySearch getNativeBusySearch() {
        return this.nativeBusySearch;
    }

    public TimeInterval getAppointmentTime() {
        return this.appointmentTime;
    }

    public void setAppointmentTime(TimeInterval appointmentTime) {
        this.appointmentTime = appointmentTime;
    }

    private synchronized void init() {
        this.tmOutOfOfficeTime.clear();
        this.tmBusyTime.clear();
        this.tmTentativeTime.clear();
        this.tmWorkshedule.clear();
        this.recipientDescriptionsList = new RecipientDescriptionsList();
        try {
            Enumeration enumeration = this.nativeBusySearch.recipientEnumeration();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    BusySearchRecipientResult r = (BusySearchRecipientResult)enumeration.nextElement();
                    IRecipient recipient = APIAbWrapperManager.getRecipient(r.getRecipient());
                    if (recipient == null) continue;
                    logger.debug((Object)recipient.getAddressable().getDisplayName());
                    boolean unresolved = recipient.isUnresolved();
                    logger.debug((Object)unresolved);
                    BusySearchRecipientResultUserstatus userStatus = BusySearchRecipientResultUserstatus.getEnum(r.getRecipientStatus());
                    RecipientDescription recipientDescription = new RecipientDescription(recipient);
                    recipientDescription.setUserstatus(userStatus);
                    this.recipientDescriptionsList.addRecipientDescription(recipientDescription);
                    if (unresolved || BusySearchRecipientResultUserstatus.FAILED == userStatus) continue;
                    int nSize = r.getRecipientTimeBlockSize();
                    for (int i = 0; i < nSize; ++i) {
                        BusySearchTimeBlock tb = r.getRecipientTimeBlock(i);
                        TimeBlockInfo timeBlockInfo = new TimeBlockInfo(new TimeInterval(tb.getBeginDate(), tb.getEndDate()), tb.getStartDateText(), tb.getStartTimeText(), tb.getDurationText(), tb.getReasonText(), tb.getFromText(), tb.getSubjectText(), tb.getPlaceText());
                        if (tb.getBusySearchReason() == 2) {
                            this.addTimeIntervalToMap(this.tmBusyTime, recipient, timeBlockInfo);
                            continue;
                        }
                        if (tb.getBusySearchReason() == 4) {
                            this.addTimeIntervalToMap(this.tmWorkshedule, recipient, timeBlockInfo);
                            continue;
                        }
                        if (tb.getBusySearchReason() == 3) {
                            this.addTimeIntervalToMap(this.tmOutOfOfficeTime, recipient, timeBlockInfo);
                            continue;
                        }
                        if (tb.getBusySearchReason() != 1) continue;
                        this.addTimeIntervalToMap(this.tmTentativeTime, recipient, timeBlockInfo);
                    }
                }
            }
        }
        catch (EngineException e) {
            logger.error((Object)e, (Throwable)e);
            ErrorDialog.processThrowable(e);
        }
    }

    private void addTimeIntervalToList(List<TimeBlockInfo> list, TimeBlockInfo theTimeTimeBlockInfo) {
        this.start.setTime(theTimeTimeBlockInfo.getTimeInterval().getStartDateAsDate());
        this.end.setTime(theTimeTimeBlockInfo.getTimeInterval().getEndDateAsDate());
        if (this.start.get(5) == this.end.get(5)) {
            list.add(theTimeTimeBlockInfo);
        } else {
            this.dayEnd.setTime(theTimeTimeBlockInfo.getTimeInterval().getStartDateAsDate());
            this.dayEnd.set(11, 23);
            this.dayEnd.set(12, 59);
            TimeBlockInfo tbi = new TimeBlockInfo(new TimeInterval(theTimeTimeBlockInfo.getTimeInterval().getStartDate(), this.dayEnd.getTimeInMillis()), theTimeTimeBlockInfo.getStartDate(), theTimeTimeBlockInfo.getStartTime(), theTimeTimeBlockInfo.getDuration(), theTimeTimeBlockInfo.getReason(), theTimeTimeBlockInfo.getFrom(), theTimeTimeBlockInfo.getSubject(), theTimeTimeBlockInfo.getPlace());
            list.add(tbi);
            this.dayEnd.add(12, 2);
            theTimeTimeBlockInfo.getTimeInterval().setStartDate(this.dayEnd.getTimeInMillis());
            this.addTimeIntervalToList(list, theTimeTimeBlockInfo);
        }
    }

    private void addTimeIntervalToMap(TreeMap<String, List<TimeBlockInfo>> theMap, IRecipient theRecipient, TimeBlockInfo theTimeBlockInfo) {
        List<TimeBlockInfo> list = theMap.get(ABUtils.getRecipientID(theRecipient));
        if (list == null) {
            list = new ArrayList<TimeBlockInfo>();
        }
        this.addTimeIntervalToList(list, theTimeBlockInfo);
        theMap.put(ABUtils.getRecipientID(theRecipient), list);
    }

    public List<TimeBlockInfo> getOutOfOfficeList(IRecipient theRecipient) {
        return this.tmOutOfOfficeTime.get(ABUtils.getRecipientID(theRecipient));
    }

    public List<TimeBlockInfo> getBusyList(IRecipient theRecipient) {
        return this.tmBusyTime.get(ABUtils.getRecipientID(theRecipient));
    }

    public List<TimeBlockInfo> getTentativeList(IRecipient theRecipient) {
        return this.tmTentativeTime.get(ABUtils.getRecipientID(theRecipient));
    }

    public List<TimeBlockInfo> getWorkshedule(IRecipient theRecipient) {
        return this.tmWorkshedule.get(ABUtils.getRecipientID(theRecipient));
    }

    public boolean isStillWorking() {
        return this.stillWorking;
    }

    public void cancel() {
        this.nativeBusySearch.cancelBusySearch();
    }

    public Date getSearchStartTime() {
        return this.searchStartTime;
    }

    public int getDaysCount() {
        return this.daysCount;
    }

    public int getRecipientSize() {
        int size = 0;
        try {
            size = this.nativeBusySearch.getRecipientSize();
        }
        catch (EngineException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        return size;
    }

    public RecipientDescriptionsList getRecipientDescriptionsList() {
        if (this.recipientDescriptionsList == null) {
            this.recipientDescriptionsList = new RecipientDescriptionsList();
        }
        return this.recipientDescriptionsList;
    }

    public int getCompletedRecipientSize() {
        return this.completedRecipientSize;
    }

    public void addGWBusySearchListener(GWBusySearchListener listener) {
        this.listeners.add(listener);
    }

    public void removeGWBusySearchListener(GWBusySearchListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    private void processBusySearchEvent(BusySearchEvent event) {
        this.stillWorking = event.getStatus() == 0;
        this.completedRecipientSize = event.getCompleted();
        logger.debug((Object)("still working - " + event.getStillWorking()));
        logger.debug((Object)("completed - " + event.getCompleted()));
        logger.debug((Object)("failed - " + event.getFailed()));
        this.init();
        for (GWBusySearchListener listener : this.listeners) {
            listener.busySearchUpdated();
        }
    }

    public boolean removeRecipient(RecipientDescription recipientDescription, JComponent parent) {
        Window window;
        int option;
        if (this.busySearchResultsComplete && this.recipientDescriptionsList != null && !this.recipientDescriptionsList.isEmpty() && (option = JOptionPane.showConfirmDialog(window = SwingUtilities.getWindowAncestor(parent), StringResources.formatString(StringResources.ARE_YOU_SURE_YOU_WANT_TO_REMOVE, recipientDescription.getRecipient().getAddressable().getDisplayName()), StringResources.BUSY_SEARCH, 0, 2)) == 0 && this.recipientDescriptionsList.remove(recipientDescription)) {
            for (GWBusySearchListener searchListener : this.listeners) {
                searchListener.recipientDescriptionRemoved(recipientDescription);
            }
            return true;
        }
        return false;
    }

    public static interface GWBusySearchListener
    extends EventListener {
        public void busySearchUpdated();

        public void recipientDescriptionRemoved(RecipientDescription var1);
    }

    private class NativeBusySearchListener
    implements BusySearchListener {
        private NativeBusySearchListener() {
        }

        public void busySearchResultsComplete(BusySearchEvent e) {
            GWBusySearch.this.busySearchResultsComplete = true;
            GWBusySearch.this.processBusySearchEvent(e);
        }

        public void moreBusySearchResultsAvailable(BusySearchEvent e) {
            GWBusySearch.this.processBusySearchEvent(e);
        }
    }
}

