/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.busysearch;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.mvc.MVCView;
import com.appframework.utils.UIUtils;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.api.enums.RecipientCopyType;
import com.novell.gw.jclient.application.controls.busysearch.BusySearchFrame;
import com.novell.gw.jclient.application.controls.busysearch.RecipientDescription;
import com.novell.gw.jclient.application.controls.busysearch.RecipientDescriptionsList;
import com.novell.gw.jclient.application.controls.busysearch.RecipientTreeController;
import com.novell.gw.jclient.application.controls.folderstree.TextTreeRenderer;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class RecipientTree
extends JTree
implements MVCView {
    private static Logger logger = Logger.getLogger(RecipientTree.class);
    private RecipientTreeController recipientTreeController;
    private RecipientDescriptionsList recipientList = new RecipientDescriptionsList();

    public RecipientTree(MVCController theParentController) {
        this.recipientTreeController = new RecipientTreeController(this, theParentController);
        this.setModel(new RecipientsTreeModel());
        this.setCellRenderer(new RecipientsTreeRenderrer());
        this.setComponentOrientation(UIUtils.getComponentOrientation());
        this.addMouseListener(new NodeCheckListener());
        this.setRootVisible(false);
        this.setMinimumSize(new Dimension(180, 270));
        this.setRowHeight(-1);
    }

    private void refreshView() {
        ((DefaultMutableTreeNode)this.getModel().getRoot()).removeAllChildren();
        ((RecipientsTreeModel)this.getModel()).setTo(this.recipientList.getRecipientDescriptions(RecipientCopyType.getTo()));
        ((RecipientsTreeModel)this.getModel()).setCC(this.recipientList.getRecipientDescriptions(RecipientCopyType.getCc()));
        ((RecipientsTreeModel)this.getModel()).setBC(this.recipientList.getRecipientDescriptions(RecipientCopyType.getBc()));
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.getModel().getRoot();
        for (int i = rootNode.getChildCount() - 1; i > -1; --i) {
            this.expandRow(i);
        }
        this.validate();
    }

    public void setController(MVCController theController) {
        this.recipientTreeController = (RecipientTreeController)theController;
    }

    public MVCController getController() {
        return this.recipientTreeController;
    }

    public void setMVCModel(Object theModel) {
        if (theModel instanceof RecipientDescriptionsList) {
            this.recipientList = (RecipientDescriptionsList)theModel;
            this.refreshView();
        }
    }

    public Object getMVCModel() {
        return null;
    }

    private void doSelectionChanged() {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.getModel().getRoot();
        int nCount1 = rootNode.getChildCount();
        for (int i = 0; i < nCount1; ++i) {
            DefaultMutableTreeNode rootChild = (DefaultMutableTreeNode)rootNode.getChildAt(i);
            int nCount2 = rootChild.getChildCount();
            for (int j = 0; j < nCount2; ++j) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)rootChild.getChildAt(j);
                if (!(child instanceof RecipientNode)) continue;
                RecipientNode rn = (RecipientNode)child;
                RecipientDescription rd = (RecipientDescription)rn.getUserObject();
                RecipientDescription foundRecipientDescription = this.recipientList.getRecipientDescription(rd.getRecipient());
                if (foundRecipientDescription == null) {
                    throw new IllegalArgumentException("recipient description was not found for: " + rd.getRecipient().getAddressable().getEmailAddress());
                }
                foundRecipientDescription.setSelected(rn.isSelected());
            }
        }
        Command com = new Command(690, this.recipientList);
        this.getController().processCommand(com);
    }

    private class NodeCheckListener
    extends MouseAdapter {
        private NodeCheckListener() {
        }

        public void mouseClicked(MouseEvent e) {
            TreeNode parent;
            Object node;
            boolean catched;
            int y;
            int x = e.getX();
            TreePath path = RecipientTree.this.getPathForLocation(x, y = e.getY());
            Rectangle r = RecipientTree.this.getPathBounds(path);
            if (r == null || path == null) {
                return;
            }
            if (UIUtils.getComponentOrientation().isLeftToRight()) {
                catched = x - r.x < 16;
            } else {
                boolean bl = catched = Math.abs(x - (r.x + r.width - 8)) <= 8;
            }
            if (catched && (node = path.getLastPathComponent()) instanceof SelectionNode && ((parent = ((SelectionNode)node).getParent()) instanceof ListNode && ((ListNode)parent).isSelected() || node instanceof ListNode)) {
                SelectionNode selectionNode;
                selectionNode.setSelected(!(selectionNode = (SelectionNode)node).isSelected());
                ((RecipientsTreeModel)RecipientTree.this.getModel()).reload(selectionNode);
                RecipientTree.this.doSelectionChanged();
            }
        }
    }

    private static class TreeLabel
    extends OrientableLabel {
        private boolean isSelected;
        private boolean hasFocus;

        private TreeLabel() {
        }

        public void setBackground(Color color) {
            if (color instanceof ColorUIResource) {
                color = null;
            }
            super.setBackground(color);
        }

        public void paint(Graphics g) {
            String str = this.getText();
            if (str != null && 0 < str.length()) {
                if (this.isSelected) {
                    g.setColor(UIManager.getColor("Tree.selectionBackground"));
                } else {
                    g.setColor(UIManager.getColor("Tree.textBackground"));
                }
                Dimension d = this.getPreferredSize();
                int imageOffset = 0;
                Icon currentI = this.getIcon();
                if (currentI != null) {
                    imageOffset = currentI.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
                }
                if (this.getComponentOrientation().isLeftToRight()) {
                    g.fillRect(imageOffset, 0, d.width - 1 - imageOffset, d.height);
                } else {
                    g.fillRect(0, 0, d.width - 1 - imageOffset, d.height);
                }
                if (this.hasFocus) {
                    if (this.getComponentOrientation().isLeftToRight()) {
                        g.setColor(UIManager.getColor("Tree.selectionBorderColor"));
                        g.drawRect(imageOffset, 0, d.width - 1 - imageOffset, d.height - 1);
                    } else {
                        g.setColor(UIManager.getColor("Tree.selectionBorderColor"));
                        g.drawRect(0, 0, d.width - 1 - imageOffset, d.height - 1);
                    }
                }
            }
            super.paint(g);
        }

        public Dimension getPreferredSize() {
            Dimension retDimension = super.getPreferredSize();
            if (retDimension != null) {
                retDimension = new Dimension(retDimension.width + 3, retDimension.height);
            }
            return retDimension;
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setFocus(boolean hasFocus) {
            this.hasFocus = hasFocus;
        }
    }

    private static class SelectionNode
    extends DefaultMutableTreeNode {
        protected boolean isSelected = true;

        public SelectionNode(Object userObject) {
            super(userObject);
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean theSelected) {
            this.isSelected = theSelected;
        }
    }

    private class ListNode
    extends SelectionNode {
        public ListNode(String listName) {
            super(listName);
        }

        public void setSelected(boolean b) {
            super.setSelected(b);
            if (!this.isLeaf()) {
                int nSize = this.children.size();
                for (int i = 0; i < nSize; ++i) {
                    ((RecipientNode)this.children.elementAt(i)).setSelected(b);
                }
            }
        }

        public void add(MutableTreeNode newChild) {
            if (!(newChild instanceof RecipientNode)) {
                throw new IllegalArgumentException();
            }
            super.add(newChild);
        }
    }

    private class RecipientNode
    extends SelectionNode {
        private int state;

        public RecipientNode(RecipientDescription theDescription) {
            super(theDescription);
            this.state = 1;
            this.state = theDescription.getState();
        }

        public String toString() {
            Object o = this.getUserObject();
            if (o instanceof RecipientDescription && ((RecipientDescription)o).getRecipient() != null) {
                return ((RecipientDescription)o).getRecipient().getAddressable().getDisplayName();
            }
            return "";
        }

        public int getState() {
            return this.state;
        }
    }

    private class RecipientsTreeRenderrer
    extends OrientablePanel
    implements TreeCellRenderer,
    TextTreeRenderer {
        private int size;
        private JCheckBox check = new OrientableCheckBox();
        private TreeLabel lbText = new TreeLabel();
        private ImageIcon imgBusy;
        private ImageIcon imgOutOfOffice;
        private ImageIcon imgTentative;
        private ImageIcon imgAvailable;

        public RecipientsTreeRenderrer() {
            this.setLayout(new FlowLayout(3, 0, 0));
            this.setBackground(Color.WHITE);
            this.add(this.check);
            this.add(this.lbText);
            this.check.setBackground(UIManager.getColor("Tree.textBackground"));
            this.check.setPreferredSize(new Dimension(this.check.getPreferredSize().width, PLAFChanger.getTreeRowHeight()));
            this.lbText.setForeground(UIManager.getColor("Tree.textForeground"));
            this.imgBusy = new ImageIcon(this.getSquareRectangleAsImage(BusySearchFrame.COLOR_BUSY));
            this.imgOutOfOffice = new ImageIcon(this.getSquareRectangleAsImage(BusySearchFrame.COLOR_OUT_OF_OFFICE));
            this.imgTentative = new ImageIcon(this.getSquareRectangleAsImage(BusySearchFrame.COLOR_TENTATIVE));
            this.imgAvailable = new ImageIcon(this.getSquareRectangleAsImage(BusySearchFrame.COLOR_AVAILABLE));
        }

        private Image getSquareRectangleAsImage(Color theColor) {
            this.size = 12;
            BufferedImage bi = new BufferedImage(this.size, this.size, 6);
            Graphics2D g = bi.createGraphics();
            g.setColor(theColor);
            g.fillRect(0, 0, this.size, this.size);
            if (!theColor.equals(BusySearchFrame.COLOR_AVAILABLE)) {
                g.setColor(Color.black);
                g.drawRect(0, 0, this.size - 1, this.size - 1);
            }
            return bi;
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            String stringValue = tree.convertValueToText(value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof SelectionNode) {
                this.check.setSelected(((SelectionNode)value).isSelected());
            }
            if (value instanceof RecipientNode) {
                TreeNode parent = ((RecipientNode)value).getParent();
                if (parent instanceof ListNode) {
                    boolean parentSelected = ((ListNode)parent).isSelected();
                    this.lbText.setSelected(parentSelected && selected);
                }
                this.lbText.setFont(tree.getFont());
                switch (((RecipientNode)value).getState()) {
                    case 1: {
                        this.lbText.setIcon(this.imgTentative);
                        break;
                    }
                    case 0: {
                        this.lbText.setIcon(this.imgAvailable);
                        break;
                    }
                    case 3: {
                        this.lbText.setIcon(this.imgOutOfOffice);
                        break;
                    }
                    case 4: {
                        this.lbText.setIcon(this.imgOutOfOffice);
                        break;
                    }
                    case 2: {
                        this.lbText.setIcon(this.imgBusy);
                        break;
                    }
                    default: {
                        this.lbText.setIcon(this.imgAvailable);
                        break;
                    }
                }
            } else if (value instanceof ListNode) {
                this.lbText.setFont(Utils.deriveFont(tree.getFont(), 1));
                this.lbText.setSelected(selected);
                this.setEnabled(true);
                this.lbText.setEnabled(true);
                if (expanded) {
                    this.lbText.setIcon(ImageResources.ICON_FOLDER_OPENED);
                } else {
                    this.lbText.setIcon(ImageResources.ICON_FOLDER_CLOSED);
                }
            }
            this.lbText.setText(stringValue);
            this.lbText.setFocus(hasFocus);
            return this;
        }

        public int getTextX() {
            return 0;
        }
    }

    private class RecipientsTreeModel
    extends DefaultTreeModel {
        private DefaultMutableTreeNode root;
        private ListNode toNode;
        private ListNode ccNode;
        private ListNode bcNode;

        public RecipientsTreeModel() {
            super(null);
            this.root = new DefaultMutableTreeNode();
            this.toNode = new ListNode(StringResources.TO);
            this.ccNode = new ListNode(StringResources.CC);
            this.bcNode = new ListNode(StringResources.BC);
            this.setRoot(this.root);
        }

        private void setListNode(ListNode theListNode, List theList) {
            if (theListNode == null || theList.isEmpty()) {
                return;
            }
            theListNode.removeAllChildren();
            theListNode.setSelected(true);
            int nSize = theList.size();
            for (int i = 0; i < nSize; ++i) {
                Object o = theList.get(i);
                if (!(o instanceof RecipientDescription)) continue;
                RecipientDescription theDescription = (RecipientDescription)o;
                RecipientNode newChild = new RecipientNode(theDescription);
                newChild.setSelected(theDescription.isSelected());
                theListNode.add(newChild);
            }
            this.root.add(theListNode);
            this.reload(this.root);
        }

        public Object getRoot() {
            return this.root;
        }

        public void setTo(List theList) {
            this.setListNode(this.toNode, theList);
        }

        public void setCC(List theList) {
            this.setListNode(this.ccNode, theList);
        }

        public void setBC(List theList) {
            this.setListNode(this.bcNode, theList);
        }
    }
}

